/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.Workflow;
import uk.org.ogsadai.client.toolkit.activity.RequestAndStatusHandler;
import uk.org.ogsadai.client.toolkit.activity.RequestBuilder;
import uk.org.ogsadai.client.toolkit.exception.ActivityIllegalStateException;
import uk.org.ogsadai.resource.request.RequestStatus;

public class PipelineWorkflow
implements Workflow,
RequestAndStatusHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private List mActivities = new LinkedList();

    public void add(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        this.mActivities.add(activity);
    }

    public List getActivities() {
        return new LinkedList(this.mActivities);
    }

    public RequestAndStatusHandler getRequestAndStatusHandler() {
        return this;
    }

    public void buildRequest(RequestBuilder requestBuilder) throws ActivityIllegalStateException {
        requestBuilder.startPipeline();
        Iterator iterator = this.mActivities.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            activity.getRequestAndStatusHandler().buildRequest(requestBuilder);
        }
        requestBuilder.endPipeline();
    }

    public void processRequestStatus(RequestStatus requestStatus) {
        Iterator iterator = this.mActivities.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            activity.getRequestAndStatusHandler().processRequestStatus(requestStatus);
        }
    }

    public void setServer(Server server) {
        Iterator iterator = this.mActivities.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            activity.getRequestAndStatusHandler().setServer(server);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PipelineWorkflow {\n");
        Iterator iterator = this.mActivities.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            String string = activity.toString();
            string = string.replaceAll("\n", "\n  ");
            string = string.replaceAll("\n  $", "\n");
            stringBuffer.append("  ");
            stringBuffer.append(string);
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

