/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.Workflow;
import uk.org.ogsadai.client.toolkit.activity.RequestAndStatusHandler;
import uk.org.ogsadai.client.toolkit.activity.RequestBuilder;
import uk.org.ogsadai.client.toolkit.exception.ActivityIllegalStateException;
import uk.org.ogsadai.resource.request.RequestStatus;

public class ParallelWorkflow
implements Workflow,
RequestAndStatusHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private List mChildren = new LinkedList();

    public void add(Workflow workflow) {
        if (workflow == null) {
            throw new IllegalArgumentException("workflow must not be null");
        }
        this.mChildren.add(workflow);
    }

    public RequestAndStatusHandler getRequestAndStatusHandler() {
        return this;
    }

    public void buildRequest(RequestBuilder requestBuilder) throws ActivityIllegalStateException {
        requestBuilder.startParallel();
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            Workflow workflow = (Workflow)iterator.next();
            workflow.getRequestAndStatusHandler().buildRequest(requestBuilder);
        }
        requestBuilder.endParallel();
    }

    public void processRequestStatus(RequestStatus requestStatus) {
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            Workflow workflow = (Workflow)iterator.next();
            workflow.getRequestAndStatusHandler().processRequestStatus(requestStatus);
        }
    }

    public void setServer(Server server) {
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            Workflow workflow = (Workflow)iterator.next();
            workflow.getRequestAndStatusHandler().setServer(server);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ParallelWorkflow {\n");
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            Workflow workflow = (Workflow)iterator.next();
            String string = workflow.toString();
            string = string.replaceAll("\n", "\n  ");
            string = string.replaceAll("\n  $", "\n");
            stringBuffer.append("  ");
            stringBuffer.append(string);
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

