/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.io.IOException;
import java.io.Reader;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.exception.DataException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataStreamEndException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueVisitor;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.exception.DAIException;

public class DataValueReader
extends Reader
implements DataValueVisitor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private DataValueIterator mIterator;
    private boolean mIsFinished;
    private boolean mIsClosed;
    private char[] mChars;
    private int mNextCharIndex;
    private int mListDepth;
    private int mCurrentListDepth;
    private DAIException mException;

    public DataValueReader(DataValueIterator dataValueIterator, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("listDepth must be >= 0");
        }
        if (dataValueIterator == null) {
            throw new IllegalArgumentException("iterator must not be null");
        }
        this.mIterator = dataValueIterator;
        this.mIsClosed = false;
        this.mChars = null;
        this.mIsFinished = false;
        this.mListDepth = n;
        this.mCurrentListDepth = 0;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.mIsClosed) {
            throw new IOException("Stream closed");
        }
        this.checkException();
        try {
            while (!(this.mIsFinished || this.mChars != null && this.mNextCharIndex < this.mChars.length)) {
                if (this.mChars != null && this.mListDepth == 0) {
                    this.mIsFinished = true;
                    continue;
                }
                if (!this.mIterator.hasNext()) {
                    throw this.createIOException(new UnexpectedDataStreamEndException());
                }
                DataValue dataValue = this.mIterator.next();
                dataValue.accept((DataValueVisitor)this);
                this.checkException();
            }
        }
        catch (DataException dataException) {
            throw this.createIOException(dataException);
        }
        if (this.mIsFinished) {
            return -1;
        }
        int n3 = this.mChars.length - this.mNextCharIndex;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(this.mChars, this.mNextCharIndex, cArray, n, n3);
        this.mNextCharIndex += n3;
        return n3;
    }

    public void close() throws IOException {
        if (!this.mIsClosed) {
            try {
                while (!this.mIsFinished && this.mIterator.hasNext()) {
                    DataValue dataValue = this.mIterator.next();
                    dataValue.accept((DataValueVisitor)this);
                    this.checkException();
                }
            }
            catch (DAIException dAIException) {
                throw this.createIOException(dAIException);
            }
        }
        this.mIsClosed = true;
    }

    public void visitListBegin(ListBegin listBegin) {
        ++this.mCurrentListDepth;
        if (this.mCurrentListDepth > this.mListDepth) {
            this.mException = new UnexpectedDataValueException((DataValue)listBegin);
        }
    }

    public void visitListEnd(ListEnd listEnd) {
        --this.mCurrentListDepth;
        if (this.mCurrentListDepth < 0) {
            this.mException = new UnexpectedDataValueException((DataValue)listEnd);
        } else if (this.mCurrentListDepth == 0) {
            this.mIsFinished = true;
        }
    }

    public void visitCharData(CharData charData) {
        this.mChars = charData.getChars();
        this.mNextCharIndex = 0;
    }

    public void visitStringData(StringData stringData) {
        this.mChars = stringData.toString().toCharArray();
        this.mNextCharIndex = 0;
    }

    public void visitBinaryData(BinaryData binaryData) {
        this.mException = new UnexpectedDataValueException((DataValue)binaryData);
    }

    public void visitLongData(LongData longData) {
        this.mException = new UnexpectedDataValueException((DataValue)longData);
    }

    public void visitIntegerData(IntegerData integerData) {
        this.mException = new UnexpectedDataValueException((DataValue)integerData);
    }

    public void visitDoubleData(DoubleData doubleData) {
        this.mException = new UnexpectedDataValueException((DataValue)doubleData);
    }

    public void visitFloatData(FloatData floatData) {
        this.mException = new UnexpectedDataValueException((DataValue)floatData);
    }

    public void visitBooleanData(BooleanData booleanData) {
        this.mException = new UnexpectedDataValueException((DataValue)booleanData);
    }

    public void visitDateData(DateData dateData) {
        this.mException = new UnexpectedDataValueException((DataValue)dateData);
    }

    private void checkException() throws IOException {
        if (this.mException != null) {
            throw this.createIOException(this.mException);
        }
    }

    private IOException createIOException(DAIException dAIException) {
        IOException iOException = new IOException();
        iOException.initCause(dAIException);
        return iOException;
    }
}

