/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.io.IOException;
import java.io.InputStream;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.exception.DataException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueVisitor;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.exception.DAIException;

public class DataValueInputStream
extends InputStream
implements DataValueVisitor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private DataValueIterator mIterator;
    private boolean mIsFinished;
    private boolean mIsClosed;
    private byte[] mSingleByte = new byte[1];
    private byte[] mBytes;
    private int mNextByteIndex;
    private int mListDepth;
    private int mCurrentListDepth;
    private DAIException mException;

    public DataValueInputStream(DataValueIterator dataValueIterator, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("listDepth must be >= 0");
        }
        if (dataValueIterator == null) {
            throw new IllegalArgumentException("dataIterator must not be null");
        }
        this.mIterator = dataValueIterator;
        this.mIsClosed = false;
        this.mBytes = null;
        this.mIsFinished = false;
        this.mListDepth = n;
        this.mCurrentListDepth = 0;
    }

    public int available() {
        if (this.mBytes != null) {
            return this.mBytes.length - this.mNextByteIndex;
        }
        return 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkException();
        try {
            while (!(this.mIsFinished || this.mBytes != null && this.mNextByteIndex < this.mBytes.length)) {
                if (this.mBytes != null && this.mListDepth == 0) {
                    this.mIsFinished = true;
                    continue;
                }
                if (!this.mIterator.hasNext()) {
                    this.mIsFinished = true;
                    continue;
                }
                DataValue dataValue = this.mIterator.next();
                dataValue.accept((DataValueVisitor)this);
                this.checkException();
            }
        }
        catch (DataException dataException) {
            this.throwIOException(dataException);
        }
        if (this.mIsFinished) {
            return -1;
        }
        int n3 = this.mBytes.length - this.mNextByteIndex;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(this.mBytes, this.mNextByteIndex, byArray, n, n3);
        this.mNextByteIndex += n3;
        return n3;
    }

    public int read() throws IOException {
        int n = this.read(this.mSingleByte, 0, 1);
        if (n > 0) {
            return this.mSingleByte[0];
        }
        return -1;
    }

    public void close() throws IOException {
        this.mIsClosed = true;
    }

    public void visitListBegin(ListBegin listBegin) {
        ++this.mCurrentListDepth;
        if (this.mCurrentListDepth > this.mListDepth) {
            this.mException = new UnexpectedDataValueException((DataValue)listBegin);
        }
    }

    public void visitListEnd(ListEnd listEnd) {
        --this.mCurrentListDepth;
        if (this.mCurrentListDepth < 0) {
            this.mException = new UnexpectedDataValueException((DataValue)listEnd);
        } else if (this.mCurrentListDepth == 0) {
            this.mIsFinished = true;
        }
    }

    public void visitBinaryData(BinaryData binaryData) {
        this.mBytes = binaryData.getBytes();
        this.mNextByteIndex = 0;
    }

    public void visitStringData(StringData stringData) {
        this.mBytes = stringData.toString().getBytes();
        this.mNextByteIndex = 0;
    }

    public void visitCharData(CharData charData) {
        this.mException = new UnexpectedDataValueException((DataValue)charData);
    }

    public void visitLongData(LongData longData) {
        this.mException = new UnexpectedDataValueException((DataValue)longData);
    }

    public void visitIntegerData(IntegerData integerData) {
        this.mException = new UnexpectedDataValueException((DataValue)integerData);
    }

    public void visitDoubleData(DoubleData doubleData) {
        this.mException = new UnexpectedDataValueException((DataValue)doubleData);
    }

    public void visitFloatData(FloatData floatData) {
        this.mException = new UnexpectedDataValueException((DataValue)floatData);
    }

    public void visitBooleanData(BooleanData booleanData) {
        this.mException = new UnexpectedDataValueException((DataValue)booleanData);
    }

    public void visitDateData(DateData dateData) {
        this.mException = new UnexpectedDataValueException((DataValue)dateData);
    }

    private void checkException() throws IOException {
        if (this.mException != null) {
            this.throwIOException(this.mException);
        }
    }

    private void throwIOException(DAIException dAIException) throws IOException {
        IOException iOException = new IOException();
        iOException.initCause(dAIException);
        throw iOException;
    }
}

