/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.util.Date;
import java.util.NoSuchElementException;
import uk.org.ogsadai.client.toolkit.DataSourceResource;
import uk.org.ogsadai.client.toolkit.DataStreamData;
import uk.org.ogsadai.client.toolkit.DataStreamStatus;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.client.toolkit.resource.SimpleDataStreamData;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueGetObjectVisitor;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.exception.DAIException;

public class DataSourceDataValueIterator
implements DataValueIterator {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final int DEFAULT_BLOCKS_PER_CALL = 50;
    private DataSourceResource mDataSource;
    private DataStreamData mData;
    private int mDataIndex;
    private int mDataBlocksPerCall;
    private DataValueGetObjectVisitor mDataValueGetObjectVisitor;

    public DataSourceDataValueIterator(DataSourceResource dataSourceResource) {
        this.mDataSource = dataSourceResource;
        this.mData = new SimpleDataStreamData(new DataValue[0], DataStreamStatus.OPEN);
        this.mDataIndex = 0;
        this.mDataBlocksPerCall = 50;
    }

    public void setNumBlocksPerCall(int n) {
        this.mDataBlocksPerCall = n;
    }

    public boolean hasNext() throws DataStreamErrorException, DataSourceUsageException {
        while (this.mDataIndex >= this.mData.getDataValues().length) {
            DataStreamStatus dataStreamStatus = this.mData.getStreamStatus();
            if (dataStreamStatus == DataStreamStatus.CLOSED) {
                return false;
            }
            if (dataStreamStatus == DataStreamStatus.CLOSED_DUE_TO_ERROR) {
                throw new DataStreamErrorException();
            }
            this.getDataFromSource();
        }
        return true;
    }

    public DataValue next() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (this.hasNext()) {
            return this.mData.getDataValues()[this.mDataIndex++];
        }
        throw new NoSuchElementException();
    }

    public boolean nextAsBoolean() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof BooleanData) {
            return ((BooleanData)dataValue).getBoolean();
        }
        throw new UnexpectedDataValueException(BooleanData.class, dataValue);
    }

    public byte[] nextAsByteArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof BinaryData) {
            return ((BinaryData)dataValue).getBytes();
        }
        throw new UnexpectedDataValueException(BinaryData.class, dataValue);
    }

    public char[] nextAsCharArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof CharData) {
            return ((CharData)dataValue).getChars();
        }
        throw new UnexpectedDataValueException(CharData.class, dataValue);
    }

    public String nextAsString() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof StringData) {
            return ((StringData)dataValue).toString();
        }
        throw new UnexpectedDataValueException(StringData.class, dataValue);
    }

    public Date nextAsDate() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof DateData) {
            return ((DateData)dataValue).getDate();
        }
        throw new UnexpectedDataValueException(DateData.class, dataValue);
    }

    public double nextAsDouble() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof DoubleData) {
            return ((DoubleData)dataValue).getDouble();
        }
        throw new UnexpectedDataValueException(DoubleData.class, dataValue);
    }

    public float nextAsFloat() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof FloatData) {
            return ((FloatData)dataValue).getFloat();
        }
        throw new UnexpectedDataValueException(FloatData.class, dataValue);
    }

    public int nextAsInt() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof IntegerData) {
            return ((IntegerData)dataValue).getInteger();
        }
        throw new UnexpectedDataValueException(IntegerData.class, dataValue);
    }

    public long nextAsLong() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = this.next();
        if (dataValue instanceof LongData) {
            return ((LongData)dataValue).getLong();
        }
        throw new UnexpectedDataValueException(LongData.class, dataValue);
    }

    private void getDataFromSource() throws DataSourceUsageException {
        try {
            this.mData = this.mDataSource.getDataValues(this.mDataBlocksPerCall);
            this.mDataIndex = 0;
        }
        catch (DAIException dAIException) {
            throw new DataSourceUsageException(dAIException);
        }
    }
}

