/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.util.NoSuchElementException;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueGetObjectVisitor;
import uk.org.ogsadai.data.DataValueVisitor;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;

public class DataListIterator
implements DataIterator {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007.";
    private final DataValueIterator mSourceIterator;
    private final Class mOutputValueClass;
    private boolean mListStartFound;
    private boolean mListEndFound;
    private DataValue mLookAhead;

    public DataListIterator(DataValueIterator dataValueIterator, Class clazz) {
        if (dataValueIterator == null) {
            throw new IllegalArgumentException("dataIterator cannot be null");
        }
        this.mSourceIterator = dataValueIterator;
        this.mOutputValueClass = clazz;
        this.mListStartFound = false;
        this.mListEndFound = false;
    }

    public boolean hasNext() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (this.mListEndFound) {
            return false;
        }
        DataValue dataValue = this.peakAtNextDataValue();
        if (!this.mListStartFound) {
            if (dataValue == ListBegin.VALUE) {
                this.mListStartFound = true;
                dataValue = this.readNextDataValue();
                dataValue = this.peakAtNextDataValue();
            } else {
                throw new UnexpectedDataValueException(ListBegin.class, dataValue);
            }
        }
        if (dataValue == null) {
            return false;
        }
        if (dataValue == ListEnd.VALUE) {
            this.mListEndFound = true;
            this.readNextDataValue();
            return false;
        }
        return true;
    }

    public Object next() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DataValue dataValue = this.readNextDataValue();
        DataValueGetObjectVisitor dataValueGetObjectVisitor = new DataValueGetObjectVisitor();
        dataValue.accept((DataValueVisitor)dataValueGetObjectVisitor);
        Object object = dataValueGetObjectVisitor.getObject();
        if (!this.mOutputValueClass.isInstance(object)) {
            throw new UnexpectedDataValueException(dataValue);
        }
        return object;
    }

    private DataValue peakAtNextDataValue() throws DataStreamErrorException, DataSourceUsageException, UnexpectedDataValueException {
        if (this.mLookAhead == null) {
            this.mLookAhead = this.readNextDataValue();
        }
        return this.mLookAhead;
    }

    private DataValue readNextDataValue() throws DataStreamErrorException, DataSourceUsageException, UnexpectedDataValueException {
        if (this.mLookAhead != null) {
            DataValue dataValue = this.mLookAhead;
            this.mLookAhead = null;
            return dataValue;
        }
        if (this.mSourceIterator.hasNext()) {
            return this.mSourceIterator.next();
        }
        return null;
    }
}

