/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.net.MalformedURLException;
import java.net.URL;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.exception.InvalidURIException;
import uk.org.ogsadai.resource.ResourceType;

public abstract class AbstractServer
implements Server {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    protected URL mBaseURL;
    protected String mDRESName = "DataRequestExecutionService";
    protected String mDRISName = "DataResourceInformationService";
    protected String mDSoSName = "DataSourceService";
    protected String mDSiSName = "DataSinkService";
    protected String mSMSName = "SessionManagementService";
    protected String mRMSName = "RequestManagementService";
    private boolean mConfigAlteredFlag = false;

    public void setDefaultBaseServicesURL(URL uRL) {
        this.mBaseURL = uRL;
        this.mConfigAlteredFlag = true;
    }

    public URL getDefaultBaseServicesURL() {
        return this.mBaseURL;
    }

    public void setDefaultDataRequestExecutionServiceName(String string) {
        this.mDRESName = string;
        this.mConfigAlteredFlag = true;
    }

    public String getDefaultDataRequestExecutionServiceName() {
        return this.mDRESName;
    }

    public URL getDefaultDataRequestExecutionServiceURL() throws InvalidURIException {
        return this.getDefaultServiceURL(ResourceType.DATA_REQUEST_EXECUTION_RESOURCE);
    }

    public void setDefaultDataResourceInformationServiceName(String string) {
        this.mDRISName = string;
        this.mConfigAlteredFlag = true;
    }

    public String getDefaultDataResourceInformationServiceName() {
        return this.mDRISName;
    }

    public URL getDefaultDataResourceInformationServiceURL() throws InvalidURIException {
        return this.getDefaultServiceURL(ResourceType.DATA_RESOURCE);
    }

    public void setDefaultDataSourceServiceName(String string) {
        this.mDSoSName = string;
        this.mConfigAlteredFlag = true;
    }

    public String getDefaultDataSourceServiceName() {
        return this.mDSoSName;
    }

    public URL getDefaultDataSourceServiceURL() throws InvalidURIException {
        return this.getDefaultServiceURL(ResourceType.DATA_SOURCE);
    }

    public void setDefaultDataSinkServiceName(String string) {
        this.mDSiSName = string;
        this.mConfigAlteredFlag = true;
    }

    public String getDefaultDataSinkServiceName() {
        return this.mDSiSName;
    }

    public URL getDefaultDataSinkServiceURL() throws InvalidURIException {
        return this.getDefaultServiceURL(ResourceType.DATA_SINK);
    }

    public void setDefaultSessionManagementServiceName(String string) {
        this.mSMSName = string;
        this.mConfigAlteredFlag = true;
    }

    public String getDefaultSessionManagementServiceName() {
        return this.mSMSName;
    }

    public URL getDefaultSessionManagementServiceURL() throws InvalidURIException {
        return this.getDefaultServiceURL(ResourceType.SESSION);
    }

    public void setDefaultRequestManagementServiceName(String string) {
        this.mRMSName = string;
        this.mConfigAlteredFlag = true;
    }

    public String getDefaultRequestManagementServiceName() {
        return this.mRMSName;
    }

    public URL getDefaultRequestManagementServiceURL() throws InvalidURIException {
        return this.getDefaultServiceURL(ResourceType.SESSION);
    }

    public URL getDefaultServiceURL(ResourceType resourceType) throws InvalidURIException, IllegalArgumentException {
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType must not be null");
        }
        String string = null;
        if (ResourceType.DATA_REQUEST_EXECUTION_RESOURCE.equals((Object)resourceType)) {
            string = this.mDRESName;
        } else if (ResourceType.DATA_RESOURCE.equals((Object)resourceType)) {
            string = this.mDRISName;
        } else if (ResourceType.DATA_SOURCE.equals((Object)resourceType)) {
            string = this.mDSoSName;
        } else if (ResourceType.DATA_SINK.equals((Object)resourceType)) {
            string = this.mDSiSName;
        } else if (ResourceType.SESSION.equals((Object)resourceType)) {
            string = this.mSMSName;
        } else if (ResourceType.REQUEST.equals((Object)resourceType)) {
            string = this.mRMSName;
        }
        URL uRL = null;
        try {
            uRL = this.mBaseURL.toString().lastIndexOf("/") < this.mBaseURL.toString().length() - 1 ? new URL(this.mBaseURL.toString() + "/") : this.mBaseURL;
            return new URL(uRL.toExternalForm() + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidURIException(uRL.toExternalForm() + string);
        }
    }

    protected void resetConfigAlteredFlag() {
        this.mConfigAlteredFlag = false;
    }

    protected boolean getHasConfigAltered() {
        return this.mConfigAlteredFlag;
    }
}

