/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import javax.xml.rpc.Stub;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ContainerPDPConfig;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.authorization.ServicePropertiesPDPConfig;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.authorization.PDPConfig;

public class PDPUtils {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$util$PDPUtils == null ? (class$org$globus$wsrf$impl$security$util$PDPUtils = PDPUtils.class$("org.globus.wsrf.impl.security.util.PDPUtils")) : class$org$globus$wsrf$impl$security$util$PDPUtils).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$util$PDPUtils;

    public static void setTrustedTargets(Stub stub, HashMap trustedTargets) {
        stub._setProperty("org.globus.security.target.trusted", (Object)trustedTargets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashMap loadTrustedTargets(String fileName) throws Exception {
        HashMap<String, String> allowedSubjects = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(fileName));
            String subject = in.readLine();
            while (subject != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding trusted target: " + subject));
                }
                allowedSubjects.put(subject, subject);
                subject = in.readLine();
            }
            Object var5_4 = null;
            if (in == null) return allowedSubjects;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return allowedSubjects;
        }
        catch (Exception e) {}
        return allowedSubjects;
    }

    public static ServiceAuthorizationChain getServiceAuthzChain(PDPConfig config, String id) throws ConfigException {
        ServiceAuthorizationChain authzChain = new ServiceAuthorizationChain();
        try {
            authzChain.initialize(config, null, id);
        }
        catch (InitializeException exp) {
            throw new ConfigException(exp);
        }
        return authzChain;
    }

    public static ServiceAuthorizationChain getServiceAuthzChain(String authzChain, String servicePath) throws ConfigException {
        if (authzChain == null) {
            return null;
        }
        String pdpChain = AuthUtil.substitutePDPNames(authzChain);
        MessageContext messageContext = MessageContext.getCurrentContext();
        ServicePropertiesPDPConfig config = new ServicePropertiesPDPConfig(messageContext, servicePath, pdpChain);
        return PDPUtils.getServiceAuthzChain(config, servicePath);
    }

    public static ServiceAuthorizationChain getContainerAuthzChain(String authzChain, String id) throws ConfigException {
        if (authzChain == null) {
            return null;
        }
        String pdpChain = AuthUtil.substitutePDPNames(authzChain);
        MessageContext messageContext = MessageContext.getCurrentContext();
        ContainerPDPConfig config = new ContainerPDPConfig(pdpChain, messageContext);
        return PDPUtils.getServiceAuthzChain(config, id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

