/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.globus.wsrf.impl.security.descriptor.AuthMethodParser;
import org.globus.wsrf.impl.security.descriptor.AuthMethodParserCallback;
import org.globus.wsrf.impl.security.descriptor.MethodParser;
import org.globus.wsrf.impl.security.descriptor.RunAsParser;
import org.globus.wsrf.impl.security.descriptor.RunAsParserCallback;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;

public class ServiceSecurityDescriptor
extends SecurityDescriptor
implements RunAsParserCallback,
AuthMethodParserCallback {
    private int defaultRunAsType = -1;
    private Map methodRunAsTypes;
    private List defaultAuthMethods = null;
    private Map methodAuthMethods;

    public ServiceSecurityDescriptor() {
        this.register(MethodParser.QNAME, new MethodParser(this));
        this.register(RunAsParser.QNAME, new RunAsParser(this));
        this.register(AuthMethodParser.QNAME, new AuthMethodParser(this));
        this.methodRunAsTypes = new HashMap();
        this.methodAuthMethods = new HashMap();
    }

    public void setRunAsType(int runAsType) throws SecurityDescriptorException {
        this.setRunAsType(runAsType, false);
    }

    public void setRunAsType(int runAsType, boolean overwrite) throws SecurityDescriptorException {
        if (!overwrite && this.defaultRunAsType != -1) {
            throw new SecurityDescriptorException(i18n.getMessage("defaultRunAs"));
        }
        this.defaultRunAsType = runAsType;
    }

    public void setMethodRunAsType(QName method, int identity) throws SecurityDescriptorException {
        this.setMethodRunAsType(method, identity, false);
    }

    public void setMethodRunAsType(QName method, int identity, boolean overwrite) throws SecurityDescriptorException {
        if (method == null) {
            throw new IllegalArgumentException("method == null");
        }
        Integer ret = this.methodRunAsTypes.put(method, new Integer(identity));
        if (!overwrite && ret != null) {
            throw new SecurityDescriptorException(i18n.getMessage("methodRunAs", (Object)method));
        }
    }

    public void setAuthMethods(List authMethods) throws SecurityDescriptorException {
        this.setAuthMethods(authMethods, false);
    }

    public void setAuthMethods(List authMethods, boolean overwrite) throws SecurityDescriptorException {
        if (!overwrite && this.defaultAuthMethods != null) {
            throw new SecurityDescriptorException(i18n.getMessage("defaultAuthMethods"));
        }
        this.defaultAuthMethods = authMethods;
    }

    public void setMethodAuthMethods(QName method, List authMethods) throws SecurityDescriptorException {
        this.setMethodAuthMethods(method, authMethods, false);
    }

    public void setMethodAuthMethods(QName method, List authMethods, boolean overwrite) throws SecurityDescriptorException {
        if (authMethods == null) {
            throw new IllegalArgumentException("authMethods == null");
        }
        List obj = this.methodAuthMethods.put(method, authMethods);
        if (!overwrite && obj != null) {
            throw new SecurityDescriptorException(i18n.getMessage("methodAuthMethods", (Object)method));
        }
    }

    public int getDefaultRunAsType() {
        return this.defaultRunAsType;
    }

    public int getRunAsType(QName method) {
        Integer runAsType = (Integer)this.methodRunAsTypes.get(method);
        if (runAsType == null) {
            QName methodName = new QName(method.getLocalPart());
            runAsType = (Integer)this.methodRunAsTypes.get(methodName);
        }
        return runAsType == null ? -1 : runAsType;
    }

    public List getDefaultAuthMethods() {
        return this.defaultAuthMethods;
    }

    public List getAuthMethods(QName method) {
        List methods = (List)this.methodAuthMethods.get(method);
        if (methods == null) {
            QName methodName = new QName(method.getLocalPart());
            methods = (List)this.methodAuthMethods.get(methodName);
        }
        return methods;
    }

    public String getRequiredAuthMethodsErrorMessage(List methods, QName opName) {
        return i18n.getMessage("authRequired", new Object[]{AuthMethodParser.getAuthMethodsAsString(methods), opName});
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.defaultRunAsType);
        oos.writeObject(this.methodRunAsTypes);
        oos.writeObject(this.defaultAuthMethods);
        oos.writeObject(this.methodAuthMethods);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.defaultRunAsType = ois.readInt();
        this.methodRunAsTypes = (Map)ois.readObject();
        this.defaultAuthMethods = (List)ois.readObject();
        this.methodAuthMethods = (Map)ois.readObject();
    }
}

