/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptor;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.utils.XmlUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;

public abstract class SecurityConfig {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$descriptor$SecurityConfig == null ? (class$org$globus$wsrf$impl$security$descriptor$SecurityConfig = SecurityConfig.class$("org.globus.wsrf.impl.security.descriptor.SecurityConfig")) : class$org$globus$wsrf$impl$security$descriptor$SecurityConfig).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$descriptor$SecurityConfig == null ? (class$org$globus$wsrf$impl$security$descriptor$SecurityConfig = SecurityConfig.class$("org.globus.wsrf.impl.security.descriptor.SecurityConfig")) : class$org$globus$wsrf$impl$security$descriptor$SecurityConfig).getClassLoader());
    public static final String CONT_SEC_DESCRIPTOR = "containerSecDesc";
    public static final String SECURITY_PROP = "securityProp";
    public static final String SECURITY_DESCRIPTOR = "securityDescriptor";
    public static final String SECURITY_INIT_NAME = "securityInitialied";
    String jndiPathName = null;
    String descriptorFile = null;
    SecurityDescriptor desc = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$descriptor$SecurityConfig;

    SecurityConfig() {
    }

    protected SecurityConfig(String jndiPathName, String descFileName) {
        this.jndiPathName = jndiPathName;
        this.descriptorFile = descFileName;
    }

    protected SecurityConfig(SecurityDescriptor desc) {
        this.desc = desc;
    }

    protected SecurityConfig(String jndiPathName, SecurityDescriptor desc) {
        this.jndiPathName = jndiPathName;
        this.desc = desc;
    }

    protected abstract void initSecurityDescriptor(Document var1) throws ConfigException;

    protected abstract void initCredentials() throws ConfigException;

    protected abstract void loadAuthorization() throws ConfigException;

    protected static void storeSubject(Subject subject, String jndiPath, SecurityDescriptor desc) throws ConfigException {
        if (desc != null) {
            desc.setSubject(subject);
            SecurityConfig.storeSecurityDescriptor(desc, jndiPath);
        }
    }

    protected static void storeGridMap(GridMap gridmap, String jndiPath, SecurityDescriptor desc) throws ConfigException {
        if (desc != null) {
            desc.setGridMap(gridmap);
            SecurityConfig.storeSecurityDescriptor(desc, jndiPath);
        }
    }

    protected static void storeAuthzChain(ServiceAuthorizationChain authzChain, String jndiPath, SecurityDescriptor desc) throws ConfigException {
        if (desc != null) {
            desc.setAuthzChain(authzChain);
            SecurityConfig.storeSecurityDescriptor(desc, jndiPath);
        }
    }

    protected static void storeSecurityDescriptor(SecurityDescriptor desc, String jndiPath) throws ConfigException {
        SecurityConfig.putObject(SECURITY_DESCRIPTOR, desc, jndiPath);
    }

    protected static Subject retrieveSubject(String jndiPath) throws ConfigException {
        SecurityDescriptor desc = SecurityConfig.retrieveSecurityDescriptor(jndiPath);
        return desc == null ? null : desc.getSubject();
    }

    protected static GridMap retrieveGridMap(String jndiPath) throws ConfigException {
        SecurityDescriptor desc = SecurityConfig.retrieveSecurityDescriptor(jndiPath);
        return desc == null ? null : desc.getGridMap();
    }

    protected static ServiceAuthorizationChain retrieveAuthzChain(String jndiPath) throws ConfigException {
        SecurityDescriptor desc = SecurityConfig.retrieveSecurityDescriptor(jndiPath);
        return desc == null ? null : desc.getAuthzChain();
    }

    protected static SecurityDescriptor retrieveSecurityDescriptor(String jndiPath) throws ConfigException {
        return (SecurityDescriptor)SecurityConfig.getObject(SECURITY_DESCRIPTOR, jndiPath);
    }

    protected void initialize() throws ConfigException {
        this.loadSecurityDescriptor();
        this.initSecurityDescriptor();
        this.storeSecurityDescriptor();
        this.setInitialized(true);
    }

    protected static boolean isInitialized(String jndiPathName) throws ConfigException {
        Boolean value = (Boolean)SecurityConfig.getObject(SECURITY_INIT_NAME, jndiPathName);
        return value == null ? false : value;
    }

    protected void initSecurityDescriptor() throws ConfigException {
        if (this.desc == null) {
            return;
        }
        this.initCredentials();
        this.loadGridMap();
        this.loadAuthorization();
    }

    protected void setInitialized(boolean init) throws ConfigException {
        SecurityConfig.putObject(SECURITY_INIT_NAME, new Boolean(init), this.jndiPathName);
    }

    protected void loadSecurityDescriptor() throws ConfigException {
        Document doc = SecurityConfig.loadSecurityDescriptor(this.descriptorFile);
        this.initSecurityDescriptor(doc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document loadSecurityDescriptor(String file) throws ConfigException {
        Object loader;
        if (file == null) {
            return null;
        }
        logger.debug((Object)("Loading security descriptor: " + file));
        InputStream input = null;
        File f = new File(file);
        try {
            try {
                if (f.isAbsolute()) {
                    logger.debug((Object)"Loading security descriptor from file (absolute)");
                    input = new FileInputStream(file);
                } else {
                    logger.debug((Object)"Loading security descriptor from classpath");
                    loader = (class$org$globus$wsrf$impl$security$descriptor$SecurityConfig == null ? (class$org$globus$wsrf$impl$security$descriptor$SecurityConfig = SecurityConfig.class$("org.globus.wsrf.impl.security.descriptor.SecurityConfig")) : class$org$globus$wsrf$impl$security$descriptor$SecurityConfig).getClassLoader();
                    input = ((ClassLoader)loader).getResourceAsStream(file);
                    if (input == null) {
                        String cfgDir = SecurityConfig.getConfigDir();
                        f = new File(cfgDir, file);
                        logger.debug((Object)"Loading security descriptor from file (relative)");
                        input = new FileInputStream(f);
                    }
                }
                loader = XmlUtils.newDocument(input);
                Object var6_11 = null;
                if (input == null) return loader;
            }
            catch (FileNotFoundException e) {
                String msg = i18n.getMessage("noSecDescriptor", (Object)file);
                logger.error((Object)msg);
                throw new ConfigException(msg, e);
            }
            catch (ParserConfigurationException e) {
                String msg = i18n.getMessage("secDescParseFail", (Object)file);
                logger.error((Object)msg);
                throw new ConfigException(msg, e);
            }
            catch (Exception e) {
                String msg = i18n.getMessage("secDescLoadFail", (Object)file);
                logger.error((Object)msg);
                throw new ConfigException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return loader;
        }
        input.close();
        return loader;
    }

    protected boolean loadCredentials() throws GSSException, GlobusCredentialException, ConfigException {
        if (this.desc == null) {
            return false;
        }
        String certFile = this.desc.getCertFilename();
        GSSCredential cred = null;
        if (certFile == null) {
            String proxyFile = this.desc.getProxyFilename();
            if (proxyFile != null) {
                logger.debug((Object)i18n.getMessage("loadingProxy", (Object)proxyFile));
                File tempFile = SecurityConfig.resolvePath(proxyFile);
                GlobusCredential gCred = new GlobusCredential(tempFile.getPath());
                this.desc.setLastModified(new Long(tempFile.lastModified()));
                cred = SecurityConfig.toGSSCredential(gCred);
                this.desc.setProxyFilename(tempFile.getAbsolutePath());
            }
        } else {
            String keyFile = this.desc.getKeyFilename();
            if (keyFile == null) {
                throw new ConfigException(i18n.getMessage("serviceKeyMissing"));
            }
            logger.debug((Object)i18n.getMessage("loadingCertKey", new Object[]{certFile, keyFile}));
            File resolveKeyFile = SecurityConfig.resolvePath(keyFile);
            File resolveCertFile = SecurityConfig.resolvePath(certFile);
            GlobusCredential gCred = new GlobusCredential(resolveCertFile.getPath(), resolveKeyFile.getPath());
            this.desc.setLastModified(new Long(resolveCertFile.lastModified()));
            cred = SecurityConfig.toGSSCredential(gCred);
            this.desc.setCertificateFiles(resolveCertFile.getAbsolutePath(), resolveKeyFile.getAbsolutePath());
        }
        if (cred != null) {
            Subject subject = JaasGssUtil.createSubject(cred);
            this.desc.setSubject(subject);
            return true;
        }
        return false;
    }

    public static GSSCredential toGSSCredential(GlobusCredential cred) throws GSSException {
        return new GlobusGSSCredentialImpl(cred, 0);
    }

    protected void loadGridMap() throws ConfigException {
        if (this.desc == null) {
            return;
        }
        String gridMapFile = this.desc.getGridMapFile();
        if (gridMapFile != null) {
            logger.debug((Object)i18n.getMessage("loadingGridmap", (Object)gridMapFile));
            GridMap gridMap = new GridMap();
            File file = SecurityConfig.resolvePath(gridMapFile);
            try {
                gridMap.load(file);
            }
            catch (IOException e) {
                throw new ConfigException(i18n.getMessage("gridMapLoadFail", (Object)file.getName()), e);
            }
            this.desc.setGridMapFile(file.getAbsolutePath());
            this.desc.setGridMap(gridMap);
        } else {
            logger.debug((Object)"No gridmap file specified.");
        }
    }

    private static Object getObject(String objectName, String jndiPath) throws ConfigException {
        if (jndiPath == null) {
            return null;
        }
        Context ctx = SecurityConfig.getSecurityContext(jndiPath);
        if (ctx == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = ctx.lookup(objectName);
        }
        catch (NameNotFoundException exp) {
            logger.debug((Object)("Name not found " + exp.getMessage()));
            return null;
        }
        catch (NamingException exp) {
            throw new ConfigException(exp);
        }
        return obj;
    }

    protected static void putObject(String objectName, Object object, String jndiPath) throws ConfigException {
        try {
            Context serviceCtx = SecurityConfig.createContext(jndiPath);
            serviceCtx.rebind(objectName, object);
        }
        catch (NamingException exp) {
            throw new ConfigException(exp);
        }
    }

    protected void storeSecurityDescriptor() throws ConfigException {
        SecurityConfig.storeSecurityDescriptor(this.desc, this.jndiPathName);
    }

    private static String getContextPath(String jndiPathName) {
        return "java:comp/env//services/" + jndiPathName + "/" + SECURITY_PROP;
    }

    private static Context createContext(String jndi) throws ConfigException {
        try {
            InitialContext initContext = new InitialContext();
            return JNDIUtils.createSubcontexts(initContext, SecurityConfig.getContextPath(jndi) + "/foo");
        }
        catch (NamingException exp) {
            throw new ConfigException(exp);
        }
    }

    protected static boolean isRefreshRequired(String servicePath) throws ConfigException {
        Context ctx = SecurityConfig.getSecurityContext(servicePath);
        if (ctx == null) {
            return false;
        }
        SecurityDescriptor desc = null;
        try {
            desc = (SecurityDescriptor)ctx.lookup(SECURITY_DESCRIPTOR);
        }
        catch (NameNotFoundException exp) {
            return false;
        }
        catch (NamingException exp) {
            throw new ConfigException(exp);
        }
        return desc == null ? false : desc.isRefreshRequired();
    }

    private static Context getSecurityContext(String jndiPath) {
        try {
            InitialContext initContext = new InitialContext();
            Context ctx = (Context)initContext.lookup(SecurityConfig.getContextPath(jndiPath));
            return ctx;
        }
        catch (NamingException exp) {
            return null;
        }
    }

    private static String getConfigDir() {
        String cfgDir = null;
        MessageContext ctx = MessageContext.getCurrentContext();
        cfgDir = ctx == null ? ContainerConfig.getBaseDirectory() : (String)ctx.getProperty("configPath");
        return cfgDir == null ? "." : cfgDir;
    }

    private static File resolvePath(String pathName) {
        File file = new File(pathName);
        if (!file.isAbsolute() && !file.exists()) {
            logger.debug((Object)("File " + pathName + " does not exist wrt current" + "dir"));
            String cfg = SecurityConfig.getConfigDir();
            file = new File(cfg, pathName);
        }
        return file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

