/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.descriptor.ClientParamsParser;
import org.globus.wsrf.impl.security.descriptor.ClientParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParser;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.util.ElementParser;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.ietf.jgss.GSSCredential;

public class ClientSecurityDescriptor
extends ElementParser
implements CredentialParamsParserCallback,
ClientParamsParserCallback,
Serializable {
    public static final String RESOURCE = "org.globus.wsrf.impl.security.descriptor.errors";
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.descriptor.errors");
    public static final String NS = "http://www.globus.org";
    private static final QName QNAME = new QName("http://www.globus.org", "securityConfig");
    private Long lastModified = null;
    private String proxyFile = null;
    private String certFile = null;
    private String keyFile = null;
    private String peerCredFile = null;
    private Authorization authz = null;
    private Integer gsiSecConv = null;
    private Integer gsiTransport = null;
    private Integer gsiSecMsg = null;
    private Boolean anonymous = null;
    private String delegation = null;
    private GSSCredential gsiCred = null;
    private Subject peerSubject = null;

    public ClientSecurityDescriptor() {
        super(QNAME);
        this.register(CredentialParamsParser.PROXY_FILE_QNAME, new CredentialParamsParser(this));
        this.register(CredentialParamsParser.CREDENTIAL_QNAME, new CredentialParamsParser(this));
        this.register(ClientParamsParser.AUTHZ_QNAME, new ClientParamsParser(this));
        this.register(ClientParamsParser.SEC_CONV_QNAME, new ClientParamsParser(this));
        this.register(ClientParamsParser.SEC_MSG_QNAME, new ClientParamsParser(this));
    }

    public void setProxyFilename(String value) {
        this.proxyFile = value;
    }

    public void setCertificateFiles(String certName, String keyName) {
        this.certFile = certName;
        this.keyFile = keyName;
    }

    public String getProxyFilename() {
        return this.proxyFile;
    }

    public String getCertFilename() {
        return this.certFile;
    }

    public String getKeyFilename() {
        return this.keyFile;
    }

    public void setAuthz(Authorization value) {
        this.authz = value;
    }

    public Authorization getAuthz() {
        return this.authz;
    }

    public void setGSISecureConv(Integer val) {
        this.gsiSecConv = val;
    }

    public Integer getGSISecureConv() {
        return this.gsiSecConv;
    }

    public void setGSITransport(Integer val) {
        this.gsiTransport = val;
    }

    public Integer getGSITransport() {
        return this.gsiTransport;
    }

    public void setGSISecureMsg(Integer val) {
        this.gsiSecMsg = val;
    }

    public Integer getGSISecureMsg() {
        return this.gsiSecMsg;
    }

    public void setAnonymous() {
        this.anonymous = Boolean.TRUE;
    }

    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public void setDelegation(String deleg) {
        this.delegation = deleg;
    }

    public String getDelegation() {
        return this.delegation;
    }

    public void setPeerCredentials(String str) {
        this.peerCredFile = str;
    }

    public String getPeerCredentials() {
        return this.peerCredFile;
    }

    public void setLastModified(Long modified) {
        this.lastModified = modified;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setGSSCredential(GSSCredential cred) {
        this.gsiCred = cred;
    }

    public GSSCredential getGSSCredential() {
        return this.gsiCred;
    }

    public void setPeerSubject(Subject subject) {
        this.peerSubject = subject;
    }

    public Subject getPeerSubject() {
        return this.peerSubject;
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.lastModified);
        oos.writeObject(this.proxyFile);
        oos.writeObject(this.certFile);
        oos.writeObject(this.keyFile);
        oos.writeObject(this.peerCredFile);
        oos.writeObject(this.authz);
        oos.writeObject(this.gsiSecConv);
        oos.writeObject(this.gsiSecMsg);
        oos.writeObject(this.gsiTransport);
        oos.writeObject(this.anonymous);
        oos.writeObject(this.delegation);
        oos.writeObject(this.gsiCred);
        AuthUtil.writeSubject(this.peerSubject, oos);
    }

    protected void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.lastModified = (Long)ois.readObject();
        this.proxyFile = (String)ois.readObject();
        this.certFile = (String)ois.readObject();
        this.keyFile = (String)ois.readObject();
        this.peerCredFile = (String)ois.readObject();
        this.authz = (Authorization)ois.readObject();
        this.gsiSecConv = (Integer)ois.readObject();
        this.gsiSecMsg = (Integer)ois.readObject();
        this.gsiTransport = (Integer)ois.readObject();
        this.anonymous = (Boolean)ois.readObject();
        this.delegation = (String)ois.readObject();
        this.gsiCred = (GSSCredential)ois.readObject();
        this.peerSubject = AuthUtil.readSubject(ois);
    }
}

