/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.BasicSubjectAuthorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.w3c.dom.Node;

public class SelfAuthorization
extends BasicSubjectAuthorization
implements Authorization,
PDP {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$SelfAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$SelfAuthorization = SelfAuthorization.class$("org.globus.wsrf.impl.security.authorization.SelfAuthorization")) : class$org$globus$wsrf$impl$security$authorization$SelfAuthorization).getName());
    String servicePath = null;
    static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$authorization$SelfAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$SelfAuthorization = SelfAuthorization.class$("org.globus.wsrf.impl.security.authorization.SelfAuthorization")) : class$org$globus$wsrf$impl$security$authorization$SelfAuthorization).getClassLoader());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$SelfAuthorization;

    public static SelfAuthorization getInstance() {
        return new SelfAuthorization();
    }

    public void initialize(PDPConfig config, String name, String _servicePath) throws InitializeException {
        this.servicePath = _servicePath;
    }

    public String[] getPolicyNames() {
        return null;
    }

    public Node getPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public Node setPolicy(Node policy) throws InvalidPolicyException {
        return null;
    }

    public void close() throws CloseException {
        this.servicePath = null;
    }

    public boolean isPermitted(Subject peerSubject, MessageContext context, QName op) throws AuthorizationException {
        Subject serviceSubject = null;
        try {
            Resource resource = null;
            try {
                org.apache.axis.MessageContext msgCtx = (org.apache.axis.MessageContext)context;
                ResourceContext resContext = ResourceContext.getResourceContext((SOAPMessageContext)msgCtx);
                resource = resContext.getResource();
            }
            catch (ResourceContextException exp) {
                logger.debug((Object)"Error retrieving resource", (Throwable)exp);
            }
            catch (ResourceException exp) {
                logger.debug((Object)"Error retrieving resource", (Throwable)exp);
            }
            SecurityManager manager = SecurityManager.getManager((SOAPMessageContext)((org.apache.axis.MessageContext)context));
            serviceSubject = manager.getSubject(this.servicePath, resource);
        }
        catch (SecurityException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
        return this.authorize(serviceSubject, peerSubject, context);
    }

    public void authorize(Subject peerSubject, MessageContext context) throws AuthorizationException {
        Subject localSubject = null;
        try {
            localSubject = this.getLocalSubject(context);
        }
        catch (GSSException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
        if (!this.authorize(localSubject, peerSubject, context)) {
            throw new AuthorizationException(i18n.getMessage("authFail"));
        }
    }

    public Subject getLocalSubject() throws GSSException {
        return this.getLocalSubject(null);
    }

    public Subject getLocalSubject(MessageContext context) throws GSSException {
        GSSCredential cred = null;
        if (context != null && (cred = (GSSCredential)context.getProperty("org.globus.gsi.credentials")) != null) {
            logger.debug((Object)"Getting subject from context property");
            return JaasGssUtil.createSubject((GSSCredential)cred);
        }
        Subject subject = JaasSubject.getCurrentSubject();
        if (subject != null) {
            return subject;
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        cred = manager.createCredential(0);
        logger.debug((Object)"Getting subject from default credential");
        return JaasGssUtil.createSubject((GSSCredential)cred);
    }

    public GSSName getName(MessageContext ctx) throws AuthorizationException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

