/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;

public abstract class BasicSubjectAuthorization {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$BasicSubjectAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$BasicSubjectAuthorization = BasicSubjectAuthorization.class$("org.globus.wsrf.impl.security.authorization.BasicSubjectAuthorization")) : class$org$globus$wsrf$impl$security$authorization$BasicSubjectAuthorization).getName());
    static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors", (ClassLoader)(class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization = BasicSubjectAuthorization.class$("org.globus.wsrf.impl.security.authorization.IdentityAuthorization")) : class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization).getClassLoader());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$BasicSubjectAuthorization;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$IdentityAuthorization;

    protected boolean authorize(Subject localSubject, Subject peerSubject, MessageContext context) throws AuthorizationException {
        if (peerSubject == null) {
            throw new IllegalArgumentException(i18n.getMessage("noPeerSubject"));
        }
        if (localSubject == null) {
            throw new IllegalArgumentException(i18n.getMessage("noLocalSubject"));
        }
        Set<Principal> localPrincipals = localSubject.getPrincipals();
        if (localPrincipals == null || localPrincipals.isEmpty()) {
            logger.debug((Object)i18n.getMessage("noLocalPrincipals"));
            throw new AuthorizationException(i18n.getMessage("noLocalPrincipals"));
        }
        Set<Principal> peerPrincipals = peerSubject.getPrincipals();
        if (peerPrincipals == null || peerPrincipals.isEmpty()) {
            logger.debug((Object)i18n.getMessage("anonPeer"));
            throw new AuthorizationException(i18n.getMessage("anonPeer"));
        }
        Iterator<Principal> iter = localPrincipals.iterator();
        while (iter.hasNext()) {
            Principal principal = iter.next();
            if (!peerPrincipals.contains(principal)) continue;
            logger.debug((Object)i18n.getMessage("identityAuthSuccess", (Object)principal));
            return true;
        }
        logger.warn((Object)i18n.getMessage("identityAuthFail", new Object[]{localPrincipals, peerPrincipals}));
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

