/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.wssec;

import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityBasicHandler;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityResponseEngine;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.SecurityException;

public class WSSecurityClientHandler
extends WSSecurityBasicHandler {
    private static Log log = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$wssec$WSSecurityClientHandler == null ? (class$org$globus$wsrf$impl$security$authentication$wssec$WSSecurityClientHandler = WSSecurityClientHandler.class$("org.globus.wsrf.impl.security.authentication.wssec.WSSecurityClientHandler")) : class$org$globus$wsrf$impl$security$authentication$wssec$WSSecurityClientHandler).getName());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$wssec$WSSecurityClientHandler;

    public boolean handleRequest(MessageContext context) {
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        Object gssSec;
        Object xmlSig = context.getProperty("org.globus.security.secMsg.msg.type");
        if (xmlSig != null) {
            context.setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.NONE);
        }
        if ((gssSec = context.getProperty("org.globus.security.secConv.msg.type")) != null) {
            context.setProperty("org.globus.security.secConv.msg.type", (Object)GSIConstants.NONE);
        }
        SOAPMessageContext ctx = (SOAPMessageContext)context;
        boolean v = this.handleMessage(ctx, WSSecurityResponseEngine.getEngine());
        SOAPMessage msg = ctx.getMessage();
        SOAPBody body = null;
        try {
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            body = env.getBody();
        }
        catch (SOAPException e) {
            log.error((Object)"Failed to get envelope", (Throwable)e);
            return false;
        }
        if (!body.hasFault()) {
            try {
                Object gsiSecMsg = context.getProperty("org.globus.security.secMsg.msg.type");
                this.checkGSISecureMessage(xmlSig, gsiSecMsg, context);
                Object gsiSecConv = context.getProperty("org.globus.security.secConv.msg.type");
                this.checkGSISecConv(gssSec, gsiSecConv);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw WSSecurityFault.makeFault(e);
            }
        }
        return v;
    }

    private void checkGSISecureMessage(Object before, Object after, MessageContext context) throws WSSecurityException, AuthorizationException, SecurityException {
        if (before != null && (before.equals(GSIConstants.SIGNATURE) || before.equals(GSIConstants.ENCRYPTION))) {
            if (!before.equals(after)) {
                throw new WSSecurityException(0, "gsiXmlError");
            }
            Subject peer = (Subject)context.getProperty("callerSubject");
            Authorization author = AuthUtil.getClientAuthorization(context);
            if (author == null) {
                author = HostAuthorization.getInstance();
            }
            author.authorize(peer, context);
        }
    }

    private void checkGSISecConv(Object before, Object after) throws WSSecurityException {
        if (before != null && (before.equals(GSIConstants.SIGNATURE) || before.equals(GSIConstants.ENCRYPTION)) && !before.equals(after)) {
            throw new WSSecurityException(0, "gsiSecConvError");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

