/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.signature;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSAddTimestamp;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.util.WSSecurityUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.ContextCredential;
import org.globus.wsrf.impl.security.authentication.ContextCrypto;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.util.EnvelopeConverter;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509WSSignedSOAPEnvelopeBuilder
extends WSSignEnvelope {
    protected int defaultTTL = 300;
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.errors");
    private static ContextCrypto crypto = ContextCrypto.getInstance();
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$signature$X509WSSignedSOAPEnvelopeBuilder == null ? (class$org$globus$wsrf$impl$security$authentication$signature$X509WSSignedSOAPEnvelopeBuilder = X509WSSignedSOAPEnvelopeBuilder.class$("org.globus.wsrf.impl.security.authentication.signature.X509WSSignedSOAPEnvelopeBuilder")) : class$org$globus$wsrf$impl$security$authentication$signature$X509WSSignedSOAPEnvelopeBuilder).getName());
    protected GSSCredential credential;
    protected MessageContext msgContext;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$signature$X509WSSignedSOAPEnvelopeBuilder;

    public X509WSSignedSOAPEnvelopeBuilder(MessageContext msgContext, GSSCredential credential) {
        this.credential = credential;
        this.msgContext = msgContext;
        this.setUseSingleCertificate(false);
        this.setKeyIdentifierType(1);
        this.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    private GSSCredential getCredential() throws Exception {
        if (this.credential == null) {
            GlobusCredential defaultCredential = GlobusCredential.getDefaultCredential();
            if (defaultCredential != null) {
                return new GlobusGSSCredentialImpl(defaultCredential, 0);
            }
        } else if (this.credential instanceof GlobusGSSCredentialImpl) {
            return this.credential;
        }
        return null;
    }

    public SOAPEnvelope build(SOAPEnvelope envelope) throws Exception {
        return this.buildMessage(envelope).getSOAPPart().getEnvelope();
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        String time;
        GSSCredential contextCredential = this.getCredential();
        if (contextCredential == null) {
            throw new Exception(i18n.getMessage("noCreds"));
        }
        logger.debug((Object)"Beginning signing...");
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        WSAddTimestamp timeStampBuilder = new WSAddTimestamp(this.actor, true);
        int TTL = this.defaultTTL;
        if (this.msgContext != null && (time = (String)this.msgContext.getProperty("org.globus.security.timeToLive")) != null) {
            TTL = Integer.parseInt(time);
        }
        timeStampBuilder.build(doc, TTL);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)env);
        Vector<WSEncryptionPart> parts = new Vector<WSEncryptionPart>();
        parts.add(new WSEncryptionPart("Timestamp", WSConstants.WSU_NS, "Content"));
        parts.add(new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content"));
        HashMap nonWsaHeaders = (HashMap)this.msgContext.getProperty("org.globus.security.secure.headers");
        if (nonWsaHeaders != null) {
            Iterator iterator = nonWsaHeaders.keySet().iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                logger.debug((Object)("Header added " + qName));
                parts.add(new WSEncryptionPart(qName.getLocalPart(), qName.getNamespaceURI(), "Content"));
            }
        }
        this.setParts(parts);
        try {
            ContextCredential.begin(contextCredential);
            this.build(doc, crypto);
        }
        catch (WSSecurityException e) {
            throw new AxisFault(i18n.getMessage("signErr"), (Throwable)e);
        }
        finally {
            ContextCredential.release();
        }
        logger.debug((Object)"Signing complete.");
        return EnvelopeConverter.getInstance().toSOAPMessage(doc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GSSConfig.init();
    }
}

