/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.gsi.jaas.UserNamePrincipal;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.ContextUtils;

public class SecurityManagerImpl
extends SecurityManager {
    private MessageContext context = null;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$SecurityManagerImpl == null ? (class$org$globus$wsrf$impl$security$SecurityManagerImpl = SecurityManagerImpl.class$("org.globus.wsrf.impl.security.SecurityManagerImpl")) : class$org$globus$wsrf$impl$security$SecurityManagerImpl).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.error", (ClassLoader)(class$org$globus$wsrf$impl$security$SecurityManagerImpl == null ? (class$org$globus$wsrf$impl$security$SecurityManagerImpl = SecurityManagerImpl.class$("org.globus.wsrf.impl.security.SecurityManagerImpl")) : class$org$globus$wsrf$impl$security$SecurityManagerImpl).getClassLoader());
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$SecurityManagerImpl;
    static /* synthetic */ Class class$org$globus$gsi$jaas$GlobusPrincipal;

    public SecurityManagerImpl() {
        this(null);
    }

    public SecurityManagerImpl(SOAPMessageContext ctx) {
        this.context = (MessageContext)ctx;
        if (this.context == null) {
            this.context = MessageContext.getCurrentContext();
        }
    }

    public Subject getSystemSubject() throws SecurityException {
        try {
            logger.debug((Object)"Get system subject");
            ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
            config.refresh();
            return config.getSubject();
        }
        catch (Exception e) {
            logger.debug((Object)i18n.getMessage("failContainerCred"), (Throwable)e);
            throw new SecurityException(i18n.getMessage("failContainerCred"), e);
        }
    }

    public Subject getServiceSubject() throws SecurityException {
        if (this.context == null) {
            logger.debug((Object)i18n.getMessage("noContext"));
            throw new SecurityException(i18n.getMessage("noContext"));
        }
        String servicePath = ContextUtils.getTargetServicePath(this.context);
        return this.getServiceSubject(servicePath);
    }

    public Subject getServiceSubject(String servicePath) throws SecurityException {
        Subject subject = null;
        try {
            subject = ServiceSecurityConfig.getSubject(servicePath);
        }
        catch (Exception e) {
            logger.debug((Object)i18n.getMessage("failServiceCred"), (Throwable)e);
            throw new SecurityException(i18n.getMessage("failServiceCred"), e);
        }
        if (subject == null) {
            try {
                return this.getSystemSubject();
            }
            catch (Exception e) {
                logger.debug((Object)i18n.getMessage("failServiceContCred"), (Throwable)e);
                throw new SecurityException(i18n.getMessage("failServiceContCred"), e);
            }
        }
        return subject;
    }

    public Subject getSubject(Resource resource) throws SecurityException {
        Subject subject = this.getResourceSubject(resource);
        return subject == null ? this.getServiceSubject() : subject;
    }

    public Subject getSubject(String servicePath, Resource resource) throws SecurityException {
        try {
            Subject subject = SecureResourcePropertiesHelper.getResourceSubject(resource);
            return subject == null ? this.getServiceSubject(servicePath) : subject;
        }
        catch (Exception e) {
            logger.debug((Object)i18n.getMessage("failSystemCred"), (Throwable)e);
            throw new SecurityException(i18n.getMessage("failSystemCred"), e);
        }
    }

    private Subject getResourceSubject(Resource resource) throws SecurityException {
        try {
            return SecureResourcePropertiesHelper.getResourceSubject(resource);
        }
        catch (Exception e) {
            logger.debug((Object)i18n.getMessage("failSystemCred"), (Throwable)e);
            throw new SecurityException(i18n.getMessage("failSystemCred"), e);
        }
    }

    public String getCaller() {
        Principal p = this.getCallerPrincipal();
        return p == null ? null : p.getName();
    }

    public Principal getCallerPrincipal() {
        if (this.context == null) {
            return null;
        }
        Subject caller = (Subject)this.context.getProperty("callerSubject");
        return this.getCallerPrincipal(caller);
    }

    public Principal getCallerPrincipal(Subject caller) {
        if (caller == null) {
            return null;
        }
        Set<Principal> principals = caller.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        return principals.iterator().next();
    }

    public Subject setServiceOwnerFromContext() throws SecurityException {
        if (this.context == null) {
            logger.error((Object)i18n.getMessage("noContext"));
            throw new SecurityException(i18n.getMessage("noContext"));
        }
        String servicePath = ContextUtils.getTargetServicePath(this.context);
        return this.setServiceOwnerFromContext(servicePath);
    }

    public Subject setServiceOwnerFromContext(String servicePath) throws SecurityException {
        Subject subject = this.getSubject();
        try {
            ServiceSecurityConfig.setSubject(subject, servicePath);
        }
        catch (ConfigException exp) {
            throw new SecurityException((Throwable)((Object)exp));
        }
        GridMap gridMap = null;
        try {
            gridMap = ServiceSecurityConfig.getGridMap(servicePath);
            if (gridMap == null) {
                gridMap = new GridMap();
                ServiceSecurityConfig.setGridMap(gridMap, servicePath);
            }
        }
        catch (ConfigException exp) {
            throw new SecurityException((Throwable)((Object)exp));
        }
        this.addAuthorizedUser(subject, gridMap);
        return subject;
    }

    public void setResourceOwnerFromContext(ResourceSecurityDescriptor desc) throws SecurityException {
        if (desc == null) {
            return;
        }
        Subject subject = this.getSubject();
        desc.setSubject(subject);
        GridMap gridMap = desc.getGridMap();
        if (gridMap == null) {
            gridMap = new GridMap();
        }
        desc.setGridMap(gridMap);
        this.addAuthorizedUser(subject, gridMap);
    }

    private void addAuthorizedUser(Subject subject, GridMap gridMap) {
        Set principals = subject.getPrincipals(class$org$globus$gsi$jaas$GlobusPrincipal == null ? (class$org$globus$gsi$jaas$GlobusPrincipal = SecurityManagerImpl.class$("org.globus.gsi.jaas.GlobusPrincipal")) : class$org$globus$gsi$jaas$GlobusPrincipal);
        if (principals != null && !principals.isEmpty()) {
            Iterator iter = principals.iterator();
            while (iter.hasNext()) {
                Principal principal = (Principal)iter.next();
                gridMap.map(principal.getName(), System.getProperty("user.name"));
            }
        }
    }

    private Subject getSubject() throws SecurityException {
        Subject subject = JaasSubject.getCurrentSubject();
        if (subject == null) {
            throw new SecurityException(i18n.getMessage("noSubject"));
        }
        Set<Object> creds = subject.getPrivateCredentials();
        if (creds == null || creds.isEmpty()) {
            throw new SecurityException(i18n.getMessage("noPrivateCred"));
        }
        subject.setReadOnly();
        return subject;
    }

    public String[] getLocalUsernames() throws SecurityException {
        if (this.context == null) {
            logger.debug((Object)i18n.getMessage("noContext"));
            throw new SecurityException(i18n.getMessage("noContext"));
        }
        Subject subject = (Subject)this.context.getProperty("callerSubject");
        if (subject == null) {
            logger.debug((Object)i18n.getMessage("noPeerSubject"));
            throw new SecurityException(i18n.getMessage("noPeerSubject"));
        }
        Set<Principal> principalSet = subject.getPrincipals();
        Vector<String> userNames = new Vector<String>();
        if (principalSet != null) {
            Iterator<Principal> it = principalSet.iterator();
            while (it.hasNext()) {
                Principal principal = it.next();
                if (!(principal instanceof UserNamePrincipal)) continue;
                userNames.add(((UserNamePrincipal)principal).getName());
            }
        }
        String[] userNameArray = null;
        if (userNames.size() > 0) {
            userNameArray = new String[userNames.size()];
            userNames.toArray(userNameArray);
        }
        return userNameArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

