/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.io.Serializable;
import java.util.List;
import javax.naming.InitialContext;
import javax.xml.rpc.Stub;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.LocalInvocationEnabledSubscription;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.Subscription;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicListener;
import org.globus.wsrf.impl.TopicExpressionEngineImpl;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.topicexpression.TopicExpressionEngine;
import org.globus.wsrf.topicexpression.TopicExpressionEvaluator;
import org.oasis.wsn.NotificationConsumer;
import org.oasis.wsn.NotificationMessageHolderType;
import org.oasis.wsn.Notify;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;

public class SimpleSubscriptionTopicListener
implements TopicListener,
Serializable {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$SimpleSubscriptionTopicListener == null ? (class$org$globus$wsrf$impl$SimpleSubscriptionTopicListener = SimpleSubscriptionTopicListener.class$("org.globus.wsrf.impl.SimpleSubscriptionTopicListener")) : class$org$globus$wsrf$impl$SimpleSubscriptionTopicListener).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = SimpleSubscriptionTopicListener.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private ResourceKey key;
    private String homeLocation;
    private transient NotificationConsumer consumerPort = null;
    private transient WSBaseNotificationServiceAddressingLocator locator = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$SimpleSubscriptionTopicListener;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    public SimpleSubscriptionTopicListener(ResourceKey key, String homeLocation) {
        this.key = key;
        this.homeLocation = homeLocation;
    }

    public void topicChanged(Topic topic) {
        Subscription subscription = null;
        try {
            subscription = this.getSubscription();
        }
        catch (ResourceException e) {
            logger.warn((Object)i18n.getMessage("subscriptionFindFailed", this.key.getValue()));
            logger.debug((Object)"", (Throwable)e);
        }
        if (subscription != null) {
            try {
                this.notify(subscription, topic.getTopicPath(), topic.getCurrentMessage());
            }
            catch (Exception e) {
                logger.warn((Object)i18n.getMessage("notificationFailed", this.key.getValue()));
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    public void topicAdded(Topic topic) {
    }

    public void topicRemoved(Topic topic) {
    }

    public Subscription getSubscription() throws ResourceException {
        ResourceHome home = null;
        try {
            InitialContext initialContext = new InitialContext();
            home = (ResourceHome)initialContext.lookup(this.homeLocation);
        }
        catch (Exception e) {
            throw new ResourceException(i18n.getMessage("subscriptionFindFailed", this.key.getValue()), e);
        }
        return (Subscription)home.find(this.key);
    }

    public String getSubscriptionHomeLocation() {
        return this.homeLocation;
    }

    public ResourceKey getSubscriptionResourceKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(Subscription subscription, List topicPath, Object newValue) throws Exception {
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            if (!subscription.isPaused() && subscription.getUseNotify()) {
                EndpointReferenceType producerEndpoint = subscription.getProducerReference();
                TopicExpressionEngine engine = TopicExpressionEngineImpl.getInstance();
                TopicExpressionType tp = subscription.getTopicExpression();
                String dialect = tp.getDialect().toString();
                TopicExpressionEvaluator evaluator = engine.getEvaluator(dialect);
                TopicExpressionType topicExpression = evaluator.toTopicExpression(topicPath);
                NotificationMessageHolderType[] message = new NotificationMessageHolderType[]{new NotificationMessageHolderType()};
                message[0].setProducerReference(producerEndpoint);
                message[0].setMessage(newValue);
                message[0].setTopic(topicExpression);
                NotifyCallback callback = null;
                if (subscription instanceof LocalInvocationEnabledSubscription && (callback = ((LocalInvocationEnabledSubscription)subscription).getCallback()) != null) {
                    callback.deliver(topicPath, producerEndpoint, message[0].getMessage());
                } else {
                    EndpointReferenceType consumerEPR = subscription.getConsumerReference();
                    ClientSecurityDescriptor descriptor = subscription.getSecurityProperties();
                    this.setPort(descriptor, consumerEPR);
                    Notify notification = new Notify();
                    notification.setNotificationMessage(message);
                    this.consumerPort.notify(notification);
                }
            }
        }
    }

    private void setPort(ClientSecurityDescriptor descriptor, EndpointReferenceType consumerEPR) throws Exception {
        if (descriptor != null) {
            if (descriptor.getGSISecureConv() != null) {
                logger.debug((Object)"Security properties not null: secure conv");
                WSBaseNotificationServiceAddressingLocator loc = new WSBaseNotificationServiceAddressingLocator();
                this.consumerPort = loc.getNotificationConsumerPort(consumerEPR);
            } else {
                logger.debug((Object)"Security properties not null: not secure conv");
                this.setPort(false, consumerEPR);
            }
            logger.debug((Object)"Setting security properties");
            Stub portStub = (Stub)this.consumerPort;
            if (descriptor.getAuthz() == null) {
                descriptor.setAuthz(NoAuthorization.getInstance());
            }
            portStub._setProperty("clientDescriptor", (Object)descriptor);
        } else {
            logger.debug((Object)"Security properties null");
            this.setPort(true, consumerEPR);
        }
    }

    private synchronized void setPort(boolean reuse, EndpointReferenceType consumerEPR) throws Exception {
        logger.debug((Object)("set port with " + reuse));
        if (reuse && this.consumerPort != null) {
            return;
        }
        if (this.locator == null) {
            this.locator = new SharedWSBaseNotificationServiceAddressingLocator();
        }
        if (this.consumerPort == null || !reuse) {
            this.consumerPort = this.locator.getNotificationConsumerPort(consumerEPR);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SharedWSBaseNotificationServiceAddressingLocator
    extends WSBaseNotificationServiceAddressingLocator {
        private static EngineConfiguration defaultConfig = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        private static AxisClient defaultEngine = new AxisClient(defaultConfig);

        private SharedWSBaseNotificationServiceAddressingLocator() {
        }

        protected AxisClient getAxisClient() {
            return defaultEngine;
        }
    }
}

