/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.query.ExpressionEvaluator;
import org.globus.wsrf.query.InvalidQueryExpressionException;
import org.globus.wsrf.query.QueryEngine;
import org.globus.wsrf.query.QueryEvaluationException;
import org.globus.wsrf.query.QueryException;
import org.globus.wsrf.query.UnsupportedQueryDialectException;
import org.oasis.wsrf.properties.QueryExpressionType;

public class QueryEngineImpl
implements QueryEngine {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$QueryEngineImpl == null ? (class$org$globus$wsrf$impl$QueryEngineImpl = QueryEngineImpl.class$("org.globus.wsrf.impl.QueryEngineImpl")) : class$org$globus$wsrf$impl$QueryEngineImpl).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = QueryEngineImpl.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private static String QUERY_EVALUATOR_CONTEXT = "java:comp/env//query/eval";
    private Hashtable evaluators = new Hashtable();
    static /* synthetic */ Class class$org$globus$wsrf$impl$QueryEngineImpl;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$globus$wsrf$query$ExpressionEvaluator;

    public QueryEngineImpl() {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void refresh() {
        this.evaluators.clear();
        NamingEnumeration<NameClassPair> list = null;
        InitialContext initialContext = new InitialContext();
        list = initialContext.list(QUERY_EVALUATOR_CONTEXT);
        NameClassPair pair = null;
        ExpressionEvaluator evaluator = null;
        while (list.hasMore()) {
            pair = list.next();
            evaluator = (ExpressionEvaluator)JNDIUtils.lookup(initialContext, QUERY_EVALUATOR_CONTEXT + "/" + pair.getName(), class$org$globus$wsrf$query$ExpressionEvaluator == null ? QueryEngineImpl.class$("org.globus.wsrf.query.ExpressionEvaluator") : class$org$globus$wsrf$query$ExpressionEvaluator);
            this.registerEvaluator(evaluator);
        }
        Object var6_6 = null;
        if (list == null) return;
        try {
            list.close();
            return;
        }
        catch (NamingException ee) {}
        return;
        {
            catch (NamingException e) {
                logger.error((Object)i18n.getMessage("queryEngineInitError"), (Throwable)e);
                Object var6_7 = null;
                if (list == null) return;
                try {
                    list.close();
                    return;
                }
                catch (NamingException ee) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (list == null) throw throwable;
            try {
                list.close();
                throw throwable;
            }
            catch (NamingException ee) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void registerEvaluator(ExpressionEvaluator evaluator) {
        String[] names = evaluator.getDialects();
        for (int i = 0; i < names.length; ++i) {
            this.evaluators.put(names[i], evaluator);
        }
    }

    public ExpressionEvaluator getEvaluator(String dialect) {
        ExpressionEvaluator evaluator = (ExpressionEvaluator)this.evaluators.get(dialect);
        return evaluator;
    }

    public Object executeQuery(QueryExpressionType expression, ResourcePropertySet resourcePropertySet) throws UnsupportedQueryDialectException, QueryEvaluationException, InvalidQueryExpressionException, QueryException {
        if (expression == null) {
            throw new QueryException(i18n.getMessage("noQuery"));
        }
        if (expression.getDialect() == null) {
            throw new QueryException(i18n.getMessage("nullArgument", (Object)"expression.dialect"));
        }
        String dialect = expression.getDialect().toString();
        ExpressionEvaluator evaluator = this.getEvaluator(dialect);
        if (evaluator == null) {
            throw new UnsupportedQueryDialectException(i18n.getMessage("unsupportedQueryDialect", (Object)dialect));
        }
        return evaluator.evaluate(expression, resourcePropertySet);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

