/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.encoding;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.globus.util.I18n;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.StringBufferReader;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ObjectSerializer {
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = ObjectSerializer.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    private static final QName CLONE_QNAME = new QName("http://globus.org", "cloneElement");
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    public static SOAPElement toSOAPElement(Object obj) throws SerializationException {
        return ObjectSerializer.toSOAPElement(obj, null, false);
    }

    public static SOAPElement toSOAPElement(Object obj, QName name) throws SerializationException {
        return ObjectSerializer.toSOAPElement(obj, name, false);
    }

    public static SOAPElement toSOAPElement(Object obj, QName name, boolean nillable) throws SerializationException {
        if (obj instanceof MessageElement) {
            MessageElement element = (MessageElement)obj;
            if (name == null || name.equals(element.getQName())) {
                return element;
            }
            throw new SerializationException(i18n.getMessage("notImplemented"));
        }
        if (obj instanceof Element) {
            Element element = (Element)obj;
            if (name == null || name.getLocalPart().equals(element.getLocalName()) && name.getNamespaceURI().equals(element.getNamespaceURI())) {
                return new MessageElement((Element)obj);
            }
            throw new SerializationException(i18n.getMessage("notImplemented"));
        }
        if (name == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"name"));
        }
        MessageElement messageElement = new MessageElement();
        messageElement.setQName(name);
        try {
            messageElement.setObjectValue(obj);
        }
        catch (Exception e) {
            throw new SerializationException(i18n.getMessage("genericSerializationError"), e);
        }
        if (obj == null && nillable) {
            try {
                messageElement.addAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
            }
            catch (Exception e) {
                throw new SerializationException(i18n.getMessage("genericSerializationError"), e);
            }
        }
        return messageElement;
    }

    public static Element toElement(Object obj) throws SerializationException {
        return ObjectSerializer.toElement(obj, null, false);
    }

    public static Element toElement(Object obj, QName name) throws SerializationException {
        return ObjectSerializer.toElement(obj, name, false);
    }

    public static Element toElement(Object obj, QName name, boolean nillable) throws SerializationException {
        if (obj instanceof MessageElement) {
            MessageElement messageElement = (MessageElement)obj;
            if (name == null || name.equals(messageElement.getQName())) {
                Element element = null;
                try {
                    element = AnyHelper.toElement(messageElement);
                }
                catch (Exception e) {
                    throw new SerializationException(i18n.getMessage("genericSerializationError"), e);
                }
                return element;
            }
            throw new SerializationException(i18n.getMessage("notImplemented"));
        }
        if (obj instanceof Element) {
            Element element = (Element)obj;
            if (name == null || name.getLocalPart().equals(element.getLocalName()) && name.getNamespaceURI().equals(element.getNamespaceURI())) {
                return element;
            }
            throw new SerializationException(i18n.getMessage("notImplemented"));
        }
        MessageElement messageElement = (MessageElement)ObjectSerializer.toSOAPElement(obj, name, nillable);
        try {
            return AnyHelper.toElement(messageElement);
        }
        catch (Exception e) {
            throw new SerializationException(i18n.getMessage("genericSerializationError"), e);
        }
    }

    public static String toString(Object obj) throws SerializationException {
        return ObjectSerializer.toString(obj, null, false);
    }

    public static String toString(Object obj, QName name) throws SerializationException {
        return ObjectSerializer.toString(obj, name, false);
    }

    public static String toString(Object obj, QName name, boolean nillable) throws SerializationException {
        MessageElement messageElement = (MessageElement)ObjectSerializer.toSOAPElement(obj, name, nillable);
        try {
            return AnyHelper.toString(messageElement);
        }
        catch (Exception e) {
            throw new SerializationException(i18n.getMessage("genericSerializationError"), e);
        }
    }

    public static void serialize(Writer writer, Object obj, QName name) throws SerializationException {
        ObjectSerializer.serialize(writer, obj, name, false);
    }

    public static void serialize(Writer writer, Object obj, QName name, boolean nillable) throws SerializationException {
        SOAPElement soapElement = ObjectSerializer.toSOAPElement(obj, name, nillable);
        try {
            AnyHelper.write(writer, (MessageElement)soapElement);
        }
        catch (Exception e) {
            throw new SerializationException(i18n.getMessage("genericSerializationError"), e);
        }
    }

    public static Object clone(Object obj) throws SerializationException, DeserializationException {
        StringWriter writer = new StringWriter();
        ObjectSerializer.serialize(writer, obj, CLONE_QNAME);
        writer.flush();
        StringBufferReader reader = new StringBufferReader(writer.getBuffer());
        InputSource input = new InputSource(reader);
        return ObjectDeserializer.deserialize(input, obj.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

