/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.token;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.commons.logging.Log;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.RequestedSecurityToken;
import org.apache.ws.security.trust.message.token.TokenType;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestSecurityTokenResponse {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$conversation$message$token$RequestSecurityTokenResponse == null ? (class$org$apache$ws$security$conversation$message$token$RequestSecurityTokenResponse = RequestSecurityTokenResponse.class$("org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse")) : class$org$apache$ws$security$conversation$message$token$RequestSecurityTokenResponse).getName());
    private Element element = null;
    private RequestedSecurityToken requestedSecurityToken = null;
    private RequestedProofToken requestedProofToken = null;
    private Element tokenType = null;
    private Element lifeTime = null;
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2004/04/trust", "RequestSecurityTokenResponse", "wst");
    static /* synthetic */ Class class$org$apache$ws$security$conversation$message$token$RequestSecurityTokenResponse;

    public RequestSecurityTokenResponse(Document doc) throws Exception {
        this.element = doc.createElementNS(TOKEN.getNamespaceURI(), TOKEN.getPrefix() + ":" + TOKEN.getLocalPart());
        WSSecurityUtil.setNamespace(this.element, TOKEN.getNamespaceURI(), "wst");
        this.element.appendChild(doc.createTextNode(""));
    }

    public RequestSecurityTokenResponse(Document doc, boolean generateChildren) throws Exception {
        this(doc);
        if (generateChildren) {
            this.requestedSecurityToken = new RequestedSecurityToken(doc, true);
            this.requestedProofToken = new RequestedProofToken(doc);
            this.element.appendChild(this.requestedSecurityToken.getElement());
            this.element.appendChild(this.requestedProofToken.getElement());
        }
    }

    public RequestSecurityTokenResponse(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
    }

    public RequestSecurityTokenResponse(Element elem, boolean parseChildElements) throws WSSecurityException {
        this(elem);
        if (!parseChildElements) {
            return;
        }
        this.tokenType = (Element)WSSecurityUtil.getDirectChild(elem.getOwnerDocument(), TokenType.TOKEN.getLocalPart(), TokenType.TOKEN.getNamespaceURI());
        Element elemTemp = (Element)WSSecurityUtil.getDirectChild(elem, RequestedSecurityToken.TOKEN.getLocalPart(), RequestedSecurityToken.TOKEN.getNamespaceURI());
        if (elemTemp != null) {
            this.requestedSecurityToken = new RequestedSecurityToken(elemTemp, true);
        }
        if ((elemTemp = (Element)WSSecurityUtil.getDirectChild(elem, RequestedProofToken.TOKEN.getLocalPart(), RequestedProofToken.TOKEN.getNamespaceURI())) != null) {
            this.requestedProofToken = new RequestedProofToken(elemTemp);
        }
    }

    public void setContext(String context) {
        this.element.setAttribute("Context", context);
    }

    public String getContext() {
        return this.element.getAttribute("Context");
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public void addToken(Element childToken) {
        this.element.appendChild(childToken);
    }

    public void removeToken(Element childToken) {
        this.element.removeChild(childToken);
    }

    public RequestedProofToken getRequestedProofToken() {
        return this.requestedProofToken;
    }

    public RequestedSecurityToken getRequestedSecurityToken() {
        return this.requestedSecurityToken;
    }

    public void build(Document doc) {
        Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), true);
        WSSecurityUtil.appendChildElement(doc, securityHeader, this.element);
        if (log.isInfoEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            String osStr = os.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

