/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.ear.AbstractXmlWriter;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.JbossConfiguration;
import org.apache.maven.plugin.ear.JbossEarModule;
import org.codehaus.plexus.util.xml.XMLWriter;

final class JbossAppXmlWriter
extends AbstractXmlWriter {
    public static final String DOCTYPE_3_2 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD J2EE Application 1.3//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_3_2.dtd\"";
    public static final String DOCTYPE_4 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD J2EE Application 1.4//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_4_0.dtd\"";
    public static final String DOCTYPE_4_2 = "jboss-app PUBLIC\n\t\"-//JBoss//DTD J2EE Application 1.4//EN\"\n\t\"http://www.jboss.org/j2ee/dtd/jboss-app_4_2.dtd\"";
    private static final String JBOSS_APP_ELEMENT = "jboss-app";
    static /* synthetic */ Class class$org$apache$maven$plugin$ear$JbossEarModule;

    JbossAppXmlWriter(String encoding) {
        super(encoding);
    }

    public void write(File destinationFile, JbossConfiguration jbossConfiguration, List earModules) throws EarPluginException {
        Writer w = this.initializeWriter(destinationFile);
        XMLWriter writer = jbossConfiguration.isJbossThreeDotTwo() ? this.initializeXmlWriter(w, DOCTYPE_3_2) : (jbossConfiguration.isJbossFour() ? this.initializeXmlWriter(w, DOCTYPE_4) : this.initializeXmlWriter(w, DOCTYPE_4_2));
        writer.startElement(JBOSS_APP_ELEMENT);
        if (jbossConfiguration.isJbossFourDotTwo() && jbossConfiguration.getModuleOrder() != null) {
            writer.startElement("module-order");
            writer.writeText(jbossConfiguration.getModuleOrder());
            writer.endElement();
        }
        if (jbossConfiguration.isJbossFour() || jbossConfiguration.isJbossFourDotTwo()) {
            if (jbossConfiguration.getSecurityDomain() != null) {
                writer.startElement("security-domain");
                writer.writeText(jbossConfiguration.getSecurityDomain());
                writer.endElement();
            }
            if (jbossConfiguration.getUnauthenticatedPrincipal() != null) {
                writer.startElement("unauthenticated-principal");
                writer.writeText(jbossConfiguration.getUnauthenticatedPrincipal());
                writer.endElement();
            }
        }
        if (jbossConfiguration.getLoaderRepository() != null) {
            writer.startElement("loader-repository");
            writer.writeText(jbossConfiguration.getLoaderRepository());
            writer.endElement();
        }
        if (jbossConfiguration.getJmxName() != null) {
            writer.startElement("jmx-name");
            writer.writeText(jbossConfiguration.getJmxName());
            writer.endElement();
        }
        Iterator it = earModules.iterator();
        while (it.hasNext()) {
            EarModule earModule;
            if (!(class$org$apache$maven$plugin$ear$JbossEarModule == null ? JbossAppXmlWriter.class$("org.apache.maven.plugin.ear.JbossEarModule") : class$org$apache$maven$plugin$ear$JbossEarModule).isInstance(earModule = (EarModule)it.next())) continue;
            JbossEarModule jbossEarModule = (JbossEarModule)((Object)earModule);
            jbossEarModule.appendJbossModule(writer, jbossConfiguration.getVersion());
        }
        writer.endElement();
        this.close(w);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

