package gov.cdc.ncphi.phgrid.services.amds.client;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;

import javax.xml.namespace.QName;

import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.apache.commons.io.FileUtils;

import org.oasis.wsrf.properties.GetResourcePropertyResponse;

import org.globus.gsi.GlobusCredential;

import gov.cdc.ncphi.phgrid.amds.message.AMDSQueryRequest;
import gov.cdc.ncphi.phgrid.amds.message.AMDSQueryResponse;
import gov.cdc.ncphi.phgrid.amds.message.MetadataQuery;
import gov.cdc.ncphi.phgrid.amds.message.MetadataQueryResponse;
import gov.cdc.ncphi.phgrid.services.amds.stubs.AMDSServicePortType;
import gov.cdc.ncphi.phgrid.services.amds.stubs.service.AMDSServiceAddressingLocator;
import gov.cdc.ncphi.phgrid.services.amds.common.AMDSServiceI;
import gov.cdc.ncphi.phgrid.services.amds.common.AxisUtils;
import gov.nih.nci.cagrid.introduce.security.client.ServiceSecurityClient;

/**
 * This class is autogenerated, DO NOT EDIT GENERATED GRID SERVICE ACCESS METHODS.
 *
 * This client is generated automatically by Introduce to provide a clean unwrapped API to the
 * service.
 *
 * On construction the class instance will contact the remote service and retrieve it's security
 * metadata description which it will use to configure the Stub specifically for each method call.
 * 
 * @created by Introduce Toolkit version 1.3
 */
public class AMDSServiceClient extends AMDSServiceClientBase implements AMDSServiceI {	

	public AMDSServiceClient(String url) throws MalformedURIException, RemoteException {
		this(url,null);	
	}

	public AMDSServiceClient(String url, GlobusCredential proxy) throws MalformedURIException, RemoteException {
	   	super(url,proxy);
	}
	
	public AMDSServiceClient(EndpointReferenceType epr) throws MalformedURIException, RemoteException {
	   	this(epr,null);
	}
	
	public AMDSServiceClient(EndpointReferenceType epr, GlobusCredential proxy) throws MalformedURIException, RemoteException {
	   	super(epr,proxy);
	}

	public static void usage(){
		System.out.println(AMDSServiceClient.class.getName() + " -url <service url> [");
	}
	
	public static void main(String [] args){
	    System.out.println("Running the Grid Service Client");
		try{
			if(!(args.length < 2)){
				if(args[0].equals("-url")){
					testMetadata(args);
					testQuery(args);
				} else {
					usage();
					System.exit(1);
				}
			} else {
				usage();
				System.exit(1);
			}
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}
	
	private static void testMetadata(String [] args) throws Exception{
		  System.out.println("In client...EEEEEEEE");
		  AMDSServiceClient client = new AMDSServiceClient(args[1]);
		  client.setAnonymousPrefered(false);
		  MetadataQuery query = new MetadataQuery();
		  MetadataQueryResponse response = client.queryMetadata(query);
		  System.out.println(AxisUtils.serializeAxisObject(response, false, true));
		
	}
	
	private static void testQuery(String [] args) throws Exception{
		  AMDSServiceClient client = new AMDSServiceClient(args[1]);
		  String queryRequestFileName = "AMDSQueryRequest-ForClient.xml";
		  File queryRequestFile = new File(queryRequestFileName);
		  if (queryRequestFile.exists()){
			  AMDSQueryRequest query = (AMDSQueryRequest) AxisUtils.deserializeAxisObject(FileUtils.readFileToString(queryRequestFile), AMDSQueryRequest.class);
			  AMDSQueryResponse response = client.queryAMDS(query);
			  System.out.println(AxisUtils.serializeAxisObject(response, false, true));
			  
		  }else{
			  System.out.println("No " + queryRequestFileName + "in current dir. Exiting. Copy file to current dir and try again.");
		  }
		  
		
	}

  public org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse getMultipleResourceProperties(org.oasis.wsrf.properties.GetMultipleResourceProperties_Element params) throws RemoteException {
    synchronized(portTypeMutex){
      configureStubSecurity((Stub)portType,"getMultipleResourceProperties");
    return portType.getMultipleResourceProperties(params);
    }
  }

  public org.oasis.wsrf.properties.GetResourcePropertyResponse getResourceProperty(javax.xml.namespace.QName params) throws RemoteException {
    synchronized(portTypeMutex){
      configureStubSecurity((Stub)portType,"getResourceProperty");
    return portType.getResourceProperty(params);
    }
  }

  public org.oasis.wsrf.properties.QueryResourcePropertiesResponse queryResourceProperties(org.oasis.wsrf.properties.QueryResourceProperties_Element params) throws RemoteException {
    synchronized(portTypeMutex){
      configureStubSecurity((Stub)portType,"queryResourceProperties");
    return portType.queryResourceProperties(params);
    }
  }

  public gov.cdc.ncphi.phgrid.amds.message.MetadataQueryResponse queryMetadata(gov.cdc.ncphi.phgrid.amds.message.MetadataQuery query) throws RemoteException {
    synchronized(portTypeMutex){
      configureStubSecurity((Stub)portType,"queryMetadata");
    gov.cdc.ncphi.phgrid.services.amds.stubs.QueryMetadataRequest params = new gov.cdc.ncphi.phgrid.services.amds.stubs.QueryMetadataRequest();
    gov.cdc.ncphi.phgrid.services.amds.stubs.QueryMetadataRequestQuery queryContainer = new gov.cdc.ncphi.phgrid.services.amds.stubs.QueryMetadataRequestQuery();
    queryContainer.setMetadataQuery(query);
    params.setQuery(queryContainer);
    gov.cdc.ncphi.phgrid.services.amds.stubs.QueryMetadataResponse boxedResult = portType.queryMetadata(params);
    return boxedResult.getMetadataQueryResponse();
    }
  }

  public gov.cdc.ncphi.phgrid.amds.message.AMDSQueryResponse queryAMDS(gov.cdc.ncphi.phgrid.amds.message.AMDSQueryRequest query) throws RemoteException {
    synchronized(portTypeMutex){
      configureStubSecurity((Stub)portType,"queryAMDS");
    gov.cdc.ncphi.phgrid.services.amds.stubs.QueryAMDSRequest params = new gov.cdc.ncphi.phgrid.services.amds.stubs.QueryAMDSRequest();
    gov.cdc.ncphi.phgrid.services.amds.stubs.QueryAMDSRequestQuery queryContainer = new gov.cdc.ncphi.phgrid.services.amds.stubs.QueryAMDSRequestQuery();
    queryContainer.setAMDSQueryRequest(query);
    params.setQuery(queryContainer);
    gov.cdc.ncphi.phgrid.services.amds.stubs.QueryAMDSResponse boxedResult = portType.queryAMDS(params);
    return boxedResult.getAMDSQueryResponse();
    }
  }

}
