/*
 * Decompiled with CFR 0.152.
 */
package secconv.components;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.conversation.ConversationEngine;
import org.apache.ws.security.conversation.ConversationManager;
import org.apache.ws.security.conversation.ConversationUtil;
import org.apache.ws.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestDkEncrypt
extends TestCase {
    private static Log log = LogFactory.getLog((Class)(class$secconv$components$TestDkEncrypt == null ? (class$secconv$components$TestDkEncrypt = TestDkEncrypt.class$("secconv.components.TestDkEncrypt")) : class$secconv$components$TestDkEncrypt));
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test10/LogTestService10\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    MessageContext msgContext;
    Message message;
    String uuid;
    DerivedKeyCallbackHandler dkcbHandler;
    HashMap config;
    static /* synthetic */ Class class$secconv$components$TestDkEncrypt;

    public TestDkEncrypt(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$secconv$components$TestDkEncrypt == null ? (class$secconv$components$TestDkEncrypt = TestDkEncrypt.class$("secconv.components.TestDkEncrypt")) : class$secconv$components$TestDkEncrypt);
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new MessageContext((AxisEngine)tmpEngine);
        this.message = this.getSOAPMessage();
        this.dkcbHandler = new DerivedKeyCallbackHandler();
        SecurityContextToken secConTok = this.getSCT();
        this.uuid = secConTok.getIdentifier();
        SecurityContextInfo info = new SecurityContextInfo(secConTok, "DumbShredSecret".getBytes(), 1);
        DerivedKeyCallbackHandler.addSecurtiyContext(this.uuid, info);
        DerivedKeyCallbackHandler.setDerivedKeyLength(this.uuid, 24L);
        DerivedKeyCallbackHandler.setLabelForSession(this.uuid, "WSSecureConversationWSSecureConversation");
        this.config = new HashMap();
        this.config.put("keyFrequency", new Integer(1));
        this.config.put("useFixedKeyLegnth", new Boolean(true));
        this.config.put("keyLegnth", new Long(24L));
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    protected SecurityContextToken getSCT() throws Exception {
        DocumentBuilderFactory buidler = DocumentBuilderFactory.newInstance();
        Document nulldoc = buidler.newDocumentBuilder().newDocument();
        SecurityContextToken sctTok = new SecurityContextToken(nulldoc);
        return sctTok;
    }

    public void testPerformDkEncrypt() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        log.info((Object)"Before Derived Key Encryption");
        Document doc = unsignedEnvelope.getAsDocument();
        Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), true);
        WSSecurityUtil.appendChildElement(doc, securityHeader, new SecurityContextToken(doc, this.uuid).getElement());
        ConversationManager manager = new ConversationManager();
        DerivedKeyInfo dkInfo = manager.createDerivedKeyToken(doc, this.uuid, this.dkcbHandler, null, 24);
        SecurityTokenReference secTokRef = dkInfo.getSecTokRef2DkToken();
        manager.performDK_ENCR(ConversationUtil.generateIdentifier(this.uuid, dkInfo.getId()), "", true, doc, secTokRef, this.dkcbHandler, null, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        manager.addDkToken(doc, dkInfo);
        Message signedMsg = (Message)AxisUtil.toSOAPMessage(doc);
        XMLUtils.PrettyElementToWriter((Element)signedMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        this.verifyDkSign(doc);
    }

    private void verifyDkSign(Document doc) throws Exception {
        log.info((Object)"Before verifying the derived key signature");
        ConversationEngine engine = new ConversationEngine(this.config);
        Vector results = engine.processSecConvHeader(doc, "", this.dkcbHandler, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

