/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.verify.STVerifier;
import org.apache.ws.security.util.Loader;
import org.w3c.dom.Document;

public class TrustEngine {
    private Log log = LogFactory.getLog((String)(class$org$apache$ws$security$trust$TrustEngine == null ? (class$org$apache$ws$security$trust$TrustEngine = TrustEngine.class$("org.apache.ws.security.trust.TrustEngine")) : class$org$apache$ws$security$trust$TrustEngine).getName());
    private final String CLAIM_VERIFIER_CLASS = "org.apache.ws.security.trust.ClaimVerifierClass";
    private final String SIGNATURE_VERIFIER_CLASS = "org.apache.ws.security.trust.SignatureVerifierClass";
    private final String ISSUER_VERIFIER_CLASS = "org.apache.ws.security.trust.IssuerVerifierClass";
    private final String CLAIM_VERIFIER_PROPERTIES = "org.apache.ws.security.trust.ClaimVerifierProperties";
    private final String SIGNATURE_VERIFIER_PROPERTIES = "org.apache.ws.security.trust.SignatureVerifierProperties";
    private final String ISSUER_VERIFIER_PROPERTIES = "org.apache.ws.security.trust.IssuerVerifierProperties";
    private STVerifier claimVerifier;
    private STVerifier signatureVerifier;
    private STVerifier issuerVerifier;
    static /* synthetic */ Class class$org$apache$ws$security$trust$TrustEngine;
    static /* synthetic */ Class class$java$util$Properties;

    public TrustEngine(String propFileName) throws WSTrustException {
    }

    public TrustEngine() throws WSTrustException {
        try {
            Properties prop = this.getProperties("trustEngine.properties");
            this.configureEngine(prop);
        }
        catch (Exception e) {
            throw new WSTrustException(e.getMessage(), e);
        }
    }

    private void configureEngine(Properties prop) throws WSTrustException {
        Properties climProp = this.getProperties(prop.getProperty("org.apache.ws.security.trust.ClaimVerifierProperties"));
        Properties sigProp = this.getProperties(prop.getProperty("org.apache.ws.security.trust.SignatureVerifierProperties"));
        Properties issuerProp = this.getProperties(prop.getProperty("org.apache.ws.security.trust.IssuerVerifierProperties"));
        this.claimVerifier = this.loadClass(prop.getProperty("org.apache.ws.security.trust.ClaimVerifierClass"), climProp);
        this.signatureVerifier = this.loadClass(prop.getProperty("org.apache.ws.security.trust.SignatureVerifierClass"), sigProp);
        this.issuerVerifier = this.loadClass(prop.getProperty("org.apache.ws.security.trust.IssuerVerifierClass"), issuerProp);
    }

    public boolean verifyTrust(Document doc) throws WSTrustException {
        return this.claimVerifier.verify(doc) && this.signatureVerifier.verify(doc) && this.issuerVerifier.verify(doc);
    }

    private Properties getProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
            this.log.debug((Object)"SessionMonitor.properties found");
        }
        catch (Exception e) {
            this.log.debug((Object)("Cannot find SessionMonitor property file: " + propFilename));
            throw new RuntimeException("SessionMonitor: Cannot load properties: " + propFilename);
        }
        return properties;
    }

    private STVerifier loadClass(String className, Properties properties) throws WSTrustException {
        STVerifier verifier = null;
        Class<?> verfierClass = null;
        try {
            verfierClass = Class.forName(className);
            Class[] classes = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = TrustEngine.class$("java.util.Properties")) : class$java$util$Properties};
            Constructor<?> c = verfierClass.getConstructor(classes);
            verifier = (STVerifier)c.newInstance(properties);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(className + " Not Found");
        }
        catch (Exception e) {
            throw new WSTrustException(e.getMessage(), e);
        }
        return verifier;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

