/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.trust.secconv.interop;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.axis.AxisFault;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.utils.DOM2Writer;
import org.apache.ws.axis.security.trust.secconv.interop.InteropSAMLIssuerImpl;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationUtil;
import org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.RequestedSecurityToken;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.policy.message.token.AppliesTo;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.apache.ws.security.trust.issue.STIssuer;
import org.apache.ws.security.trust.message.token.BinarySecret;
import org.apache.ws.security.trust.message.token.ComputedKey;
import org.apache.ws.security.trust.message.token.Entropy;
import org.apache.ws.security.trust.message.token.LifeTime;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UNT2SAMLIssuer
implements STIssuer {
    private boolean doDebug = false;

    public Document issue(Document req, Document res) throws Exception {
        try {
            Element elemHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), res, req.getDocumentElement(), false);
            NodeList tempList = elemHeader.getChildNodes();
            Element elemUnt = null;
            for (int i = 0; i < tempList.getLength(); ++i) {
                Node n = tempList.item(i);
                if (n.getNodeType() != 1 || !n.getLocalName().equals("UsernameToken")) continue;
                elemUnt = (Element)n;
            }
            UsernameToken unt = new UsernameToken(WSSConfig.getDefaultWSConfig(), elemUnt);
            if (this.doDebug) {
                System.out.println("Node count : " + tempList.getLength());
                System.out.println("Username token: " + DOM2Writer.nodeToString((Node)elemUnt, (boolean)true));
                System.out.println("Username: " + unt.getName());
                System.out.println("Password: " + unt.getPassword());
            }
            Element elemAppliesTo = (Element)WSSecurityUtil.findElement(req, AppliesTo.TOKEN.getLocalPart(), AppliesTo.TOKEN.getNamespaceURI());
            Element elemEpr = (Element)elemAppliesTo.getFirstChild();
            EndpointReference epr = new EndpointReference(elemEpr);
            LifeTime lt = new LifeTime(res, 720);
            Element elemLifeTime = lt.getElement();
            AppliesTo appliesToRes = new AppliesTo(res);
            appliesToRes.setAnyElement(new EndpointReference(epr.toDOM(req)).toDOM(res));
            Element elemEntropy = (Element)WSSecurityUtil.findElement(req, Entropy.TOKEN.getLocalPart(), Entropy.TOKEN.getNamespaceURI());
            Element elemBinSecret = (Element)elemEntropy.getFirstChild();
            BinarySecret binSecretReq = new BinarySecret(elemBinSecret);
            String nonceReq = binSecretReq.getBinarySecretValue();
            Entropy entropyRes = new Entropy(res);
            BinarySecret binSecretRes = new BinarySecret(res);
            String nonceRes = ConversationUtil.generateNonce(128);
            binSecretRes.setBinarySecretValue(nonceRes);
            entropyRes.setBinarySecret(binSecretRes);
            RequestedProofToken requestedProofTokenRes = new RequestedProofToken(res);
            ComputedKey computedKeyRes = new ComputedKey(res);
            computedKeyRes.setComputedKeyValue("http://schemas.xmlsoap.org/ws/2004/04/security/trust/CK/PSHA1");
            requestedProofTokenRes.addToken(computedKeyRes.getElement());
            RequestSecurityTokenResponse requestSecurityTokenResponse = new RequestSecurityTokenResponse(res);
            RequestedSecurityToken requestedSecurityToken = new RequestedSecurityToken(res);
            byte[] sx = this.generateSymmetricFromEntropy(nonceReq, nonceRes);
            requestedSecurityToken.addToken(this.getSignedSAMLToken(res, epr.getAddress().toString(), sx, this.getEmailFromUserName(unt.getName())));
            requestSecurityTokenResponse.addToken(elemLifeTime);
            requestSecurityTokenResponse.addToken(appliesToRes.getElement());
            requestSecurityTokenResponse.addToken(requestedSecurityToken.getElement());
            requestSecurityTokenResponse.addToken(requestedProofTokenRes.getElement());
            requestSecurityTokenResponse.addToken(entropyRes.getElement());
            Element elemEnv = res.getDocumentElement();
            SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(elemEnv);
            Element elemBody = WSSecurityUtil.findBodyElement(elemEnv.getOwnerDocument(), soapConstants);
            elemBody.appendChild(requestSecurityTokenResponse.getElement());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Element getSignedSAMLToken(Document doc, String epr, byte[] sx, String username) throws Exception {
        Crypto crypto = CryptoFactory.getInstance("interop_STS_crypto.properties");
        String samlPropFile = "interop_saml_STS.properties";
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setUserCrypto(crypto);
        saml.setInstanceDoc(doc);
        saml.setUsername(username);
        ((InteropSAMLIssuerImpl)saml).setEpr(epr);
        ((InteropSAMLIssuerImpl)saml).setSx(sx);
        SAMLAssertion assertion = saml.newAssertion();
        if (assertion == null) {
            throw new AxisFault("Issuer: Signed SAML: no SAML token received");
        }
        Element assertionAsDom = (Element)assertion.toDOM(doc);
        return assertionAsDom;
    }

    private byte[] generateSymmetricFromEntropy(String requesterNonce, String responderNonce) throws Exception {
        return this.P_hash(requesterNonce.getBytes(), responderNonce.getBytes(), 16);
    }

    private byte[] P_hash(byte[] secret, byte[] seed, int required) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA1");
        byte[] out = new byte[required];
        int offset = 0;
        byte[] A = seed;
        while (required > 0) {
            SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
            mac.init(key);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(A);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int tocpy = this.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, tocpy);
            offset += tocpy;
            required -= tocpy;
        }
        return out;
    }

    private int min(int a, int b) {
        return a > b ? b : a;
    }

    private String getEmailFromUserName(String username) throws AxisFault {
        if (username.equals("Alice")) {
            return "alice@fabrikam.com";
        }
        if (username.equals("Bob")) {
            return "bob@fabrikam.com";
        }
        if (username.equals("Charlie")) {
            return "charlie@fabrikam.com";
        }
        if (username.equals("Dawn")) {
            return "dawn@fabrikam.com";
        }
        if (username.equals("Evan")) {
            return "evan@fabrikam.com";
        }
        if (username.equals("Fred")) {
            return "fred@fabrikam.com";
        }
        if (username.equals("Graham")) {
            return "graham@fabrikam.com";
        }
        if (username.equals("Hayley")) {
            return "hayley@fabrikam.com";
        }
        if (username.equals("Imogen")) {
            return "imogen@fabrikam.com";
        }
        throw new AxisFault("Invalid user: This should be checked at the WSDoAllReceiver");
    }
}

