/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.trust.secconv.interop;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import sun.security.util.DerValue;

public class InteropSAMLIssuerImpl
implements SAMLIssuer {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$axis$security$trust$secconv$interop$InteropSAMLIssuerImpl == null ? (class$org$apache$ws$axis$security$trust$secconv$interop$InteropSAMLIssuerImpl = InteropSAMLIssuerImpl.class$("org.apache.ws.axis.security.trust.secconv.interop.InteropSAMLIssuerImpl")) : class$org$apache$ws$axis$security$trust$secconv$interop$InteropSAMLIssuerImpl).getName());
    private SAMLAssertion sa = null;
    private Document instanceDoc = null;
    private Properties properties = null;
    private Crypto issuerCrypto = null;
    private Crypto userCrypto = null;
    private String issuerKeyPassword = null;
    private String issuerKeyName = null;
    private boolean senderVouches = true;
    private String[] confirmationMethods = new String[1];
    private String username = null;
    private String epr = null;
    private byte[] sx;
    private Hashtable trustedCertsTable = null;
    static /* synthetic */ Class class$org$apache$ws$axis$security$trust$secconv$interop$InteropSAMLIssuerImpl;

    public void setEpr(String epr) {
        this.epr = epr;
    }

    public void setSx(byte[] sx) {
        this.sx = sx;
    }

    public InteropSAMLIssuerImpl() {
    }

    public InteropSAMLIssuerImpl(Properties prop) {
        if (prop == null) {
            return;
        }
        this.properties = prop;
        String cryptoProp = this.properties.getProperty("org.apache.ws.security.saml.issuer.cryptoProp.file");
        if (cryptoProp != null) {
            this.issuerCrypto = CryptoFactory.getInstance(cryptoProp);
            this.issuerKeyName = this.properties.getProperty("org.apache.ws.security.saml.issuer.key.name");
            this.issuerKeyPassword = this.properties.getProperty("org.apache.ws.security.saml.issuer.key.password");
        }
        if ("senderVouches".equals(this.properties.getProperty("org.apache.ws.security.saml.confirmationMethod"))) {
            this.confirmationMethods[0] = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        } else if ("keyHolder".equals(this.properties.getProperty("org.apache.ws.security.saml.confirmationMethod"))) {
            this.confirmationMethods[0] = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
            this.senderVouches = false;
        }
        this.initializeTrustedServicesList(this.properties.getProperty("org.apache.ws.security.saml.certPath"));
    }

    public SAMLAssertion newAssertion() {
        block11: {
            String issuer = this.properties.getProperty("org.apache.ws.security.saml.issuer");
            String format = this.properties.getProperty("org.apache.ws.security.saml.subjectNameId.format");
            try {
                SAMLNameIdentifier nameId = new SAMLNameIdentifier(this.username, "", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                String subjectIP = null;
                String authMethod = null;
                if ("password".equals(this.properties.getProperty("org.apache.ws.security.saml.authenticationMethod"))) {
                    authMethod = "urn:oasis:names:tc:SAML:1.0:am:password";
                }
                Date authInstant = new Date();
                Collection bindings = null;
                SAMLSubject subject = new SAMLSubject(nameId, Arrays.asList(this.confirmationMethods), null, null);
                SAMLStatement[] statements = new SAMLStatement[]{new SAMLAuthenticationStatement(subject, authMethod, authInstant, subjectIP, null, bindings)};
                SAMLAudienceRestrictionCondition sarc = new SAMLAudienceRestrictionCondition();
                sarc.addAudience(this.epr);
                SAMLCondition[] conditions = new SAMLCondition[]{sarc};
                this.sa = new SAMLAssertion(issuer, null, null, Arrays.asList(conditions), null, Arrays.asList(statements));
                Date now = new Date();
                this.sa.setNotBefore(now);
                this.sa.setNotOnOrAfter(new Date(now.getTime() + 43200000L));
                if (this.senderVouches) break block11;
                Element soapEnvelope = (Element)this.instanceDoc.getFirstChild();
                soapEnvelope.setAttribute("xmlns:wsse", WSConstants.WSSE_NS);
                KeyInfo ki = new KeyInfo(this.instanceDoc);
                try {
                    X509Certificate cer = this.getCertificate(this.epr);
                    Element xencEnckey = this.encryptSx(this.instanceDoc, cer);
                    WSSecurityUtil.appendChildElement(this.instanceDoc, ki.getElement(), xencEnckey);
                    subject.setKeyInfo((Object)ki);
                }
                catch (WSSecurityException e) {
                    e.printStackTrace();
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                try {
                    X509Certificate[] issuerCerts = this.issuerCrypto.getCertificates(this.issuerKeyName);
                    String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
                    log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
                    if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                        sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                    }
                    PrivateKey issuerPK = this.issuerCrypto.getPrivateKey(this.issuerKeyName, this.issuerKeyPassword);
                    this.sa.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
                }
                catch (WSSecurityException e1) {
                    e1.printStackTrace();
                    return null;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
            catch (SAMLException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }
        return this.sa;
    }

    public void setUserCrypto(Crypto userCrypto) {
        this.userCrypto = userCrypto;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Crypto getIssuerCrypto() {
        return this.issuerCrypto;
    }

    public String getIssuerKeyName() {
        return this.issuerKeyName;
    }

    public String getIssuerKeyPassword() {
        return this.issuerKeyPassword;
    }

    public boolean isSenderVouches() {
        return this.senderVouches;
    }

    public void setInstanceDoc(Document instanceDoc) {
        this.instanceDoc = instanceDoc;
    }

    private X509Certificate getCertificate(String epr) throws CertificateException, FileNotFoundException {
        String certPath = (String)this.trustedCertsTable.get(epr);
        CertificateFactory certFac = CertificateFactory.getInstance("X.509");
        System.out.println(certPath + " : " + epr);
        return (X509Certificate)certFac.generateCertificate(new FileInputStream(certPath));
    }

    private void initializeTrustedServicesList(String certPath) {
        this.trustedCertsTable = new Hashtable();
        System.out.println("***** If you are getting trouble, change the seravices *****\nFIND ANOTHER WAY TO STORE THE TRUSTED LIST OF SERVICES WITH THE RELAVENT CERTIFICATES");
        this.trustedCertsTable.put("http://127.0.0.1:9080/axis/services/EchoInterop", certPath + "/WSETEST.cer");
        this.trustedCertsTable.put("http://192.168.1.106/Service/Service.ashx", certPath + "TrustSecConvinterop/ms1/cert1.cer");
        this.trustedCertsTable.put("http://192.168.1.50:8080/sct/Service", certPath + "TrustSecConvinterop/ibm/ibm-sp.cer");
        this.trustedCertsTable.put("http://192.35.232.216:8080/sct/Service", certPath + "TrustSecConvinterop/ibm/ibm-sp2.cer");
        this.trustedCertsTable.put("http://192.168.1.104:7070/Service", certPath + "TrustSecConvinterop/systinet/Systinet-S.crt");
    }

    public Element encryptSx(Document doc, X509Certificate remoteCert) throws WSSecurityException {
        log.debug((Object)"Beginning Encryption...");
        Element envelope = doc.getDocumentElement();
        envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        SecretKeySpec symmetricKey = new SecretKeySpec(this.sx, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        String certUri = "EncCertId-" + remoteCert.hashCode();
        Cipher cipher = WSSecurityUtil.getCipherInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        try {
            cipher.init(1, remoteCert);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(8, null, null, e);
        }
        byte[] encKey = symmetricKey.getEncoded();
        byte[] encryptedKey = null;
        try {
            encryptedKey = cipher.doFinal(encKey);
        }
        catch (IllegalStateException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (IllegalBlockSizeException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (BadPaddingException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        Text keyText = WSSecurityUtil.createBase64EncodedTextNode(doc, encryptedKey);
        Element xencEncryptedKey = WSEncryptBody.createEnrcyptedKey(doc, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        X509Data x509Data = new X509Data(doc);
        x509Data.addSKI(this.issuerCrypto.getSKIBytesFromCert(remoteCert));
        KeyInfo keyInfo = new KeyInfo(doc);
        keyInfo.addUnknownElement(x509Data.getElement());
        WSSecurityUtil.appendChildElement(doc, xencEncryptedKey, keyInfo.getElement());
        Element xencCipherValue = WSEncryptBody.createCipherValue(doc, xencEncryptedKey);
        xencCipherValue.appendChild(keyText);
        log.debug((Object)"Encryption complete.");
        return xencEncryptedKey;
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] data = null;
        byte[] abyte0 = null;
        if (cert.getVersion() < 3) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3)"});
        }
        data = cert.getExtensionValue("2.5.29.14");
        if (data == null) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"No extension data"});
        }
        DerValue derValue = null;
        try {
            derValue = new DerValue(data);
        }
        catch (IOException e) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"cannot read SKI value"});
        }
        if (derValue == null) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"No DER value"});
        }
        if (derValue.tag != 4) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"No octet string"});
        }
        byte[] extensionValue = null;
        try {
            extensionValue = derValue.getOctetString();
        }
        catch (IOException e1) {
            throw new WSSecurityException(1, "noSKIHandling", new Object[]{"cannot read SKI value as octet data"});
        }
        abyte0 = new byte[extensionValue.length - 2];
        System.arraycopy(extensionValue, 2, abyte0, 0, abyte0.length);
        return abyte0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

