/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDoAllReceiver
extends BasicHandler {
    static Log log = LogFactory.getLog((String)(class$org$apache$ws$axis$security$WSDoAllReceiver == null ? (class$org$apache$ws$axis$security$WSDoAllReceiver = WSDoAllReceiver.class$("org.apache.ws.axis.security.WSDoAllReceiver")) : class$org$apache$ws$axis$security$WSDoAllReceiver).getName());
    static final WSSecurityEngine secEngine = WSSecurityEngine.getInstance();
    private boolean doDebug = false;
    private static Hashtable cryptos = new Hashtable(5);
    static /* synthetic */ Class class$org$apache$ws$axis$security$WSDoAllReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (this.doDebug) {
            log.debug((Object)("WSDoAllReceiver: enter invoke() with msg type: " + msgContext.getCurrentMessage().getMessageType()));
        }
        RequestData reqData = new RequestData();
        try {
            Timestamp timestamp;
            X509Certificate returnCert;
            reqData.msgContext = msgContext;
            Vector actions = new Vector();
            String action = null;
            action = (String)this.getOption("action");
            if (action == null) {
                action = (String)msgContext.getProperty("action");
            }
            if (action == null) {
                throw new AxisFault("WSDoAllReceiver: No action defined");
            }
            int doAction = AxisUtil.decodeAction(action, actions);
            String actor = (String)this.getOption("actor");
            Message sm = msgContext.getCurrentMessage();
            Document doc = null;
            try {
                doc = sm.getSOAPEnvelope().getAsDocument();
                if (this.doDebug) {
                    log.debug((Object)"Received SOAP request: ");
                    log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
                }
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot convert into document", (Throwable)ex);
            }
            String msgType = sm.getMessageType();
            if (msgType != null && msgType.equals("response")) {
                SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
                if (WSSecurityUtil.findElement(doc.getDocumentElement(), "Fault", soapConstants.getEnvelopeURI()) != null) {
                    return;
                }
            }
            CallbackHandler cbHandler = null;
            if ((doAction & 5) != 0) {
                cbHandler = this.getPasswordCB(reqData);
            }
            if ((doAction & 2) == 2) {
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 4) == 4) {
                this.decodeDecryptionParameter(reqData);
            }
            Vector wsResult = null;
            try {
                wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.sigCrypto, reqData.decCrypto);
            }
            catch (WSSecurityException ex) {
                ex.printStackTrace();
                throw new AxisFault("WSDoAllReceiver: security processing failed", (Throwable)ex);
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                throw new AxisFault("WSDoAllReceiver: Request does not contain required Security header");
            }
            ArrayList<QName> processedHeaders = new ArrayList<QName>();
            Iterator iterator = sm.getSOAPEnvelope().getHeaders().iterator();
            while (iterator.hasNext()) {
                org.apache.axis.message.SOAPHeaderElement tempHeader = (org.apache.axis.message.SOAPHeaderElement)iterator.next();
                if (!tempHeader.isProcessed()) continue;
                processedHeaders.add(tempHeader.getQName());
            }
            SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            org.apache.xml.security.utils.XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            sPart.setCurrentMessage((Object)os.toByteArray(), 4);
            if (this.doDebug) {
                log.debug((Object)"Processed received SOAP request");
                log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
            }
            iterator = processedHeaders.iterator();
            while (iterator.hasNext()) {
                QName qname = (QName)iterator.next();
                Enumeration headersByName = sm.getSOAPEnvelope().getHeadersByName(qname.getNamespaceURI(), qname.getLocalPart());
                while (headersByName.hasMoreElements()) {
                    org.apache.axis.message.SOAPHeaderElement tempHeader = (org.apache.axis.message.SOAPHeaderElement)headersByName.nextElement();
                    tempHeader.setProcessed(true);
                }
            }
            SOAPHeader sHeader = null;
            try {
                sHeader = sm.getSOAPEnvelope().getHeader();
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot get SOAP header after security processing", (Throwable)ex);
            }
            Iterator headers = sHeader.examineHeaderElements(actor);
            SOAPHeaderElement headerElement = null;
            while (headers.hasNext()) {
                SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
                if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
                headerElement = hE;
                break;
            }
            ((org.apache.axis.message.SOAPHeaderElement)headerElement).setProcessed(true);
            WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(wsResult, 2);
            if (actionResult != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
                throw new AxisFault("WSDoAllReceiver: The certificate used for the signature is not trusted");
            }
            actionResult = WSSecurityUtil.fetchActionResult(wsResult, 32);
            if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null) {
                String ttl = null;
                ttl = (String)this.getOption("timeToLive");
                if (ttl == null) {
                    ttl = (String)msgContext.getProperty("timeToLive");
                }
                int ttl_i = 0;
                if (ttl != null) {
                    try {
                        ttl_i = Integer.parseInt(ttl);
                    }
                    catch (NumberFormatException e) {
                        ttl_i = reqData.timeToLive;
                    }
                }
                if (ttl_i <= 0) {
                    ttl_i = reqData.timeToLive;
                }
                if (!this.verifyTimestamp(timestamp, reqData.timeToLive)) {
                    throw new AxisFault("WSDoAllReceiver: The timestamp could not be validated");
                }
            }
            int resultActions = wsResult.size();
            int size = actions.size();
            if (size != resultActions) {
                throw new AxisFault("WSDoAllReceiver: security processing failed (actions number mismatch)");
            }
            for (int i = 0; i < size; ++i) {
                if (((Integer)actions.get(i)).intValue() == ((WSSecurityEngineResult)wsResult.get(i)).getAction()) continue;
                throw new AxisFault("WSDoAllReceiver: security processing failed (actions mismatch)");
            }
            Vector<WSHandlerResult> results = null;
            results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<WSHandlerResult>();
                msgContext.setProperty("RECV_RESULTS", results);
            }
            WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
            results.add(0, rResult);
            if (this.doDebug) {
                log.debug((Object)"WSDoAllReceiver: exit invoke()");
            }
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    protected Crypto loadSignatureCrypto(RequestData reqData) throws AxisFault {
        Crypto crypto = null;
        reqData.sigPropFile = (String)this.getOption("signaturePropFile");
        if (reqData.sigPropFile == null) {
            reqData.sigPropFile = (String)reqData.msgContext.getProperty("signaturePropFile");
        }
        if (reqData.sigPropFile != null) {
            crypto = (Crypto)cryptos.get(reqData.sigPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(reqData.sigPropFile);
                cryptos.put(reqData.sigPropFile, crypto);
            }
        } else {
            throw new AxisFault("WSDoAllReceiver: Signature: no crypto property file");
        }
        return crypto;
    }

    protected Crypto loadDecryptionCrypto(RequestData reqData) throws AxisFault {
        Crypto crypto = null;
        reqData.decPropFile = (String)this.getOption("decryptionPropFile");
        if (reqData.decPropFile == null) {
            reqData.decPropFile = (String)reqData.msgContext.getProperty("decryptionPropFile");
        }
        if (reqData.decPropFile != null) {
            crypto = (Crypto)cryptos.get(reqData.decPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(reqData.decPropFile);
                cryptos.put(reqData.decPropFile, crypto);
            }
        } else {
            crypto = reqData.sigCrypto;
            if (crypto == null) {
                throw new AxisFault("WSDoAllReceiver: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    private void decodeSignatureParameter(RequestData reqData) throws AxisFault {
        reqData.sigCrypto = this.loadSignatureCrypto(reqData);
    }

    private void decodeDecryptionParameter(RequestData reqData) throws AxisFault {
        reqData.decCrypto = this.loadDecryptionCrypto(reqData);
    }

    private CallbackHandler getPasswordCB(RequestData reqData) throws AxisFault {
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.getOption("passwordCallbackClass");
        if (callback == null) {
            callback = (String)reqData.msgContext.getProperty("passwordCallbackClass");
        }
        if (callback != null) {
            Class<?> cbClass = null;
            try {
                cbClass = Class.forName(callback);
            }
            catch (ClassNotFoundException e) {
                throw new AxisFault("WSDoAllReceiver: cannot load password callback class: " + callback, (Throwable)e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new AxisFault("WSDoAllReceiver: cannot create instance of password callback: " + callback, (Throwable)e);
            }
        }
        cbHandler = (CallbackHandler)reqData.msgContext.getProperty("passwordCallbackRef");
        if (cbHandler == null) {
            throw new AxisFault("WSDoAllReceiver: no reference in callback property");
        }
        return cbHandler;
    }

    private boolean verifyTrust(X509Certificate cert, RequestData reqData) throws AxisFault {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (this.doDebug) {
            log.debug((Object)("WSDoAllReceiver: Transmitted certificate has subject " + subjectString));
            log.debug((Object)("WSDoAllReceiver: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            alias = reqData.sigCrypto.getAliasForX509Cert(issuerString, issuerSerial);
        }
        catch (WSSecurityException ex) {
            throw new AxisFault("WSDoAllReceiver: Could not get alias for certificate with " + subjectString, (Throwable)ex);
        }
        if (alias != null) {
            try {
                certs = reqData.sigCrypto.getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new AxisFault("WSDoAllReceiver: Could not get certificates for alias " + alias, (Throwable)ex);
            }
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (this.doDebug) {
                    log.debug((Object)("Direct trust for certificate with " + subjectString));
                }
                return true;
            }
        } else if (this.doDebug) {
            log.debug((Object)("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            aliases = reqData.sigCrypto.getAliasesForDN(issuerString);
        }
        catch (WSSecurityException ex) {
            throw new AxisFault("WSDoAllReceiver: Could not get alias for certificate with " + issuerString, (Throwable)ex);
        }
        if (aliases == null || aliases.length < 1) {
            if (this.doDebug) {
                log.debug((Object)("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (this.doDebug) {
                log.debug((Object)("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString));
            }
            try {
                certs = reqData.sigCrypto.getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new AxisFault("WSDoAllReceiver: Could not get certificates for alias " + alias, (Throwable)ex);
            }
            if (certs == null | certs.length < 1) {
                throw new AxisFault("WSDoAllReceiver: Could not get certificates for alias " + alias);
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length + 1];
            x509certs[0] = cert;
            for (int j = 0; j < certs.length; ++j) {
                x509certs[certs.length + j] = cert = certs[i];
            }
            certs = x509certs;
            try {
                if (!reqData.sigCrypto.validateCertPath(certs)) continue;
                if (this.doDebug) {
                    log.debug((Object)("WSDoAllReceiver: Certificate path has been verified for certificate with subject " + subjectString));
                }
                return true;
            }
            catch (WSSecurityException ex) {
                throw new AxisFault("WSDoAllReceiver: Certificate path verification failed for certificate with subject " + subjectString, (Throwable)ex);
            }
        }
        log.debug((Object)("WSDoAllReceiver: Certificate path could not be verified for certificate with subject " + subjectString));
        return false;
    }

    protected boolean verifyTimestamp(Timestamp timestamp, int timeToLive) throws AxisFault {
        Calendar validCreation = Calendar.getInstance();
        long currentTime = validCreation.getTimeInMillis();
        validCreation.setTimeInMillis(currentTime -= (long)(timeToLive * 1000));
        if (this.doDebug) {
            log.debug((Object)"Preparing to verify the timestamp");
            SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
            log.debug((Object)("Validation of Timestamp: Current time is " + zulu.format(Calendar.getInstance().getTime())));
            log.debug((Object)("Validation of Timestamp: Valid creation is " + zulu.format(validCreation.getTime())));
            log.debug((Object)("Validation of Timestamp: Timestamp created is " + zulu.format(timestamp.getCreated().getTime())));
        }
        if (!timestamp.getCreated().after(validCreation)) {
            if (this.doDebug) {
                log.debug((Object)"Validation of Timestamp: The message was created too long ago");
            }
            return false;
        }
        log.debug((Object)"Validation of Timestamp: Everything is ok");
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RequestData {
        MessageContext msgContext = null;
        Crypto sigCrypto = null;
        String sigPropFile = null;
        Crypto decCrypto = null;
        String decPropFile = null;
        int timeToLive = 300;

        private RequestData() {
        }

        void clear() {
            this.decCrypto = null;
            this.decPropFile = null;
            this.msgContext = null;
            this.sigCrypto = null;
            this.sigPropFile = null;
        }
    }
}

