/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.jndi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.naming.Context;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.globus.wsrf.jndi.JNDIUtils;

public class JNDITest
extends TestCase {
    private static Context initialContext = null;
    private static final String TEST_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<jndiConfig xmlns=\"http://wsrf.globus.org/jndi/config\">\r\n    <global>\r\n        <environment name=\"test1\" \r\n                     type=\"java.lang.String\"\r\n                     value=\"testString\"/>\r\n        <environment name=\"test3\" \r\n                     type=\"java.lang.Byte\"\r\n                     value=\"111\"/>\r\n        <environment name=\"test4\" \r\n                     type=\"java.lang.Character\"\r\n                     value=\"q\"/>\r\n        <environment name=\"test5\" \r\n                     type=\"java.lang.Double\"\r\n                     value=\"1.12345\"/>\r\n        <environment name=\"test6\" \r\n                     type=\"java.lang.Float\"\r\n                     value=\"1.12345\"/>\r\n        <environment name=\"test7\" \r\n                     type=\"java.lang.Integer\"\r\n                     value=\"12345\"/>\r\n        <environment name=\"test8\" \r\n                     type=\"java.lang.Long\"\r\n                     value=\"12345\"/>\r\n        <environment name=\"test9\" \r\n                     type=\"java.lang.Short\"\r\n                     value=\"12345\"/>\r\n        <resource name=\"testResource1\" \r\n                     type=\"java.lang.String\"\r\n                     description=\"Produces test strings\">\r\n            <resourceParams>\r\n                <parameter>\r\n                    <name>\r\n                        factory\r\n                    </name>\r\n                    <value>\r\n                        org.globus.wsrf.jndi.TestFactory\r\n                    </value>\r\n                </parameter>\r\n                <parameter>\r\n                    <name>\r\n                        baseString\r\n                    </name>\r\n                    <value>\r\n                        Global Test Nr: \r\n                    </value>\r\n                </parameter>\r\n            </resourceParams>\r\n        </resource>\r\n    </global>\r\n    <service name=\"TestService\">\r\n        <environment name=\"test2\" \r\n                     type=\"java.lang.Boolean\"\r\n                     value=\"true\"/>\r\n        <resource name=\"testResource2\" \r\n                     type=\"java.lang.String\"\r\n                     description=\"Produces test strings\">\r\n            <resourceParams>\r\n                <parameter>\r\n                    <name>\r\n                        factory\r\n                    </name>\r\n                    <value>\r\n                        org.globus.wsrf.jndi.TestFactory\r\n                    </value>\r\n                </parameter>\r\n                <parameter>\r\n                    <name>\r\n                        baseString\r\n                    </name>\r\n                    <value>\r\n                        Service Test Nr: \r\n                    </value>\r\n                </parameter>\r\n            </resourceParams>\r\n        </resource>\r\n        <resourceLink name=\"testResource1\" \r\n                     target=\"java:comp/env/testResource1\"/>\r\n    </service>\r\n</jndiConfig>\r\n";
    static /* synthetic */ Class class$org$globus$wsrf$jndi$JNDITest;

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$jndi$JNDITest == null ? (class$org$globus$wsrf$jndi$JNDITest = JNDITest.class$("org.globus.wsrf.jndi.JNDITest")) : class$org$globus$wsrf$jndi$JNDITest);
    }

    public void setUp() throws Exception {
        if (initialContext == null) {
            ByteArrayInputStream input = new ByteArrayInputStream(TEST_CONFIG.getBytes());
            initialContext = JNDIUtils.initJNDI();
            JNDIUtils.parseJNDIConfig((InputStream)input);
        }
    }

    public void testJNDIConfigEnvironment() throws Exception {
        JNDITest.assertEquals((String)((String)initialContext.lookup("java:comp/env/test1")), (String)"testString");
        JNDITest.assertEquals((Object)((Boolean)initialContext.lookup("java:comp/env/services/TestService/test2")), (Object)Boolean.TRUE);
        JNDITest.assertEquals((Object)((Byte)initialContext.lookup("java:comp/env/test3")), (Object)new Byte(111));
        JNDITest.assertEquals((Object)((Character)initialContext.lookup("java:comp/env/test4")), (Object)new Character('q'));
        JNDITest.assertEquals((Object)((Double)initialContext.lookup("java:comp/env/test5")), (Object)new Double(1.12345));
        JNDITest.assertEquals((Object)((Float)initialContext.lookup("java:comp/env/test6")), (Object)new Float(1.12345));
        JNDITest.assertEquals((Object)((Integer)initialContext.lookup("java:comp/env/test7")), (Object)new Integer(12345));
        JNDITest.assertEquals((Object)((Long)initialContext.lookup("java:comp/env/test8")), (Object)new Long(12345L));
        JNDITest.assertEquals((Object)((Short)initialContext.lookup("java:comp/env/test9")), (Object)new Short(12345));
    }

    public void testJNDIConfigResource() throws Exception {
        JNDITest.assertEquals((String)"Global Test Nr: 0", (String)((String)initialContext.lookup("java:comp/env/testResource1")));
        JNDITest.assertEquals((String)"Service Test Nr: 1", (String)((String)initialContext.lookup("java:comp/env/services/TestService/testResource2")));
    }

    public void testJNDIConfigResourceLink() throws Exception {
        JNDITest.assertEquals((String)"Global Test Nr: 0", (String)((String)initialContext.lookup("java:comp/env/services/TestService/testResource1")));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

