/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.work;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.naming.Context;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.globus.wsrf.jndi.JNDIUtils;

public class WorkTest
extends TestCase {
    private static Context initialContext = null;
    private static final String TIMER_JNDI_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<jndiConfig xmlns=\"http://wsrf.globus.org/jndi/config\">\r\n    <global>\r\n        <resource name=\"wm/ContainerWorkManager\" \r\n                  type=\"org.globus.wsrf.impl.work.WorkManagerImpl\"\r\n                  >\r\n            <resourceParams>\r\n                <parameter>\r\n                    <name>\r\n                        factory\r\n                    </name>\r\n                    <value>\r\n                        org.apache.naming.factory.BeanFactory\r\n                    </value>\r\n                </parameter>\r\n            </resourceParams>\r\n        </resource>\r\n    </global>\r\n</jndiConfig>\r\n";
    static /* synthetic */ Class class$org$globus$wsrf$impl$work$WorkTest;

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$work$WorkTest == null ? (class$org$globus$wsrf$impl$work$WorkTest = WorkTest.class$("org.globus.wsrf.impl.work.WorkTest")) : class$org$globus$wsrf$impl$work$WorkTest);
    }

    public void testScheduleWork() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work = new TestWork(1000L);
        WorkItem workItem = workManager.schedule((Work)work);
        this.waitForStatus(workItem, 3, 2000);
        WorkTest.assertEquals((int)3, (int)workItem.getStatus());
        this.waitForStatus(workItem, 4, 2000);
        WorkTest.assertEquals((int)4, (int)workItem.getStatus());
        WorkTest.assertEquals((boolean)true, (boolean)work.getIRan());
    }

    public void testScheduleDaemonWork() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work = new TestWork(1000L, true);
        WorkItem workItem = workManager.schedule((Work)work);
        this.waitForStatus(workItem, 3, 2000);
        WorkTest.assertEquals((int)3, (int)workItem.getStatus());
        this.waitForStatus(workItem, 4, 2000);
        WorkTest.assertEquals((int)4, (int)workItem.getStatus());
        WorkTest.assertEquals((boolean)true, (boolean)work.getIRan());
    }

    public void testWorkListener() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work = new TestWork(1000L);
        TestWorkListener listener = new TestWorkListener();
        workManager.schedule((Work)work, (WorkListener)listener);
        this.waitForStatus(listener, 3, 2000);
        WorkTest.assertEquals((int)3, (int)listener.getStatus());
        this.waitForStatus(listener, 4, 2000);
        WorkTest.assertEquals((int)4, (int)listener.getStatus());
        WorkTest.assertEquals((boolean)true, (boolean)work.getIRan());
    }

    public void testWaitForAllImmediate() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work1 = new TestWork(1000L);
        TestWork work2 = new TestWork(3000L);
        ArrayList<WorkItem> workList = new ArrayList<WorkItem>();
        WorkItem item1 = workManager.schedule((Work)work1);
        WorkItem item2 = workManager.schedule((Work)work2);
        workList.add(item1);
        this.waitForStatus(item1, 4, 2000);
        WorkTest.assertEquals((boolean)true, (boolean)workManager.waitForAll(workList, 0L));
        workList.add(item2);
        WorkTest.assertEquals((boolean)false, (boolean)workManager.waitForAll(workList, 0L));
    }

    public void testWaitForAllIndefinite() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work1 = new TestWork(1000L);
        TestWork work2 = new TestWork(3000L);
        ArrayList<WorkItem> workList = new ArrayList<WorkItem>();
        WorkItem item1 = workManager.schedule((Work)work1);
        WorkItem item2 = workManager.schedule((Work)work2);
        workList.add(item1);
        workList.add(item2);
        WorkTest.assertEquals((boolean)true, (boolean)workManager.waitForAll(workList, Long.MAX_VALUE));
    }

    public void testWaitForAll() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work1 = new TestWork(1000L);
        TestWork work2 = new TestWork(5000L);
        ArrayList<WorkItem> workList = new ArrayList<WorkItem>();
        WorkItem item1 = workManager.schedule((Work)work1);
        WorkItem item2 = workManager.schedule((Work)work2);
        workList.add(item1);
        WorkTest.assertEquals((boolean)true, (boolean)workManager.waitForAll(workList, 3000L));
        workList.add(item2);
        WorkTest.assertEquals((boolean)false, (boolean)workManager.waitForAll(workList, 1000L));
    }

    public void testWaitForAnyImmediate() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work1 = new TestWork(1000L);
        TestWork work2 = new TestWork(3000L);
        ArrayList<WorkItem> workList = new ArrayList<WorkItem>();
        WorkItem item1 = workManager.schedule((Work)work1);
        WorkItem item2 = workManager.schedule((Work)work2);
        workList.add(item1);
        workList.add(item2);
        this.waitForStatus(item1, 4, 2000);
        WorkTest.assertEquals((int)1, (int)workManager.waitForAny(workList, 0L).size());
        this.waitForStatus(item2, 4, 5000);
        WorkTest.assertEquals((int)2, (int)workManager.waitForAny(workList, 0L).size());
    }

    public void testWaitForAny() throws Exception {
        WorkManager workManager = WorkTest.getWorkManager();
        TestWork work1 = new TestWork(1000L);
        TestWork work2 = new TestWork(5000L);
        ArrayList<WorkItem> workList = new ArrayList<WorkItem>();
        WorkItem item1 = workManager.schedule((Work)work1);
        WorkItem item2 = workManager.schedule((Work)work2);
        workList.add(item1);
        workList.add(item2);
        WorkTest.assertEquals((int)1, (int)workManager.waitForAny(workList, 3000L).size());
        WorkTest.assertEquals((int)2, (int)workManager.waitForAny(workList, 10000L).size());
    }

    private static WorkManager getWorkManager() throws Exception {
        if (initialContext == null) {
            ByteArrayInputStream input = new ByteArrayInputStream(TIMER_JNDI_CONFIG.getBytes());
            initialContext = JNDIUtils.initJNDI();
            JNDIUtils.parseJNDIConfig((InputStream)input);
        }
        return (WorkManager)initialContext.lookup("java:comp/env//wm/ContainerWorkManager");
    }

    private void waitForStatus(WorkItem workItem, int status, int maxWait) throws InterruptedException {
        for (int waited = 0; waited < maxWait && workItem.getStatus() != status; waited += 20) {
            Thread.sleep(20L);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TestWorkListener
    implements WorkListener,
    WorkItem {
        int status = -1;

        private TestWorkListener() {
        }

        public void workAccepted(WorkEvent event) {
            this.status = event.getType();
        }

        public void workRejected(WorkEvent event) {
            this.status = event.getType();
        }

        public void workStarted(WorkEvent event) {
            this.status = event.getType();
        }

        public void workCompleted(WorkEvent event) {
            this.status = event.getType();
        }

        public int getStatus() {
            return this.status;
        }
    }

    private class TestWork
    implements Work {
        boolean daemon = false;
        boolean iRan = false;
        boolean release = false;
        long sleepTime = 0L;

        public TestWork(long sleepTime, boolean daemon) {
            this.daemon = daemon;
            this.sleepTime = sleepTime;
        }

        public TestWork(long sleepTime) {
            this(sleepTime, false);
        }

        public boolean getIRan() {
            return this.iRan;
        }

        public void release() {
            this.release = true;
        }

        public boolean isDaemon() {
            return this.daemon;
        }

        public void run() {
            long timeSlept = 0L;
            while (timeSlept < this.sleepTime && !this.release) {
                try {
                    Thread.sleep(10L);
                    timeSlept += 10L;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.iRan = true;
        }
    }
}

