/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.timer;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.naming.Context;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.globus.wsrf.jndi.JNDIUtils;

public class TimerTest
extends TestCase {
    private static Context initialContext = null;
    private static final String TIMER_JNDI_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<jndiConfig xmlns=\"http://wsrf.globus.org/jndi/config\">\r\n    <global>\r\n        <resource name=\"timer/ContainerTimer\" \r\n                  type=\"org.globus.wsrf.impl.timer.TimerManagerImpl\"\r\n                  >\r\n            <resourceParams>\r\n                <parameter>\r\n                    <name>\r\n                        factory\r\n                    </name>\r\n                    <value>\r\n                        org.apache.naming.factory.BeanFactory\r\n                    </value>\r\n                </parameter>\r\n            </resourceParams>\r\n        </resource>\r\n    </global>\r\n</jndiConfig>\r\n";
    static /* synthetic */ Class class$org$globus$wsrf$impl$timer$TimerTest;

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$timer$TimerTest == null ? (class$org$globus$wsrf$impl$timer$TimerTest = TimerTest.class$("org.globus.wsrf.impl.timer.TimerTest")) : class$org$globus$wsrf$impl$timer$TimerTest);
    }

    public void testScheduleDelay() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Timer timer = timerManager.schedule((TimerListener)new TestTimerListener(), 1000L);
        TimerTest.assertEquals((boolean)false, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
        Thread.sleep(500L);
        TimerTest.assertEquals((boolean)false, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
        Thread.sleep(600L);
        TimerTest.assertEquals((boolean)true, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
        timer.cancel();
    }

    public void testScheduleAbsolute() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Calendar time = Calendar.getInstance();
        time.add(14, 1000);
        Timer timer = timerManager.schedule((TimerListener)new TestTimerListener(), time.getTime());
        TimerTest.assertEquals((boolean)false, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
        Thread.sleep(500L);
        TimerTest.assertEquals((boolean)false, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
        Thread.sleep(600L);
        TimerTest.assertEquals((boolean)true, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
        timer.cancel();
    }

    public void testScheduleDelayPeriodic() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Timer timer = timerManager.schedule((TimerListener)new PeriodicTestTimerListener(), 1000L, 1000L);
        TimerTest.assertEquals((int)0, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
        Thread.sleep(1200L);
        TimerTest.assertEquals((int)1, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
        Thread.sleep(1200L);
        TimerTest.assertEquals((int)2, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
        timer.cancel();
    }

    public void testScheduleAbsolutePeriodic() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Calendar time = Calendar.getInstance();
        time.add(14, 1000);
        Timer timer = timerManager.schedule((TimerListener)new PeriodicTestTimerListener(), time.getTime(), 1000L);
        TimerTest.assertEquals((int)0, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
        Thread.sleep(1200L);
        TimerTest.assertEquals((int)1, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
        Thread.sleep(1200L);
        TimerTest.assertEquals((int)2, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
        timer.cancel();
    }

    public void testSuspendResume() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Timer timer = timerManager.schedule((TimerListener)new PeriodicTestTimerListener(), 2000L, 2000L);
        Thread.sleep(2200L);
        timerManager.suspend();
        Thread.sleep(4200L);
        timerManager.resume();
        TimerTest.assertEquals((int)2, (int)((PeriodicTestTimerListener)timer.getTimerListener()).getCount());
    }

    public void testCancel() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Timer timer = timerManager.schedule((TimerListener)new TestTimerListener(), 1000L);
        Thread.sleep(500L);
        timer.cancel();
        Thread.sleep(600L);
        TimerTest.assertEquals((boolean)false, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
    }

    public void testStop() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Timer timer = timerManager.schedule((TimerListener)new TestTimerListener(), 1000L);
        Thread.sleep(500L);
        timerManager.stop();
        Thread.sleep(600L);
        TimerTest.assertEquals((boolean)false, (boolean)((TestTimerListener)timer.getTimerListener()).getIRan());
    }

    public void testException() throws Exception {
        TimerManager timerManager = TimerTest.getTimerManager();
        Timer timer1 = timerManager.schedule((TimerListener)new ExceptionTimerListener(), 100L);
        Thread.sleep(500L);
        Timer timer2 = timerManager.schedule((TimerListener)new ExceptionTimerListener(), 100L);
        Thread.sleep(500L);
        TestTimerListener testListener = new TestTimerListener();
        Timer timer3 = timerManager.schedule((TimerListener)testListener, 100L);
        Thread.sleep(500L);
        TimerTest.assertTrue((boolean)testListener.getIRan());
        timerManager.stop();
    }

    private static TimerManager getTimerManager() throws Exception {
        if (initialContext == null) {
            ByteArrayInputStream input = new ByteArrayInputStream(TIMER_JNDI_CONFIG.getBytes());
            initialContext = JNDIUtils.initJNDI();
            JNDIUtils.parseJNDIConfig((InputStream)input);
        }
        return (TimerManager)initialContext.lookup("java:comp/env//timer/ContainerTimer");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PeriodicTestTimerListener
    implements TimerListener {
        int count = 0;

        private PeriodicTestTimerListener() {
        }

        public int getCount() {
            return this.count;
        }

        public void timerExpired(Timer timer) {
            ++this.count;
        }
    }

    private class TestTimerListener
    implements TimerListener {
        boolean iRan = false;

        private TestTimerListener() {
        }

        public boolean getIRan() {
            return this.iRan;
        }

        public void timerExpired(Timer timer) {
            this.iRan = true;
        }
    }

    private class ExceptionTimerListener
    implements TimerListener {
        private ExceptionTimerListener() {
        }

        public void timerExpired(Timer timer) {
            throw new NullPointerException();
        }
    }
}

