/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import java.security.Principal;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.impl.security.authorization.GridMapAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.authorization.TestAuthorizationChain;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.security.authorization.Interceptor;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Node;

public class TestServiceAuthzChain
extends TestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$TestServiceAuthzChain == null ? (class$org$globus$wsrf$impl$security$authorization$TestServiceAuthzChain = TestServiceAuthzChain.class$("org.globus.wsrf.impl.security.authorization.TestServiceAuthzChain")) : class$org$globus$wsrf$impl$security$authorization$TestServiceAuthzChain).getName());
    private Subject anonSubject = new Subject();
    private String USER1 = "/CN=foo";
    private String USER2 = "/CN=bar";
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$TestServiceAuthzChain;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization;

    public TestServiceAuthzChain(String name) throws Exception {
        super(name);
        Context initialContext = JNDIUtils.initJNDI();
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization == null ? (class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization = TestServiceAuthzChain.class$("org.globus.wsrf.impl.security.authorization.TestSelfAuthorization")) : class$org$globus$wsrf$impl$security$authorization$TestSelfAuthorization);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestServiceAuthzChain.suite());
    }

    public void nottestAnonymous() throws Exception {
        String servicePath = "tempService1";
        ServiceSecurityConfig.initialize((String)servicePath, null);
        Subject serviceSubject = new Subject();
        serviceSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        this.storeServiceSubject(servicePath, serviceSubject);
        GridMap map = new GridMap();
        map.map(this.USER2, "nobody");
        this.storeServiceGridMap(servicePath, map);
        SelfAuthorization pdpSelf = SelfAuthorization.getInstance();
        GridMapAuthorization pdpGridmap = GridMapAuthorization.getInstance();
        Interceptor[] interceptors = new Interceptor[]{pdpSelf, pdpGridmap};
        TestAuthorizationChain testChain = new TestAuthorizationChain(interceptors, servicePath);
        boolean exp = false;
        try {
            testChain.authorize(this.anonSubject, (MessageContext)new org.apache.axis.MessageContext(null), servicePath);
            TestServiceAuthzChain.fail((String)"Failed to throw exception");
        }
        catch (AuthorizationException e) {
            if (e.getMessage().indexOf("anonymous") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        TestServiceAuthzChain.assertTrue((boolean)exp);
    }

    public void testSetPolicy() throws Exception {
        Interceptor[] interceptors = new Interceptor[]{new SetPolicyPDP()};
        TestAuthorizationChain testChain = new TestAuthorizationChain(interceptors, "");
        testChain.setPolicy(null);
    }

    public void testMultiplePDPs() throws Exception {
        String servicePath = "tempService2";
        ServiceSecurityConfig.initialize((String)servicePath, null);
        Subject serviceSubject = new Subject();
        serviceSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        this.storeServiceSubject(servicePath, serviceSubject);
        GridMap map = new GridMap();
        map.map(this.USER1, "nobody");
        map.map(this.USER2, "nobody2");
        this.storeServiceGridMap(servicePath, map);
        Subject callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER2));
        SelfAuthorization pdpSelf = SelfAuthorization.getInstance();
        GridMapAuthorization pdpGridmap = GridMapAuthorization.getInstance();
        Interceptor[] interceptors = new Interceptor[]{pdpSelf, pdpGridmap};
        TestAuthorizationChain testChain = new TestAuthorizationChain(interceptors, servicePath);
        boolean exp = false;
        try {
            testChain.authorize(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), servicePath);
            TestServiceAuthzChain.fail((String)"Failed to throw exception");
        }
        catch (AuthorizationException e) {
            if (e.getMessage().indexOf("not authorized") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        TestServiceAuthzChain.assertTrue((boolean)exp);
        callerSubject = new Subject();
        callerSubject.getPrincipals().add((Principal)new GlobusPrincipal(this.USER1));
        testChain.authorize(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), servicePath);
        IdentityAuthorization pdpIden = new IdentityAuthorization(this.USER2);
        interceptors = new Interceptor[]{pdpSelf, pdpGridmap, pdpIden};
        testChain = new TestAuthorizationChain(interceptors, servicePath);
        exp = false;
        try {
            testChain.authorize(callerSubject, (MessageContext)new org.apache.axis.MessageContext(null), servicePath);
            TestServiceAuthzChain.fail((String)"Failed to throw exception");
        }
        catch (AuthorizationException e) {
            if (e.getMessage().indexOf("not authorized") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        TestServiceAuthzChain.assertTrue((boolean)exp);
    }

    private void storeServiceSubject(String servicePath, Subject subject) throws Exception {
        ServiceSecurityConfig.setSubject((Subject)subject, (String)servicePath);
    }

    private void storeServiceGridMap(String servicePath, GridMap map) throws Exception {
        ServiceSecurityConfig.setGridMap((GridMap)map, (String)servicePath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SetPolicyPDP
    implements PDP {
        public void initialize(PDPConfig config, String name, String id) throws InitializeException {
        }

        public String[] getPolicyNames() {
            return null;
        }

        public Node getPolicy(Node query) throws InvalidPolicyException {
            return null;
        }

        public Node setPolicy(Node policy) throws InvalidPolicyException {
            try {
                return XmlUtils.newDocument().createElement("test");
            }
            catch (Exception e) {
                throw new InvalidPolicyException("", e);
            }
        }

        public boolean isPermitted(Subject peerSubject, MessageContext context, QName operation) throws AuthorizationException {
            return true;
        }

        public void close() throws CloseException {
        }
    }
}

