/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import javax.xml.rpc.Stub;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.impl.security.TestConstants;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.test.GSITestContainer;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.test.TestContainer;
import org.globus.wsrf.tests.security.CreateResourceResponse;
import org.globus.wsrf.tests.security.GsiSecConvDeleg;
import org.globus.wsrf.tests.security.GsiSecConvIntegrity;
import org.globus.wsrf.tests.security.NoAuthRequest;
import org.globus.wsrf.tests.security.SecurityTestPortType;
import org.globus.wsrf.tests.security.service.SecurityTestServiceAddressingLocator;

public class TestAuthorizationCallout
extends GridTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout = TestAuthorizationCallout.class$("org.globus.wsrf.impl.security.authorization.TestAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout).getName());
    Authorization authz = TestConstants.getConfiguredClientAuthz();
    private TestContainer testContainer;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout;

    public TestAuthorizationCallout(String name) {
        super(name);
        logger.debug((Object)("Authz is " + this.authz.getClass().getName()));
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout == null ? (class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout = TestAuthorizationCallout.class$("org.globus.wsrf.impl.security.authorization.TestAuthorizationCallout")) : class$org$globus$wsrf$impl$security$authorization$TestAuthorizationCallout);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestAuthorizationCallout.suite());
    }

    public void testSecureAccess() throws Exception {
        TestAuthorizationCallout.assertTrue((this.testContainer != null ? 1 : 0) != 0);
        String testServiceAddrs = this.testContainer.getBaseURL() + "AuthzCalloutTestService";
        logger.debug((Object)("Test " + testServiceAddrs));
        EndpointReferenceType testServiceEPR = new EndpointReferenceType(new URI(testServiceAddrs));
        SecurityTestServiceAddressingLocator locator1 = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort1 = locator1.getSecurityTestPortTypePort(testServiceEPR);
        String authzServiceUrl = this.testContainer.getBaseURL() + "TestAuthzService";
        ((Stub)testPort1)._setProperty("org.globus.security.authorization", (Object)this.authz);
        NoAuthRequest noAuthRequest = new NoAuthRequest();
        noAuthRequest.setAuthzService(authzServiceUrl);
        String authzServiceIdentity = System.getProperty("TEST_AUTHZ_SERVICE_IDENTITY");
        logger.debug((Object)("Authz service identity " + authzServiceIdentity));
        noAuthRequest.setAuthzServiceIdentity(authzServiceIdentity);
        testPort1.noAuth(noAuthRequest);
        this.serviceSecurityTest(testServiceEPR);
        testPort1.noAuth(noAuthRequest);
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testServiceEPR);
        this.setGSISecConv(testPort, true, true);
        CreateResourceResponse response = testPort.createResource(false);
        EndpointReferenceType res1EPR = response.getEndpointReference();
        this.serviceSecurityTest(res1EPR);
    }

    public void serviceSecurityTest(EndpointReferenceType testEPR) throws Exception {
        logger.debug((Object)"Sec Conv with integrity tests");
        SecurityTestServiceAddressingLocator locator1 = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator1.getSecurityTestPortTypePort(testEPR);
        this.setGSISecConv(testPort, true, false);
        logger.debug((Object)"GSI Sec Conv Integrity");
        boolean exceptionOccured = false;
        try {
            testPort.gsiSecConvIntegrity(new GsiSecConvIntegrity());
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("authorization") != -1) {
                exceptionOccured = true;
            }
            logger.error((Object)"Unexcepted error: ", (Throwable)e);
        }
        TestAuthorizationCallout.assertTrue((exceptionOccured ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Conv Delegation");
        boolean noExceptionOccured = true;
        try {
            testPort.gsiSecConvDeleg(new GsiSecConvDeleg());
        }
        catch (Exception e) {
            logger.error((Object)"Unexcepted error: ", (Throwable)e);
            noExceptionOccured = false;
        }
        TestAuthorizationCallout.assertTrue((noExceptionOccured ? 1 : 0) != 0);
        logger.debug((Object)"No auth");
        noExceptionOccured = true;
        NoAuthRequest noAuthRequest = new NoAuthRequest();
        noAuthRequest.setAuthzService(this.testContainer.getBaseURL() + "TestAuthzService");
        noAuthRequest.setAuthzServiceIdentity("/C=US/O=Globus Alliance/OU=Service/CN=host/foobar.com");
        try {
            testPort.noAuth(noAuthRequest);
        }
        catch (Exception e) {
            logger.error((Object)"Unexcepted error: ", (Throwable)e);
            noExceptionOccured = false;
        }
        TestAuthorizationCallout.assertTrue((noExceptionOccured ? 1 : 0) != 0);
        logger.debug((Object)"GSI Sec Conv Delegation - 2");
        exceptionOccured = false;
        try {
            testPort.gsiSecConvDeleg(new GsiSecConvDeleg());
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("Error accessing authorization service") != -1) {
                exceptionOccured = true;
            }
            logger.error((Object)"Unexcepted error: ", (Throwable)e);
        }
        TestAuthorizationCallout.assertTrue((exceptionOccured ? 1 : 0) != 0);
    }

    private void setGSISecConv(SecurityTestPortType testPort, boolean sig, boolean deleg) {
        if (sig) {
            ((Stub)testPort)._setProperty("org.globus.security.secConv.msg.type", (Object)GSIConstants.SIGNATURE);
        } else {
            ((Stub)testPort)._setProperty("org.globus.security.secConv.msg.type", (Object)GSIConstants.ENCRYPTION);
        }
        if (deleg) {
            ((Stub)testPort)._setProperty("org.globus.gsi.mode", (Object)"gsifull");
        } else {
            ((Stub)testPort)._setProperty("org.globus.gsi.mode", (Object)"gsi");
        }
        ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)this.authz);
    }

    protected void setUp() throws Exception {
        this.testContainer = new GSITestContainer();
        try {
            this.testContainer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        this.testContainer.stop();
        super.tearDown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

