/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import java.security.Key;
import java.security.PrivateKey;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignature;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.wsrf.impl.security.authentication.VerifyReplayFilter;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityEngine;
import org.globus.wsrf.providers.GSSPublicKey;
import org.ietf.jgss.GSSContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VerifyWSSecurity
extends WSSecurityEngine {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$VerifyWSSecurity == null ? (class$org$globus$wsrf$impl$security$authentication$VerifyWSSecurity = VerifyWSSecurity.class$("org.globus.wsrf.impl.security.authentication.VerifyWSSecurity")) : class$org$globus$wsrf$impl$security$authentication$VerifyWSSecurity).getName());
    private GSSContext context;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$VerifyWSSecurity;

    public VerifyWSSecurity(GSSContext context) {
        this.context = context;
    }

    public Document processSecurityHeader(SOAPEnvelope env, MessageContext msgCtx) throws Exception {
        logger.error((Object)"processes header");
        return this.processSecurityHeader(env, msgCtx, false);
    }

    public boolean verifyGssXMLSignature(XMLSignature sig, MessageContext msgContext) throws Exception {
        logger.debug((Object)"Enter: verifyGssXMLSignature");
        boolean result = sig.checkSignatureValue((Key)new GSSPublicKey(String.valueOf(this.context.hashCode()), this.context));
        logger.debug((Object)"Exit: verifyGssXMLSignature");
        return result;
    }

    public boolean verifyXMLSignature(XMLSignature sig, MessageContext msgCtx) throws Exception {
        ProxyPathValidator validator = new ProxyPathValidator();
        return this.verifyXMLSignature(sig, msgCtx, validator);
    }

    public void prepareEncryptionContext(String contextId, MessageContext msgContext) throws Exception {
        logger.debug((Object)"Enter: initContext");
        msgContext.setProperty("org.globus.security.secureconv.context", (Object)new SecurityContext(this.context, contextId));
    }

    protected QName getResourceKeyHeaderQName(MessageContext msgCtx) throws Exception {
        return null;
    }

    public boolean decryptXMLEncryption(Element element, MessageContext msgCtx) throws Exception {
        GlobusCredential credential = GlobusCredential.getDefaultCredential();
        PrivateKey privateKey = credential.getPrivateKey();
        return this.decryptXMLEncryption(element, privateKey);
    }

    public void processTimestampHeader(Element timestampElem, MessageContext msgCtx, SOAPHeaderElement messageIDHeader) throws Exception {
        if (messageIDHeader == null) {
            throw new Exception("MessageID Header is not present. Element is null");
        }
        logger.debug((Object)"Calling timestamp in verifyWS");
        if (timestampElem != null) {
            this.checkMessageValidity(timestampElem, messageIDHeader, null);
        } else if (this.rejectMsgSansTimestampHeader(msgCtx, null)) {
            throw new Exception("Timestamp is required");
        }
    }

    protected void checkMessageValidity(Element timestampElem, SOAPHeaderElement messageIDHeader, String replayAttackWindow) throws Exception {
        VerifyReplayFilter filter = new VerifyReplayFilter();
        this.checkMessageValidity(filter, timestampElem, messageIDHeader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

