/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import java.io.ByteArrayInputStream;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.wsrf.impl.security.authentication.VerifyWSSecurity;
import org.globus.wsrf.impl.security.authentication.encryption.GssEncryptedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.encryption.X509WSEncryptedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.signature.GssSignedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.signature.X509WSSignedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class TestWSSecurity
extends TestCase {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$security$authentication$TestWSSecurity == null ? (class$org$globus$wsrf$impl$security$authentication$TestWSSecurity = TestWSSecurity.class$("org.globus.wsrf.impl.security.authentication.TestWSSecurity")) : class$org$globus$wsrf$impl$security$authentication$TestWSSecurity).getName());
    SecurityContext clientContext;
    SecurityContext serverContext;
    org.apache.axis.MessageContext msgContext;
    static final String NS = "http://www.w3.org/2000/09/xmldsig#";
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\"><SOAP-ENV:Header> <wsa:To SOAP-ENV:mustUnderstand=\"0\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">http://140.221.57.28:8080/wsrf/services/SecureCounterService</wsa:To><wsa:Action  SOAP-ENV:mustUnderstand=\"0\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">http://counter.com/CounterPortType/addRequest</wsa:Action><wsa:From SOAP-ENV:mustUnderstand=\"0\"><Address xmlns=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\">http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous</Address></wsa:From><ns1:CounterKey SOAP-ENV:mustUnderstand=\"0\" xmlns:ns1=\"http://counter.com\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">4686652</ns1:CounterKey></SOAP-ENV:Header><SOAP-ENV:Body><add xmlns=\"http://samples.wsrf.globus.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    static final String soapMsgWithID = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\"><SOAP-ENV:Header> <wsa:MessageID wsu:Id=\"id-145910\" SOAP-ENV:mustUnderstand=\"0\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">uuid:6b4d3d80-2f7a-11d9-a445-9feae912fa6b</wsa:MessageID><wsa:To SOAP-ENV:mustUnderstand=\"0\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">http://140.221.57.28:8080/wsrf/services/SecureCounterService</wsa:To><wsa:Action  SOAP-ENV:mustUnderstand=\"0\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">http://counter.com/CounterPortType/addRequest</wsa:Action><wsa:From SOAP-ENV:mustUnderstand=\"0\"><Address xmlns=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\">http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous</Address></wsa:From><ns1:CounterKey SOAP-ENV:mustUnderstand=\"0\" xmlns:ns1=\"http://counter.com\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">4686652</ns1:CounterKey></SOAP-ENV:Header><SOAP-ENV:Body><add xmlns=\"http://samples.wsrf.globus.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    org.apache.axis.message.SOAPEnvelope unsignedEnvelope;
    org.apache.axis.message.SOAPEnvelope unsignedEnvelopeWithID;
    X509Certificate keyCert = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$security$authentication$TestWSSecurity;

    public TestWSSecurity(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$impl$security$authentication$TestWSSecurity == null ? (class$org$globus$wsrf$impl$security$authentication$TestWSSecurity = TestWSSecurity.class$("org.globus.wsrf.impl.security.authentication.TestWSSecurity")) : class$org$globus$wsrf$impl$security$authentication$TestWSSecurity);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecurity.suite());
    }

    protected void setUp() throws Exception {
        this.createContexts();
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new org.apache.axis.MessageContext((AxisEngine)tmpEngine);
        HashMap<QName, String> map = new HashMap<QName, String>();
        map.put(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "To"), "");
        map.put(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Action"), "");
        map.put(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "From"), "");
        map.put(new QName("http://counter.com", "CounterKey"), "");
        this.msgContext.setProperty("org.globus.security.secure.headers", map);
        this.msgContext.setProperty("org.globus.security.secure.headers.enforced", map);
        this.unsignedEnvelope = this.getSOAPEnvelope(soapMsg);
        this.unsignedEnvelopeWithID = this.getSOAPEnvelope(soapMsgWithID);
        GlobusCredential credential = GlobusCredential.getDefaultCredential();
        this.keyCert = credential.getCertificateChain()[0];
    }

    protected org.apache.axis.message.SOAPEnvelope getSOAPEnvelope(String soapmsg) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapmsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg.getSOAPEnvelope();
    }

    protected void createContexts() throws Exception {
        GSSManager manager = ExtendedGSSManager.getInstance();
        GSSContext context = manager.createContext((GSSCredential)null);
        String id = "" + context.hashCode();
        this.serverContext = new SecurityContext(context, id);
        context = manager.createContext(null, GSSConstants.MECH_OID, null, 0);
        this.clientContext = new SecurityContext(context, id);
        this.clientContext.getContext().requestConf(false);
        this.clientContext.getContext().requestCredDeleg(false);
    }

    protected void tearDown() throws Exception {
        if (this.clientContext != null) {
            this.clientContext.getContext().dispose();
        }
        if (this.serverContext != null) {
            this.serverContext.getContext().dispose();
        }
    }

    private void establishContext() throws Exception {
        TestWSSecurity.assertTrue((String)"client ctx already established.", (!this.clientContext.getContext().isEstablished() ? 1 : 0) != 0);
        TestWSSecurity.assertTrue((String)"server ctx already established.", (!this.serverContext.getContext().isEstablished() ? 1 : 0) != 0);
        byte[] inToken = new byte[]{};
        byte[] outToken = null;
        while (!this.clientContext.getContext().isEstablished()) {
            outToken = this.clientContext.getContext().initSecContext(inToken, 0, inToken.length);
            if (outToken == null) continue;
            inToken = this.serverContext.getContext().acceptSecContext(outToken, 0, outToken.length);
        }
        TestWSSecurity.assertTrue((String)"client ctx not established.", (boolean)this.clientContext.getContext().isEstablished());
        TestWSSecurity.assertTrue((String)"server ctx not established.", (boolean)this.serverContext.getContext().isEstablished());
    }

    public void testGssSignatue() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext.getContext());
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        this.verify(envelope, this.serverContext, false);
    }

    public void testGssEncryption() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelope);
        this.verify(envelope, this.serverContext, false);
    }

    public void testX509Signature() throws Exception {
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSSignedSOAPEnvelopeBuilder builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, null);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        this.verify(envelope, null, true);
    }

    public void testX509Encryption() throws Exception {
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(this.keyCert);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        this.verify(envelope, null, true);
    }

    public void testDoubleX509Encryption() throws Exception {
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(this.keyCert);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)envelope);
        this.verify(envelope, null, true);
    }

    public void testGssSignatureAndX509Encryption() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        GssSignedSOAPEnvelopeBuilder gssBuilder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext.getContext());
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(this.keyCert);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testX509EncryptionAndGssSignature() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(this.keyCert);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        GssSignedSOAPEnvelopeBuilder gssBuilder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext.getContext());
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testX509EncryptionAndGssEncryption() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(this.keyCert);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        GssEncryptedSOAPEnvelopeBuilder gssBuilder = new GssEncryptedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testGssEncryptionAndX509Encryption() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        GssEncryptedSOAPEnvelopeBuilder gssBuilder = new GssEncryptedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(this.keyCert);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testDoubleX509Signature() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSSignedSOAPEnvelopeBuilder builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, null);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        envelope = (org.apache.axis.message.SOAPEnvelope)builder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testGssSignatureAndX509Signature() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        GssSignedSOAPEnvelopeBuilder gssBuilder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext.getContext());
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        X509WSSignedSOAPEnvelopeBuilder x509Builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, null);
        envelope = (org.apache.axis.message.SOAPEnvelope)x509Builder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testX509SignatureAndGssSignature() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        org.apache.axis.MessageContext tmpCtx = new org.apache.axis.MessageContext((AxisEngine)tmpEngine);
        X509WSSignedSOAPEnvelopeBuilder x509Builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)tmpCtx, null);
        envelope = (org.apache.axis.message.SOAPEnvelope)x509Builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        GssSignedSOAPEnvelopeBuilder gssBuilder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext.getContext());
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)envelope);
        boolean exception = false;
        try {
            this.verify(envelope, this.serverContext, true);
        }
        catch (WSSecurityException exp) {
            if (exp.getMessage().indexOf("the headers used in dispatch") != -1) {
                exception = true;
            }
            logger.error((Object)exp);
        }
        TestWSSecurity.assertTrue((boolean)exception);
        x509Builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, null);
        envelope = (org.apache.axis.message.SOAPEnvelope)x509Builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        gssBuilder = new GssSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext.getContext());
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    public void testX509SignatureAndGssEncryption() throws Exception {
        this.establishContext();
        org.apache.axis.message.SOAPEnvelope envelope = null;
        X509WSSignedSOAPEnvelopeBuilder x509Builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)this.msgContext, null);
        envelope = (org.apache.axis.message.SOAPEnvelope)x509Builder.build((SOAPEnvelope)this.unsignedEnvelopeWithID);
        GssEncryptedSOAPEnvelopeBuilder gssBuilder = new GssEncryptedSOAPEnvelopeBuilder((MessageContext)this.msgContext, this.clientContext);
        envelope = (org.apache.axis.message.SOAPEnvelope)gssBuilder.build((SOAPEnvelope)envelope);
        this.verify(envelope, this.serverContext, true);
    }

    private void verify(org.apache.axis.message.SOAPEnvelope env, SecurityContext context, boolean timestamp) throws Exception {
        VerifyWSSecurity h = new VerifyWSSecurity(context == null ? null : context.getContext());
        this.msgContext.setProperty("org.globus.security.secureconv.context", (Object)context);
        h.processSecurityHeader((SOAPEnvelope)env, "", (MessageContext)this.msgContext, timestamp);
        this.msgContext.setProperty("org.globus.security.secureconv.context", null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GSSConfig.init();
    }
}

