/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security;

import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.wsrf.impl.security.authentication.encryption.EncryptionCredentials;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;

public class TestConstants {
    public static final String SECURITY_SERVICE_PATH = "SecurityTestService";
    public static final String CUSTOM_AUTHZ_SERVICE_PATH = "AuthzCalloutTestService";
    public static final String TEST_AUTHZ_SERVICE = "TestAuthzService";
    public static final String TEST_CLIENT_AUTHZ_PROP = "TEST_CLIENT_AUTHZ";
    public static final String TEST_CLIENT_ENCRYPTION_CRED = "TEST_CLIENT_ENCRYPTION_CRED";
    public static final String TEST_AUTHZ_SERVICE_IDENTITY = "TEST_AUTHZ_SERVICE_IDENTITY";

    public static Authorization getConfiguredClientAuthz() {
        Object authz = null;
        String authzStr = System.getProperty(TEST_CLIENT_AUTHZ_PROP);
        authz = authzStr != null && authzStr.equals("host") ? HostAuthorization.getInstance() : SelfAuthorization.getInstance();
        return authz;
    }

    public static org.globus.gsi.gssapi.auth.Authorization getConfiguredClientGSIAuthz() {
        Object authz = null;
        String authzStr = System.getProperty(TEST_CLIENT_AUTHZ_PROP);
        authz = authzStr != null && authzStr.equals("host") ? org.globus.gsi.gssapi.auth.HostAuthorization.getInstance() : org.globus.gsi.gssapi.auth.SelfAuthorization.getInstance();
        return authz;
    }

    public static Subject getPeerSubjectForClient(boolean self) throws Exception {
        X509Certificate serverCert = null;
        if (self) {
            GlobusCredential credential = GlobusCredential.getDefaultCredential();
            serverCert = credential.getCertificateChain()[0];
        } else {
            String encCredFile = System.getProperty(TEST_CLIENT_ENCRYPTION_CRED);
            if (encCredFile == null || encCredFile.equals("")) {
                throw new Exception("TEST_CLIENT_ENCRYPTION_CRED not set");
            }
            serverCert = CertUtil.loadCertificate((String)encCredFile);
        }
        EncryptionCredentials encryptionCreds = new EncryptionCredentials(new X509Certificate[]{serverCert});
        Subject subject = new Subject();
        subject.getPublicCredentials().add(encryptionCreds);
        return subject;
    }
}

