/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.util.Vector;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.impl.security.SecurityTestResource;
import org.globus.wsrf.impl.security.TestConstants;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.GSISecureConvAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.security.CreateResourceResponse;
import org.globus.wsrf.tests.security.SecurityTestPortType;
import org.globus.wsrf.tests.security.service.SecurityTestServiceAddressingLocator;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;

public class TestSecureNotifications
extends NotificationTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$notification$TestSecureNotifications == null ? (class$org$globus$wsrf$impl$notification$TestSecureNotifications = TestSecureNotifications.class$("org.globus.wsrf.impl.notification.TestSecureNotifications")) : class$org$globus$wsrf$impl$notification$TestSecureNotifications).getName());
    Authorization authz = TestConstants.getConfiguredClientAuthz();
    static /* synthetic */ Class class$org$globus$wsrf$impl$notification$TestSecureNotifications;

    public TestSecureNotifications(String name) {
        super(name);
    }

    public void testSubscribeSecMsg() throws Exception {
        EndpointReferenceType res1EPR = this.createResource();
        EndpointReferenceType subscribeEPR = this.subscribeTest(res1EPR, "org.globus.security.secMsg.msg.type", 10);
        super.destroySubscription(subscribeEPR, "org.globus.security.secMsg.msg.type");
    }

    public void testSubscribeSecConv() throws Exception {
        EndpointReferenceType res1EPR = this.createResource();
        EndpointReferenceType subscribeEPR = this.subscribeTest(res1EPR, "org.globus.security.secConv.msg.type", 20);
        super.destroySubscription(subscribeEPR, "org.globus.security.secConv.msg.type");
    }

    public void testSubscribeResourceSecurity() throws Exception {
        EndpointReferenceType res1EPR = this.createResource();
        EndpointReferenceType subscribeEPR = this.subscribeTest(res1EPR, "org.globus.security.secConv.msg.type", 20);
        String errorMessage = null;
        try {
            super.destroySubscription(subscribeEPR);
        }
        catch (Exception e) {
            logger.error((Object)"Exception ", (Throwable)e);
            errorMessage = e.getMessage();
        }
        TestSecureNotifications.assertEquals((String)"GSI Secure Message or GSI Secure Conversation authentication required for \"{http://wsrf.globus.org/core/notification}destroy\" operation.", errorMessage);
    }

    public void testNotificationSecConv() throws Exception {
        EndpointReferenceType res2EPR = this.createResource();
        this.multipleNotificationsTest(res2EPR, "org.globus.security.secConv.msg.type");
    }

    public void testNotificationSecMsg() throws Exception {
        EndpointReferenceType res2EPR = this.createResource();
        this.multipleNotificationsTest(res2EPR, "org.globus.security.secMsg.msg.type");
    }

    private EndpointReferenceType createResource() throws Exception {
        String testServiceAddrs = TEST_CONTAINER.getBaseURL() + "SecurityTestService";
        EndpointReferenceType testServiceEPR = new EndpointReferenceType(new URI(testServiceAddrs));
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testServiceEPR);
        CreateResourceResponse response = testPort.createResource(false);
        EndpointReferenceType res1EPR = response.getEndpointReference();
        logger.debug((Object)"Created a resource");
        return res1EPR;
    }

    private EndpointReferenceType subscribeTest(EndpointReferenceType res1EPR, String msgType, int setVal) throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        ResourceSecurityDescriptor resDesc = new ResourceSecurityDescriptor();
        resDesc.setAuthz("none");
        Vector<Object> authMethod = new Vector<Object>();
        if (msgType.equals("org.globus.security.secConv.msg.type")) {
            authMethod.add(GSISecureConvAuthMethod.BOTH);
        } else if (msgType.equals("org.globus.security.secMsg.msg.type")) {
            authMethod.add(GSISecureMsgAuthMethod.BOTH);
        }
        resDesc.setAuthMethods(authMethod, true);
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback, resDesc);
        logger.debug((Object)"Created notification consumer");
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicExpression = new TopicExpressionType();
        topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
        topicExpression.setValue((Object)SecurityTestResource.VALUE);
        request.setTopicExpression(topicExpression);
        logger.debug((Object)"Created subscribe request");
        SecurityTestServiceAddressingLocator resLocator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = resLocator.getSecurityTestPortTypePort(res1EPR);
        ((Stub)testPort)._setProperty(msgType, (Object)GSIConstants.SIGNATURE);
        ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)this.authz);
        SubscribeResponse response = testPort.subscribe(request);
        logger.debug((Object)"Subscribe called");
        testPort.setValue(setVal);
        TestSecureNotifications.assertTrue((boolean)callback.waitForCount(1, GridTestSuite.timeout));
        TestSecureNotifications.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
        Object message = callback.getMessage();
        ResourcePropertyValueChangeNotificationType changeMessage = ((ResourcePropertyValueChangeNotificationElementType)message).getResourcePropertyValueChangeNotification();
        TestSecureNotifications.assertTrue((changeMessage != null ? 1 : 0) != 0);
        String val = changeMessage.getNewValue().get_any()[0].getValue();
        logger.debug((Object)("Value is " + val));
        TestSecureNotifications.assertTrue((boolean)Integer.toString(setVal).equals(val));
        return response.getSubscriptionReference();
    }

    public void multipleNotificationsTest(EndpointReferenceType res1EPR, String msgType) throws Exception {
        System.out.println("Msg type " + msgType);
        TestNotifyCallback callback = new TestNotifyCallback();
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        ResourceSecurityDescriptor resDesc = new ResourceSecurityDescriptor();
        resDesc.setAuthz("none");
        ClientSecurityDescriptor desc = new ClientSecurityDescriptor();
        desc.setAuthz(this.authz);
        Vector<Object> authMethod = new Vector<Object>();
        if (msgType.equals("org.globus.security.secConv.msg.type")) {
            authMethod.add(GSISecureConvAuthMethod.BOTH);
            desc.setGSISecureConv(GSIConstants.SIGNATURE);
        } else if (msgType.equals("org.globus.security.secMsg.msg.type")) {
            authMethod.add(GSISecureMsgAuthMethod.BOTH);
            desc.setGSISecureMsg(GSIConstants.SIGNATURE);
        }
        resDesc.setAuthMethods(authMethod, true);
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback, resDesc);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicExpression = new TopicExpressionType();
        topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
        topicExpression.setValue((Object)SecurityTestResource.VALUE);
        request.setTopicExpression(topicExpression);
        SecurityTestServiceAddressingLocator resLocator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = resLocator.getSecurityTestPortTypePort(res1EPR);
        ((Stub)testPort)._setProperty(msgType, (Object)GSIConstants.SIGNATURE);
        ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)this.authz);
        SubscribeResponse response = testPort.subscribe(request);
        int numClients = 2;
        int numIters = 3;
        Sem sem = new Sem(numClients);
        for (int i = 0; i < numClients; ++i) {
            NotificationTestClient client = new NotificationTestClient(res1EPR, sem, numIters, msgType);
            client.start();
        }
        Exception ex = null;
        ex = sem.waitFor(GridTestSuite.timeout);
        if (ex != null) {
            throw ex;
        }
        TestSecureNotifications.assertTrue((boolean)callback.waitForCount(numClients * numIters, GridTestSuite.timeout));
        Thread.sleep(5000L);
        super.destroySubscription(response.getSubscriptionReference(), desc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Sem {
        int clients;
        int totalClients;
        Exception exception;

        public Sem(int totalClients) {
            this.totalClients = totalClients;
            this.clients = 0;
        }

        public synchronized Exception waitFor(int timeout) throws Exception {
            while (this.totalClients != this.clients) {
                int old = this.clients;
                this.wait(timeout);
                if (old != this.clients) continue;
                throw new Exception("Timeout. Received " + this.clients + "/" + this.totalClients + " signals.");
            }
            return this.exception;
        }

        public synchronized void signal(Exception e) {
            if (this.exception == null) {
                this.exception = e;
            }
            ++this.clients;
            this.notify();
        }
    }

    public class NotificationTestClient
    extends Thread {
        EndpointReferenceType epr;
        Sem sem;
        int numOfCalls;
        String msgSecType;

        public NotificationTestClient(EndpointReferenceType epr, Sem sem, int numOfCalls, String msgSecType) {
            this.epr = epr;
            this.sem = sem;
            this.numOfCalls = numOfCalls;
            this.msgSecType = msgSecType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Exception exception = null;
            try {
                SecurityTestServiceAddressingLocator resLocator = new SecurityTestServiceAddressingLocator();
                SecurityTestPortType testPort = resLocator.getSecurityTestPortTypePort(this.epr);
                ((Stub)testPort)._setProperty(this.msgSecType, (Object)GSIConstants.SIGNATURE);
                ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)TestSecureNotifications.this.authz);
                for (int i = 0; i < this.numOfCalls; ++i) {
                    testPort.setValue(i);
                }
            }
            catch (Exception e) {
                exception = e;
                e.printStackTrace();
            }
            finally {
                this.sem.signal(exception);
            }
        }
    }
}

