/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.WSNConstants;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.core.notification.service.SubscriptionManagerServiceAddressingLocator;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.utils.AddressingUtils;
import org.oasis.wsn.PauseSubscription;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.ResumeSubscription;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.QueryExpressionType;

public class SubscriptionManagerTests
extends NotificationTestCase {
    private SubscriptionManagerServiceAddressingLocator managerLocator = new SubscriptionManagerServiceAddressingLocator();
    private EndpointReferenceType consumerEPR = null;
    private TestNotifyCallback callback = null;
    private SubscriptionManager manager = null;
    private SubscriptionManager badManager = null;

    public SubscriptionManagerTests(String name) {
        super(name);
    }

    public void testPauseResume() throws Exception {
        int expectedCount = this.callback.getNotifyCount() + 1;
        this.manager.pauseSubscription(new PauseSubscription());
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        this.manager.resumeSubscription(new ResumeSubscription());
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        SubscriptionManagerTests.assertTrue((boolean)this.callback.waitForCount(expectedCount, GridTestSuite.timeout));
        SubscriptionManagerTests.assertEquals((int)expectedCount, (int)this.callback.getNotifyCount());
    }

    public void testPauseResourceUnknown() throws Exception {
        ResourceUnknownFaultType fault = null;
        try {
            this.badManager.pauseSubscription(new PauseSubscription());
        }
        catch (ResourceUnknownFaultType e) {
            fault = e;
        }
        SubscriptionManagerTests.assertTrue((fault != null ? 1 : 0) != 0);
    }

    public void testResumeResourceUnknown() throws Exception {
        ResourceUnknownFaultType fault = null;
        try {
            this.badManager.resumeSubscription(new ResumeSubscription());
        }
        catch (ResourceUnknownFaultType e) {
            fault = e;
        }
        SubscriptionManagerTests.assertTrue((fault != null ? 1 : 0) != 0);
    }

    public void testDestroySubscription() throws Exception {
        ResourceUnknownFaultType fault = null;
        int expectedCount = 0;
        TestNotifyCallback callback = new TestNotifyCallback();
        EndpointReferenceType managerEPR = this.subscribe(callback);
        SubscriptionManager manager = this.managerLocator.getSubscriptionManagerPort(managerEPR);
        manager.destroy(new Destroy());
        try {
            manager.pauseSubscription(new PauseSubscription());
        }
        catch (ResourceUnknownFaultType e) {
            fault = e;
        }
        SubscriptionManagerTests.assertTrue((fault != null ? 1 : 0) != 0);
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        Thread.sleep(15000L);
        SubscriptionManagerTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
    }

    public void testTerminateSubscription() throws Exception {
        ResourceUnknownFaultType fault = null;
        int expectedCount = 0;
        TestNotifyCallback callback = new TestNotifyCallback();
        EndpointReferenceType managerEPR = this.subscribe(callback);
        SubscriptionManager manager = this.managerLocator.getSubscriptionManagerPort(managerEPR);
        SetTerminationTime terminationTimeRequest = new SetTerminationTime();
        Calendar terminationTime = Calendar.getInstance();
        terminationTime.add(13, 5);
        terminationTimeRequest.setRequestedTerminationTime(terminationTime);
        manager.setTerminationTime(terminationTimeRequest);
        for (int wait = 0; wait < GridTestSuite.timeout; wait += 45000) {
            try {
                manager.resumeSubscription(new ResumeSubscription());
                Thread.sleep(45000L);
                continue;
            }
            catch (ResourceUnknownFaultType e) {
                fault = e;
                break;
            }
        }
        SubscriptionManagerTests.assertTrue((String)"timeout or exception not generated", (fault != null ? 1 : 0) != 0);
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        Thread.sleep(15000L);
        SubscriptionManagerTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
    }

    public void testSubscriptionTimeRPs() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSRFConstants.TERMINATION_TIME);
        MessageElement[] timeElements = response.get_any();
        SubscriptionManagerTests.assertTrue((timeElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)timeElements[0].getQName(), (Object)WSRFConstants.TERMINATION_TIME);
        Calendar terminationTime = (Calendar)timeElements[0].getValueAsType(Constants.XSD_DATETIME);
        response = this.manager.getResourceProperty(WSNConstants.CREATION_TIME);
        timeElements = response.get_any();
        SubscriptionManagerTests.assertTrue((timeElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)timeElements[0].getQName(), (Object)WSNConstants.CREATION_TIME);
        Calendar creationTime = (Calendar)timeElements[0].getValueAsType(Constants.XSD_DATETIME);
        SubscriptionManagerTests.assertTrue((boolean)terminationTime.after(creationTime));
        response = this.manager.getResourceProperty(WSRFConstants.CURRENT_TIME);
        timeElements = response.get_any();
        SubscriptionManagerTests.assertTrue((timeElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)timeElements[0].getQName(), (Object)WSRFConstants.CURRENT_TIME);
        Calendar currentTime = (Calendar)timeElements[0].getValueAsType(Constants.XSD_DATETIME);
        SubscriptionManagerTests.assertTrue((boolean)terminationTime.after(currentTime));
    }

    public void testConsumerReferenceRP() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSNConstants.CONSUMER_REFERENCE);
        MessageElement[] responseElements = response.get_any();
        SubscriptionManagerTests.assertTrue((responseElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)responseElements[0].getQName(), (Object)WSNConstants.CONSUMER_REFERENCE);
        EndpointReferenceType consumerReference = (EndpointReferenceType)responseElements[0].getValueAsType(EndpointReferenceType.getTypeDesc().getXmlType());
        SubscriptionManagerTests.assertEquals((String)consumerReference.getAddress().toString(), (String)this.consumerEPR.getAddress().toString());
        MessageElement[] rpReferenceProps = consumerReference.getProperties().get_any();
        MessageElement[] referenceProps = this.consumerEPR.getProperties().get_any();
        SubscriptionManagerTests.assertEquals((int)rpReferenceProps.length, (int)referenceProps.length);
        SubscriptionManagerTests.assertEquals((Object)rpReferenceProps[0].getQName(), (Object)referenceProps[0].getQName());
        SubscriptionManagerTests.assertEquals((String)rpReferenceProps[0].getValue(), (String)referenceProps[0].getValue());
    }

    public void testTopicExpressionRP() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSNConstants.TOPIC_EXPRESSION);
        MessageElement[] responseElements = response.get_any();
        SubscriptionManagerTests.assertTrue((responseElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)responseElements[0].getQName(), (Object)WSNConstants.TOPIC_EXPRESSION);
        TopicExpressionType topic = (TopicExpressionType)responseElements[0].getValueAsType(TopicExpressionType.getTypeDesc().getXmlType());
        SubscriptionManagerTests.assertEquals((String)"http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (String)topic.getDialect().toString());
        SubscriptionManagerTests.assertEquals((Object)NotificationTestService.TEST_TOPIC, (Object)topic.getValue());
    }

    public void testUseNotifyRP() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSNConstants.USE_NOTIFY);
        MessageElement[] responseElements = response.get_any();
        SubscriptionManagerTests.assertTrue((responseElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)responseElements[0].getQName(), (Object)WSNConstants.USE_NOTIFY);
        SubscriptionManagerTests.assertEquals((Object)((Boolean)responseElements[0].getValueAsType(Constants.XSD_BOOLEAN)), (Object)Boolean.TRUE);
    }

    public void testPreConditionRP() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSNConstants.PRECONDITION);
        MessageElement[] responseElements = response.get_any();
        SubscriptionManagerTests.assertTrue((responseElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)responseElements[0].getQName(), (Object)WSNConstants.PRECONDITION);
        QueryExpressionType query = (QueryExpressionType)responseElements[0].getValueAsType(QueryExpressionType.getTypeDesc().getXmlType());
        SubscriptionManagerTests.assertEquals((String)"http://www.w3.org/TR/1999/REC-xpath-19991116", (String)query.getDialect().toString());
        SubscriptionManagerTests.assertEquals((Object)"/foo", (Object)query.getValue());
    }

    public void testSelectorRP() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSNConstants.SELECTOR);
        MessageElement[] responseElements = response.get_any();
        SubscriptionManagerTests.assertTrue((responseElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)responseElements[0].getQName(), (Object)WSNConstants.SELECTOR);
        QueryExpressionType query = (QueryExpressionType)responseElements[0].getValueAsType(QueryExpressionType.getTypeDesc().getXmlType());
        SubscriptionManagerTests.assertEquals((String)"http://www.w3.org/TR/1999/REC-xpath-19991116", (String)query.getDialect().toString());
        SubscriptionManagerTests.assertEquals((Object)"/foo", (Object)query.getValue());
    }

    public void testPolicyRP() throws Exception {
        GetResourcePropertyResponse response = this.manager.getResourceProperty(WSNConstants.SUBSCRIPTION_POLICY);
        MessageElement[] responseElements = response.get_any();
        SubscriptionManagerTests.assertTrue((responseElements.length == 1 ? 1 : 0) != 0);
        SubscriptionManagerTests.assertEquals((Object)responseElements[0].getQName(), (Object)WSNConstants.SUBSCRIPTION_POLICY);
        SubscriptionManagerTests.assertEquals((String)"foo", (String)responseElements[0].getValue());
    }

    private EndpointReferenceType subscribe(TestNotifyCallback callback) throws Exception {
        if (callback == null) {
            if (this.callback == null) {
                this.callback = new TestNotifyCallback();
            }
            callback = this.callback;
        }
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        this.consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(this.consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        Calendar terminationTime = Calendar.getInstance();
        terminationTime.add(13, 200);
        request.setInitialTerminationTime(terminationTime);
        request.setSubscriptionPolicy((Object)"foo");
        QueryExpressionType query = new QueryExpressionType();
        query.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        query.setValue((Object)"/foo");
        request.setPrecondition(query);
        request.setSelector(query);
        SubscribeResponse response = this.port.subscribe(request);
        return response.getSubscriptionReference();
    }

    protected void setUp() throws Exception {
        super.setUp();
        EndpointReferenceType managerEPR = this.subscribe(null);
        this.manager = this.managerLocator.getSubscriptionManagerPort(managerEPR);
        EndpointReferenceType badManagerEPR = AddressingUtils.createEndpointReference((String)managerEPR.getAddress().toString(), (ResourceKey)new SimpleResourceKey(new QName("http://www.globus.org/namespaces/2004/06/core", "SubscriptionKey"), (Object)"1"));
        this.badManager = this.managerLocator.getSubscriptionManagerPort(badManagerEPR);
    }

    protected void tearDown() throws Exception {
        this.manager.destroy(new Destroy());
        super.tearDown();
    }
}

