/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.NotifyThread;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.test.GridTestSuite;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;

public class NotificationTests
extends NotificationTestCase {
    public NotificationTests(String name) {
        super(name);
    }

    public void testMultipleNotifications() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse response = this.port.subscribe(request);
        for (int i = 0; i < 10; ++i) {
            this.port.generateNotification(NotificationTestService.TEST_TOPIC);
            NotificationTests.assertTrue((String)("timed out waiting for notification #" + expectedCount), (boolean)callback.waitForCount(expectedCount, GridTestSuite.timeout));
            NotificationTests.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
            ++expectedCount;
        }
        SubscriptionManager manager = this.managerLocator.getSubscriptionManagerPort(response.getSubscriptionReference());
        manager.destroy(new Destroy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultithreadedNotifications() throws Throwable {
        int i;
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        Object lock = new Object();
        int size = 10;
        NotifyThread[] threads = new NotifyThread[size];
        for (i = 0; i < size; ++i) {
            threads[i] = new NotifyThread(this.testServiceEPR, consumer, lock, null);
            threads[i].start();
        }
        for (i = 0; i < size; ++i) {
            while (!threads[i].isSubscribed()) {
                Throwable e = threads[i].getException();
                if (e != null) {
                    throw e;
                }
                Thread.sleep(100L);
            }
        }
        Object i2 = lock;
        synchronized (i2) {
            lock.notifyAll();
        }
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        Throwable e = null;
        for (int i3 = 0; i3 < size; ++i3) {
            threads[i3].join();
            if (threads[i3].getException() == null) continue;
            threads[i3].getException().printStackTrace();
            if (e != null) continue;
            e = threads[i3].getException();
        }
        if (e != null) {
            throw e;
        }
    }
}

