/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistentResource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.TopicListMetaData;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.ResourcePropertyTopic;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.impl.SimpleTopicList;
import org.globus.wsrf.impl.SimpleTopicListMetaData;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.tests.notification.JobStatusType;
import org.globus.wsrf.utils.FilePersistenceHelper;
import org.globus.wsrf.utils.SubscriptionPersistenceUtils;
import org.oasis.wsrf.faults.BaseFaultType;

public class NotificationTestResource
implements ResourceProperties,
TopicListAccessor,
PersistentResource {
    private TopicList topicList;
    private ResourcePropertySet propSet = new SimpleResourcePropertySet(NotificationTestService.RP_SET);
    private JobStatusType jobStatus = new JobStatusType();
    private Topic jobStatusTopic = null;
    private FilePersistenceHelper persistenceHelper;
    private Integer id = null;
    private static final String FILE_SUFFIX = ".obj";

    protected Topic getJobStatusTopic() {
        return this.jobStatusTopic;
    }

    public NotificationTestResource() throws RemoteException {
        this.jobStatus.setJobState("Active");
        BaseFaultType fault = new BaseFaultType();
        fault.setTimestamp(Calendar.getInstance());
        this.jobStatus.setFault((Object)fault);
        try {
            this.jobStatusTopic = new ResourcePropertyTopic((ResourceProperty)new ReflectionResourceProperty(NotificationTestService.JOB_STATUS_TOPIC_RP, "JobStatus", (Object)this));
            this.propSet.add((ResourceProperty)new ResourcePropertyTopic((ResourceProperty)new SimpleResourceProperty(NotificationTestService.AUTO_NOTIFY_TOPIC_RP)));
            this.propSet.add((ResourceProperty)new ResourcePropertyTopic((ResourceProperty)new ReflectionResourceProperty(NotificationTestService.SEND_OLD_TOPIC_RP, "SendOldValue", (Object)this.propSet.get(NotificationTestService.AUTO_NOTIFY_TOPIC_RP))));
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
        ((ResourcePropertyTopic)this.jobStatusTopic).setAutoNotify(false);
        this.propSet.add((ResourceProperty)this.jobStatusTopic);
        SimpleTopicListMetaData metaData = new SimpleTopicListMetaData(true);
        this.topicList = new SimpleTopicList((ResourceProperties)this, (TopicListMetaData)metaData);
        this.topicList.addTopic((Topic)new SimpleTopic(NotificationTestService.TEST_TOPIC));
        this.topicList.addTopic((Topic)new SimpleTopic(NotificationTestService.EMPTY_TOPIC));
        this.topicList.addTopic((Topic)new SimpleTopic(NotificationTestService.THIRD_TOPIC));
        this.topicList.addTopic((Topic)new SimpleTopic(NotificationTestService.FOURTH_TOPIC));
        this.topicList.addTopic(this.jobStatusTopic);
        this.topicList.addTopic((Topic)this.propSet.get(NotificationTestService.AUTO_NOTIFY_TOPIC_RP));
        this.topicList.addTopic((Topic)this.propSet.get(NotificationTestService.SEND_OLD_TOPIC_RP));
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public TopicList getTopicList() {
        return this.topicList;
    }

    public JobStatusType getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatusType jobStatus) {
        this.jobStatus = jobStatus;
        try {
            this.store();
        }
        catch (ResourceException e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
        this.id = (Integer)key.getValue();
        File file = this.getPersistenceHelper().getKeyAsFile((Object)this.id);
        if (!file.exists()) {
            throw new NoSuchResourceException();
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.jobStatus = (JobStatusType)ois.readObject();
                SubscriptionPersistenceUtils.loadSubscriptionListeners((TopicList)this.getTopicList(), (ObjectInputStream)ois);
            }
            catch (Exception e) {
                throw new ResourceException("Failed to load resource", (Throwable)e);
            }
            Object var6_6 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ee) {}
        fis.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store() throws ResourceException {
        File file;
        File tmpFile;
        block8: {
            FileOutputStream fos = null;
            tmpFile = null;
            try {
                try {
                    tmpFile = File.createTempFile("notificationTestResource", ".tmp", this.getPersistenceHelper().getStorageDirectory());
                    fos = new FileOutputStream(tmpFile);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.jobStatus);
                    SubscriptionPersistenceUtils.storeSubscriptionListeners((TopicList)this.getTopicList(), (ObjectOutputStream)oos);
                }
                catch (Exception e) {
                    tmpFile.delete();
                    throw new ResourceException("Failed to store resource", (Throwable)e);
                }
                Object var5_5 = null;
                if (fos == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            fos.close();
        }
        if ((file = this.getPersistenceHelper().getKeyAsFile((Object)this.id)).exists()) {
            file.delete();
        }
        if (tmpFile.renameTo(file)) return;
        tmpFile.delete();
        throw new ResourceException("Failed to store resource");
    }

    public Object getID() {
        return this.id;
    }

    protected void setID(Integer id) {
        this.id = id;
    }

    public void remove() throws ResourceException {
        this.getPersistenceHelper().remove((Object)this.id);
    }

    protected synchronized FilePersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new FilePersistenceHelper(this.getClass(), FILE_SUFFIX);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }
}

