/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.notification.NotificationTestPortType;
import org.globus.wsrf.tests.notification.SelfSubscribeRequest;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.w3c.dom.Element;

public class NotificationConsumerTests
extends NotificationTestCase {
    public NotificationConsumerTests(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerNotificationConsumerManager() throws Exception {
        TestThread t = new TestThread(this.port);
        t.start();
        SelfSubscribeRequest request = new SelfSubscribeRequest();
        try {
            this.port.selfSubscribe(request);
        }
        finally {
            t.kill();
        }
    }

    public void testAllCallback() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse subscribeResponse1 = this.port.subscribe(request);
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        NotificationConsumerTests.assertTrue((boolean)callback.waitForCount(1, GridTestSuite.timeout));
        NotificationConsumerTests.assertEquals((int)1, (int)callback.getNotifyCount());
        NotificationConsumerTests.assertEquals((Object)NotificationTestService.TEST_TOPIC, (Object)callback.getNotificationTopic());
        NotificationConsumerTests.assertEquals((Object)new QName("http://wsrf.globus.org/tests/notification", "TestNotification"), (Object)new QName(((Element)callback.getMessage()).getNamespaceURI(), ((Element)callback.getMessage()).getLocalName()));
        topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.THIRD_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse subscribeResponse2 = this.port.subscribe(request);
        this.port.generateNotification(NotificationTestService.THIRD_TOPIC);
        NotificationConsumerTests.assertTrue((boolean)callback.waitForCount(2, GridTestSuite.timeout));
        NotificationConsumerTests.assertEquals((int)2, (int)callback.getNotifyCount());
        NotificationConsumerTests.assertEquals((Object)NotificationTestService.THIRD_TOPIC, (Object)callback.getNotificationTopic());
        NotificationConsumerTests.assertEquals((Object)new QName("http://wsrf.globus.org/tests/notification", "TestNotification"), (Object)new QName(((Element)callback.getMessage()).getNamespaceURI(), ((Element)callback.getMessage()).getLocalName()));
        super.destroySubscription(subscribeResponse1.getSubscriptionReference());
        super.destroySubscription(subscribeResponse2.getSubscriptionReference());
    }

    public void testTopicCallback() throws Exception {
        TestNotifyCallback testCallback = new TestNotifyCallback();
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance();
        consumer.startListening();
        LinkedList<QName> testTopicPath = new LinkedList<QName>();
        testTopicPath.add(NotificationTestService.TEST_TOPIC);
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer(testTopicPath, (NotifyCallback)testCallback);
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse subscribeResponse1 = this.port.subscribe(request);
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        NotificationConsumerTests.assertTrue((boolean)testCallback.waitForCount(1, GridTestSuite.timeout));
        NotificationConsumerTests.assertEquals((int)1, (int)testCallback.getNotifyCount());
        NotificationConsumerTests.assertEquals((Object)NotificationTestService.TEST_TOPIC, (Object)testCallback.getNotificationTopic());
        NotificationConsumerTests.assertEquals((Object)new QName("http://wsrf.globus.org/tests/notification", "TestNotification"), (Object)new QName(((Element)testCallback.getMessage()).getNamespaceURI(), ((Element)testCallback.getMessage()).getLocalName()));
        LinkedList<QName> thirdTopicPath = new LinkedList<QName>();
        thirdTopicPath.add(NotificationTestService.THIRD_TOPIC);
        TestNotifyCallback thirdCallback = new TestNotifyCallback();
        consumerEPR = consumer.createNotificationConsumer(thirdTopicPath, (NotifyCallback)thirdCallback);
        request.setConsumerReference(consumerEPR);
        topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.THIRD_TOPIC);
        request.setTopicExpression(topicPath);
        SubscribeResponse subscribeResponse2 = this.port.subscribe(request);
        this.port.generateNotification(NotificationTestService.THIRD_TOPIC);
        NotificationConsumerTests.assertTrue((boolean)thirdCallback.waitForCount(1, GridTestSuite.timeout));
        NotificationConsumerTests.assertEquals((int)1, (int)thirdCallback.getNotifyCount());
        NotificationConsumerTests.assertEquals((Object)NotificationTestService.THIRD_TOPIC, (Object)thirdCallback.getNotificationTopic());
        NotificationConsumerTests.assertEquals((Object)new QName("http://wsrf.globus.org/tests/notification", "TestNotification"), (Object)new QName(((Element)thirdCallback.getMessage()).getNamespaceURI(), ((Element)thirdCallback.getMessage()).getLocalName()));
        super.destroySubscription(subscribeResponse1.getSubscriptionReference());
        super.destroySubscription(subscribeResponse2.getSubscriptionReference());
    }

    class TestThread
    extends Thread {
        private NotificationTestPortType port;
        private boolean stop = false;

        public TestThread(NotificationTestPortType port) {
            this.port = port;
        }

        public void kill() {
            this.stop = true;
        }

        public void run() {
            try {
                while (!this.stop) {
                    Thread.sleep(10000L);
                    this.port.generateNotification(NotificationTestService.FOURTH_TOPIC);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

