/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.lifetime;

import java.util.Calendar;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.TestHome;
import org.globus.wsrf.impl.lifetime.LifetimeTestCase;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.basic.TestPortType;
import org.oasis.wsrf.lifetime.ResourceUnknownFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class SetTerminationTimeTests
extends LifetimeTestCase {
    static /* synthetic */ Class class$java$util$Calendar;

    public SetTerminationTimeTests(String name) {
        super(name);
    }

    public void testUnknownResource() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.createEPR(TestHome.BAD_KEY));
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        try {
            SetTerminationTimeResponse response = port.setTerminationTime(request);
            SetTerminationTimeTests.fail((String)"Did not throw exception");
        }
        catch (ResourceUnknownFaultType e) {
            // empty catch block
        }
    }

    public void testTimeInPast() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, -30);
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        SetTerminationTimeResponse response = port.setTerminationTime(request);
        Calendar newTermTime = response.getNewTerminationTime();
        Calendar currentTime = response.getCurrentTime();
        SetTerminationTimeTests.assertTrue((newTermTime != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((currentTime != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((boolean)newTermTime.getTime().equals(currentTime.getTime()));
        try {
            port.setTerminationTime(request);
            SetTerminationTimeTests.fail((String)"Did not throw exception");
        }
        catch (ResourceUnknownFaultType e) {
            // empty catch block
        }
    }

    public void testTimeInFuture() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        SetTerminationTimeResponse response = port.setTerminationTime(request);
        Calendar newTermTime = response.getNewTerminationTime();
        Calendar currentTime = response.getCurrentTime();
        SetTerminationTimeTests.assertTrue((newTermTime != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((currentTime != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((boolean)newTermTime.getTime().equals(termTime.getTime()));
        org.oasis.wsrf.properties.ResourceUnknownFaultType fault = null;
        for (int wait = 0; wait < GridTestSuite.timeout; wait += 45000) {
            try {
                SetTerminationTimeTests.assertEquals((Object)newTermTime.getTime(), (Object)this.getTerminationTimeRP(port).getTime());
                Thread.sleep(45000L);
                continue;
            }
            catch (org.oasis.wsrf.properties.ResourceUnknownFaultType e) {
                fault = e;
                break;
            }
        }
        SetTerminationTimeTests.assertTrue((String)"timeout or exception not generated", (fault != null ? 1 : 0) != 0);
    }

    private Calendar getTerminationTimeRP(TestPortType port) throws Exception {
        GetResourcePropertyResponse propResponse = port.getResourceProperty(WSRFConstants.TERMINATION_TIME);
        MessageElement[] any = propResponse.get_any();
        SetTerminationTimeTests.assertTrue((any != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((any.length > 0 ? 1 : 0) != 0);
        Object obj = ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$java$util$Calendar == null ? (class$java$util$Calendar = SetTerminationTimeTests.class$("java.util.Calendar")) : class$java$util$Calendar));
        SetTerminationTimeTests.assertTrue((boolean)(obj instanceof Calendar));
        return (Calendar)obj;
    }

    public void testChangeTime() throws Exception {
        TestPortType port = this.locator.getTestPortTypePort(this.getServiceAddress());
        port = this.locator.getTestPortTypePort(this.createResource(port));
        Calendar termTime = Calendar.getInstance();
        termTime.add(13, 30);
        SetTerminationTime request = null;
        SetTerminationTimeResponse response = null;
        request = new SetTerminationTime();
        request.setRequestedTerminationTime(termTime);
        response = port.setTerminationTime(request);
        Calendar newTermTime = null;
        Calendar currentTime = null;
        newTermTime = response.getNewTerminationTime();
        currentTime = response.getCurrentTime();
        SetTerminationTimeTests.assertTrue((newTermTime != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((currentTime != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((boolean)newTermTime.getTime().equals(termTime.getTime()));
        SetTerminationTimeTests.assertEquals((Object)termTime.getTime(), (Object)this.getTerminationTimeRP(port).getTime());
        request = new SetTerminationTime();
        response = port.setTerminationTime(request);
        newTermTime = response.getNewTerminationTime();
        currentTime = response.getCurrentTime();
        SetTerminationTimeTests.assertTrue((newTermTime == null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((currentTime != null ? 1 : 0) != 0);
        GetResourcePropertyResponse propResponse = port.getResourceProperty(WSRFConstants.TERMINATION_TIME);
        MessageElement[] any = propResponse.get_any();
        SetTerminationTimeTests.assertTrue((any != null ? 1 : 0) != 0);
        SetTerminationTimeTests.assertTrue((any.length > 0 ? 1 : 0) != 0);
        SetTerminationTimeTests.assertEquals((Object)WSRFConstants.TERMINATION_TIME, (Object)any[0].getQName());
        SetTerminationTimeTests.assertEquals((String)"true", (String)any[0].getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

