/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import junit.framework.TestCase;
import org.apache.axis.Constants;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.w3c.dom.Element;

public class ReflectionResourcePropertyTest
extends TestCase {
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public void testPrimitivesIntArray() throws Exception {
        JavaPrimitivesTestClass t = new JavaPrimitivesTestClass();
        QName propName = new QName("http:/foo", "IntArray");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(propName, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)t.getIntArray());
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        Integer testValue1 = new Integer(2);
        Integer testValue2 = new Integer(3);
        Integer testValue3 = new Integer(4);
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)t.getIntArray().length);
        ReflectionResourcePropertyTest.assertEquals((int)testValue1, (int)t.getIntArray()[0]);
        ReflectionResourcePropertyTest.assertEquals((int)testValue2, (int)t.getIntArray()[1]);
        ReflectionResourcePropertyTest.assertEquals((int)testValue3, (int)t.getIntArray()[2]);
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, (Object)prop.get(0));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)prop.get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(2));
        Integer testValue4 = new Integer(5);
        prop.set(1, (Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((int)testValue4, (int)t.getIntArray()[1]);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue4, (Object)prop.get(1));
        prop.remove((Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((int)2, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((int)testValue3, (int)t.getIntArray()[1]);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(1));
        prop.remove((Object)testValue1);
        prop.remove((Object)testValue3);
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
    }

    public void testPrimitivesByteArray() throws Exception {
        JavaPrimitivesTestClass t = new JavaPrimitivesTestClass();
        QName propName = new QName("http:/foo", "ByteArray");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(propName, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)t.getByteArray());
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        Byte testValue1 = new Byte(2);
        Byte testValue2 = new Byte(3);
        Byte testValue3 = new Byte(4);
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)t.getByteArray().length);
        ReflectionResourcePropertyTest.assertEquals((byte)testValue1, (byte)t.getByteArray()[0]);
        ReflectionResourcePropertyTest.assertEquals((byte)testValue2, (byte)t.getByteArray()[1]);
        ReflectionResourcePropertyTest.assertEquals((byte)testValue3, (byte)t.getByteArray()[2]);
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, (Object)prop.get(0));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)prop.get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(2));
        Byte testValue4 = new Byte(5);
        prop.set(1, (Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((byte)testValue4, (byte)t.getByteArray()[1]);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue4, (Object)prop.get(1));
        prop.remove((Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((int)2, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((byte)testValue3, (byte)t.getByteArray()[1]);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(1));
        prop.remove((Object)testValue1);
        prop.remove((Object)testValue3);
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
    }

    public void testPrimitivesByteArray64() throws Exception {
        JavaPrimitivesTestClass t = new JavaPrimitivesTestClass();
        QName propName = new QName("http:/foo", "ByteArray64");
        SimpleResourcePropertyMetaData metaData = new SimpleResourcePropertyMetaData(propName, 0, 1, false, array$B == null ? (array$B = ReflectionResourcePropertyTest.class$("[B")) : array$B, false, Constants.XSD_BASE64);
        ReflectionResourceProperty prop = new ReflectionResourceProperty((ResourcePropertyMetaData)metaData, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)t.getByteArray64());
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        byte[] testValue1 = new byte[]{49, 50};
        prop.add((Object)testValue1);
        ReflectionResourcePropertyTest.assertEquals((int)testValue1.length, (int)t.getByteArray64().length);
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue1, t.getByteArray64()));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue1, (byte[])prop.get(0)));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        byte[] testValue2 = new byte[]{49, 50, 51};
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)testValue2.length, (int)t.getByteArray64().length);
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue2, t.getByteArray64()));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue2, (byte[])prop.get(0)));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        byte[] testValue3 = new byte[]{49, 50, 51, 52};
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)testValue3.length, (int)t.getByteArray64().length);
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue3, t.getByteArray64()));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue3, (byte[])prop.get(0)));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        byte[] testValue4 = new byte[]{97, 98, 99};
        prop.set(0, (Object)testValue4);
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue4, t.getByteArray64()));
        ReflectionResourcePropertyTest.assertTrue((boolean)Arrays.equals(testValue4, (byte[])prop.get(0)));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        prop.remove((Object)new byte[]{98});
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        prop.remove((Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
    }

    public void testPrimitives() throws Exception {
        JavaPrimitivesTestClass t = new JavaPrimitivesTestClass();
        QName qname = new QName("http:/foo", "Boolean");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(qname, (Object)t);
        ReflectionResourcePropertyTest.assertEquals((Object)Boolean.FALSE, (Object)prop.get(0));
        boolean testValue1 = true;
        Comparable<Boolean> testObject = new Boolean(testValue1);
        t.setBoolean(testValue1);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Boolean(t.isBoolean()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Char");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        char testValue2 = 'a';
        testObject = new Character(testValue2);
        t.setChar(testValue2);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Character(t.getChar()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Byte");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        byte testValue3 = 20;
        testObject = new Byte(testValue3);
        t.setByte(testValue3);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Byte(t.getByte()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Short");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        short testValue4 = 5;
        testObject = new Short(testValue4);
        t.setShort(testValue4);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Short(t.getShort()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Int");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        int testValue5 = 5;
        testObject = new Integer(testValue5);
        t.setInt(testValue5);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Integer(t.getInt()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Long");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        long testValue6 = 5L;
        testObject = new Long(testValue6);
        t.setLong(testValue6);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Long(t.getLong()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Float");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        float testValue7 = 5.0f;
        testObject = new Float(testValue7);
        t.setFloat(testValue7);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Float(t.getFloat()), (Object)prop.get(0));
        qname = new QName("http:/foo", "Double");
        prop = new ReflectionResourceProperty(qname, (Object)t);
        double testValue = 5.0;
        testObject = new Double(testValue);
        t.setDouble(testValue);
        ReflectionResourcePropertyTest.assertEquals((Object)testObject, (Object)prop.get(0));
        prop.set(0, (Object)testObject);
        ReflectionResourcePropertyTest.assertEquals((Object)new Double(t.getDouble()), (Object)prop.get(0));
    }

    public void testSimple() throws Exception {
        TestClass t = new TestClass();
        QName propBarName = new QName("http:/foo", "Bar");
        ReflectionResourceProperty propBar = new ReflectionResourceProperty(propBarName, (Object)t);
        ReflectionResourcePropertyTest.assertEquals((int)5, (int)t.getBar());
        ReflectionResourcePropertyTest.assertEquals((Object)new Integer(5), (Object)propBar.get(0));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)propBar.size());
        try {
            propBar.set(0, (Object)new Integer(10));
            ReflectionResourcePropertyTest.fail((String)"Expected exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        QName propFooName = new QName("http:/foo", "Foo");
        ReflectionResourceProperty propFoo = new ReflectionResourceProperty(propFooName, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)propFoo.get(0));
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)propFoo.size());
        String testValue = "abcdef";
        propFoo.set(0, (Object)testValue);
        ReflectionResourcePropertyTest.assertEquals((String)testValue, (String)t.getFoo());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue, (Object)propFoo.get(0));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)propFoo.size());
        propFoo.clear();
        ReflectionResourcePropertyTest.assertEquals(null, (String)t.getFoo());
        propFoo.set(0, (Object)testValue);
        boolean result = propFoo.remove((Object)testValue);
        ReflectionResourcePropertyTest.assertEquals((boolean)true, (boolean)result);
        ReflectionResourcePropertyTest.assertEquals(null, (String)t.getFoo());
        ReflectionResourcePropertyTest.assertEquals(null, (Object)propFoo.get(0));
        result = propFoo.remove((Object)testValue);
        ReflectionResourcePropertyTest.assertEquals((boolean)false, (boolean)result);
        String testValue2 = "123456";
        propFoo.set(0, (Object)ObjectSerializer.toElement((Object)testValue2, (QName)propFooName));
        ReflectionResourcePropertyTest.assertEquals((String)testValue2, (String)t.getFoo());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)propFoo.get(0));
        result = propFoo.remove((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propFooName));
        ReflectionResourcePropertyTest.assertEquals((boolean)true, (boolean)result);
        ReflectionResourcePropertyTest.assertEquals(null, (String)t.getFoo());
        ReflectionResourcePropertyTest.assertEquals(null, (Object)propFoo.get(0));
        String testValue3 = "123456abcdef";
        propFoo.set(0, (Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propFooName));
        ReflectionResourcePropertyTest.assertEquals((String)testValue3, (String)t.getFoo());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)propFoo.get(0));
        result = propFoo.remove((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propFooName));
        ReflectionResourcePropertyTest.assertEquals((boolean)true, (boolean)result);
        ReflectionResourcePropertyTest.assertEquals(null, (String)t.getFoo());
        ReflectionResourcePropertyTest.assertEquals(null, (Object)propFoo.get(0));
    }

    public void testArray() throws Exception {
        TestClass t = new TestClass();
        QName propName = new QName("http:/foo", "A");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(propName, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)t.getA());
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        String testValue1 = "ABCDE";
        String testValue2 = "12345";
        String testValue3 = "45677";
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)t.getA().length);
        ReflectionResourcePropertyTest.assertEquals((String)testValue1, (String)t.getA()[0]);
        ReflectionResourcePropertyTest.assertEquals((String)testValue2, (String)t.getA()[1]);
        ReflectionResourcePropertyTest.assertEquals((String)testValue3, (String)t.getA()[2]);
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, (Object)prop.get(0));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)prop.get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(2));
        String testValue4 = "BLAH";
        prop.set(1, (Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((String)testValue4, (String)t.getA()[1]);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue4, (Object)prop.get(1));
        prop.remove((Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((int)2, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((String)testValue3, (String)t.getA()[1]);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(1));
        prop.add((Object)testValue1);
        ReflectionResourcePropertyTest.assertEquals((String)testValue1, (String)t.getA()[0]);
        ReflectionResourcePropertyTest.assertEquals((String)testValue1, (String)t.getA()[2]);
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)prop.size());
        ReflectionResourcePropertyTest.assertTrue((boolean)prop.remove((Object)testValue1));
        ReflectionResourcePropertyTest.assertEquals((int)2, (int)prop.size());
        ReflectionResourcePropertyTest.assertTrue((boolean)prop.remove((Object)testValue1));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        ReflectionResourcePropertyTest.assertFalse((boolean)prop.remove((Object)testValue1));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)prop.size());
        prop.remove((Object)testValue3);
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
    }

    public void testList() throws Exception {
        TestClass t = new TestClass();
        QName propName = new QName("http:/foo", "B");
        SimpleResourcePropertyMetaData metaData = new SimpleResourcePropertyMetaData(propName, 0, Integer.MAX_VALUE, false, class$java$lang$String == null ? (class$java$lang$String = ReflectionResourcePropertyTest.class$("java.lang.String")) : class$java$lang$String, false);
        ReflectionResourceProperty prop = new ReflectionResourceProperty((ResourcePropertyMetaData)metaData, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)t.getB());
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        String testValue1 = "ABCDE";
        String testValue2 = "12345";
        String testValue3 = "45677";
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)t.getB().size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, t.getB().get(0));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, t.getB().get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, t.getB().get(2));
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, (Object)prop.get(0));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)prop.get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(2));
        String testValue4 = "BLAH";
        prop.set(1, (Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((Object)testValue4, t.getB().get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue4, (Object)prop.get(1));
        prop.remove((Object)testValue4);
        ReflectionResourcePropertyTest.assertEquals((int)2, (int)prop.size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, t.getB().get(1));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)prop.get(1));
        prop.remove((Object)testValue1);
        prop.remove((Object)testValue3);
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
    }

    public void testListMixed() throws Exception {
        TestClass t = new TestClass();
        QName propName = new QName("http:/foo", "B");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(propName, (Object)t);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)t.getB());
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
        String testValue1 = "ABCDE";
        String testValue2 = "12345";
        String testValue3 = "45677";
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)t.getB().size());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, t.getB().get(0));
        ReflectionResourcePropertyTest.assertTrue((boolean)(t.getB().get(1) instanceof Element));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)ObjectDeserializer.toObject((Element)((Element)t.getB().get(1)), (Class)(class$java$lang$String == null ? (class$java$lang$String = ReflectionResourcePropertyTest.class$("java.lang.String")) : class$java$lang$String)));
        ReflectionResourcePropertyTest.assertTrue((boolean)(t.getB().get(2) instanceof SOAPElement));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)ObjectDeserializer.toObject((SOAPElement)((SOAPElement)t.getB().get(2)), (Class)(class$java$lang$String == null ? (class$java$lang$String = ReflectionResourcePropertyTest.class$("java.lang.String")) : class$java$lang$String)));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue1, (Object)prop.get(0));
        ReflectionResourcePropertyTest.assertTrue((boolean)(prop.get(1) instanceof Element));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue2, (Object)ObjectDeserializer.toObject((Element)((Element)prop.get(1)), (Class)(class$java$lang$String == null ? (class$java$lang$String = ReflectionResourcePropertyTest.class$("java.lang.String")) : class$java$lang$String)));
        ReflectionResourcePropertyTest.assertTrue((boolean)(prop.get(2) instanceof SOAPElement));
        ReflectionResourcePropertyTest.assertEquals((Object)testValue3, (Object)ObjectDeserializer.toObject((SOAPElement)((SOAPElement)prop.get(2)), (Class)(class$java$lang$String == null ? (class$java$lang$String = ReflectionResourcePropertyTest.class$("java.lang.String")) : class$java$lang$String)));
        prop.clear();
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)prop.size());
    }

    public void testElementArray() throws Exception {
        TestClass t = new TestClass();
        QName propName = new QName("http:/foo", "C");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(propName, (Object)t);
        String testValue1 = "ABCDE";
        String testValue2 = "12345";
        String testValue3 = "45677";
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        Element[] el = t.getC();
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)el.length);
        ReflectionResourcePropertyTest.assertEquals((String)testValue1, (String)el[0].getFirstChild().getNodeValue());
        ReflectionResourcePropertyTest.assertEquals((String)testValue2, (String)el[1].getFirstChild().getNodeValue());
        ReflectionResourcePropertyTest.assertEquals((String)testValue3, (String)el[2].getFirstChild().getNodeValue());
    }

    public void testSOAPElementArray() throws Exception {
        TestClass t = new TestClass();
        QName propName = new QName("http:/foo", "D");
        ReflectionResourceProperty prop = new ReflectionResourceProperty(propName, (Object)t);
        String testValue1 = "ABCDE";
        String testValue2 = "12345";
        String testValue3 = "45677";
        prop.add((Object)testValue1);
        prop.add((Object)ObjectSerializer.toElement((Object)testValue2, (QName)propName));
        prop.add((Object)ObjectSerializer.toSOAPElement((Object)testValue3, (QName)propName));
        SOAPElement[] el = t.getD();
        ReflectionResourcePropertyTest.assertEquals((int)3, (int)el.length);
        for (int i = 0; i < el.length; ++i) {
            System.out.println(el[i]);
        }
        ReflectionResourcePropertyTest.assertTrue((el[0].toString().indexOf(testValue1) != -1 ? 1 : 0) != 0);
        ReflectionResourcePropertyTest.assertTrue((el[1].toString().indexOf(testValue2) != -1 ? 1 : 0) != 0);
        ReflectionResourcePropertyTest.assertTrue((el[2].toString().indexOf(testValue3) != -1 ? 1 : 0) != 0);
    }

    public void testEmptyString() throws Exception {
        TestClass t = new TestClass();
        QName prop1Name = new QName("http:/foo", "Foo");
        ReflectionResourceProperty prop1 = new ReflectionResourceProperty(prop1Name, (Object)t);
        t.setFoo("");
        Element[] elements = prop1.toElements();
        ReflectionResourcePropertyTest.assertTrue((elements != null ? 1 : 0) != 0);
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)elements.length);
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)elements[0].getChildNodes().getLength());
        SOAPElement[] soapElements = prop1.toSOAPElements();
        ReflectionResourcePropertyTest.assertTrue((soapElements != null ? 1 : 0) != 0);
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)soapElements.length);
    }

    public void testNoAccessor() throws Exception {
        TestClass t = new TestClass();
        QName prop1Name = new QName("http:/foo", "FooBar");
        try {
            ReflectionResourceProperty prop1 = new ReflectionResourceProperty(prop1Name, (Object)t);
            ReflectionResourcePropertyTest.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMinNillable() throws Exception {
        QName prop1Name = new QName("http:/foo", "Foo");
        this.testMinNillable(prop1Name);
        QName prop2Name = new QName("http:/foo", "A");
        this.testMinNillable(prop2Name);
        QName prop3Name = new QName("http:/foo", "B");
        this.testMinNillable(prop3Name);
    }

    private void testMinNillable(QName propName) throws Exception {
        SimpleResourcePropertyMetaData metaData = null;
        ReflectionResourceProperty prop = null;
        Element[] elements = null;
        SOAPElement[] soapElements = null;
        TestClass t = new TestClass();
        metaData = new SimpleResourcePropertyMetaData(propName, 0, Integer.MAX_VALUE, false, class$java$lang$Object == null ? (class$java$lang$Object = ReflectionResourcePropertyTest.class$("java.lang.Object")) : class$java$lang$Object, false);
        prop = new ReflectionResourceProperty((ResourcePropertyMetaData)metaData, (Object)t);
        elements = prop.toElements();
        ReflectionResourcePropertyTest.assertTrue((elements == null ? 1 : 0) != 0);
        soapElements = prop.toSOAPElements();
        ReflectionResourcePropertyTest.assertTrue((soapElements == null ? 1 : 0) != 0);
        metaData = new SimpleResourcePropertyMetaData(propName, 1, Integer.MAX_VALUE, false, class$java$lang$Object == null ? (class$java$lang$Object = ReflectionResourcePropertyTest.class$("java.lang.Object")) : class$java$lang$Object, false);
        prop = new ReflectionResourceProperty((ResourcePropertyMetaData)metaData, (Object)t);
        elements = prop.toElements();
        ReflectionResourcePropertyTest.assertTrue((elements == null ? 1 : 0) != 0);
        soapElements = prop.toSOAPElements();
        ReflectionResourcePropertyTest.assertTrue((soapElements == null ? 1 : 0) != 0);
        metaData = new SimpleResourcePropertyMetaData(propName, 1, Integer.MAX_VALUE, true, class$java$lang$Object == null ? (class$java$lang$Object = ReflectionResourcePropertyTest.class$("java.lang.Object")) : class$java$lang$Object, false);
        prop = new ReflectionResourceProperty((ResourcePropertyMetaData)metaData, (Object)t);
        elements = prop.toElements();
        ReflectionResourcePropertyTest.assertTrue((elements != null ? 1 : 0) != 0);
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)elements.length);
        ReflectionResourcePropertyTest.assertEquals((String)"true", (String)elements[0].getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil"));
        soapElements = prop.toSOAPElements();
        ReflectionResourcePropertyTest.assertTrue((soapElements != null ? 1 : 0) != 0);
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)soapElements.length);
        Iterator iter = soapElements[0].getAllAttributes();
        ReflectionResourcePropertyTest.assertTrue((boolean)iter.hasNext());
        ReflectionResourcePropertyTest.assertEquals((String)"true", (String)soapElements[0].getAttributeValue((Name)iter.next()));
    }

    public void testSelfContained() throws Exception {
        QName name = new QName("http:/foo", "Bar");
        RP1 propFoo = new RP1(name);
        ReflectionResourcePropertyTest.assertEquals(null, (Object)propFoo.get(0));
        ReflectionResourcePropertyTest.assertEquals((int)0, (int)propFoo.size());
        String testValue = "abcdef";
        propFoo.set(0, testValue);
        ReflectionResourcePropertyTest.assertEquals((String)testValue, (String)propFoo.getFoo());
        ReflectionResourcePropertyTest.assertEquals((Object)testValue, (Object)propFoo.get(0));
        ReflectionResourcePropertyTest.assertEquals((int)1, (int)propFoo.size());
        propFoo.clear();
        ReflectionResourcePropertyTest.assertEquals(null, (String)propFoo.getFoo());
        propFoo.set(0, testValue);
        boolean result = propFoo.remove(testValue);
        ReflectionResourcePropertyTest.assertEquals((boolean)true, (boolean)result);
        ReflectionResourcePropertyTest.assertEquals(null, (String)propFoo.getFoo());
        ReflectionResourcePropertyTest.assertEquals(null, (Object)propFoo.get(0));
        result = propFoo.remove(testValue);
        ReflectionResourcePropertyTest.assertEquals((boolean)false, (boolean)result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JavaPrimitivesTestClass {
        private boolean booleanP = Boolean.FALSE;
        private short shortP;
        private long longP;
        private int intP;
        private double doubleP;
        private float floatP;
        private byte byteP;
        private char charP;
        private int[] intArray;
        private byte[] byteArray;
        private byte[] byteArray64;

        JavaPrimitivesTestClass() {
        }

        public boolean isBoolean() {
            return this.booleanP;
        }

        public void setBoolean(boolean value) {
            this.booleanP = value;
        }

        public short getShort() {
            return this.shortP;
        }

        public void setShort(short value) {
            this.shortP = value;
        }

        public long getLong() {
            return this.longP;
        }

        public void setLong(long value) {
            this.longP = value;
        }

        public int getInt() {
            return this.intP;
        }

        public void setInt(int value) {
            this.intP = value;
        }

        public double getDouble() {
            return this.doubleP;
        }

        public void setDouble(double value) {
            this.doubleP = value;
        }

        public float getFloat() {
            return this.floatP;
        }

        public void setFloat(float value) {
            this.floatP = value;
        }

        public byte getByte() {
            return this.byteP;
        }

        public void setByte(byte value) {
            this.byteP = value;
        }

        public char getChar() {
            return this.charP;
        }

        public void setChar(char value) {
            this.charP = value;
        }

        public int[] getIntArray() {
            return this.intArray;
        }

        public void setIntArray(int[] values) {
            this.intArray = values;
        }

        public byte[] getByteArray() {
            return this.byteArray;
        }

        public void setByteArray(byte[] values) {
            this.byteArray = values;
        }

        public byte[] getByteArray64() {
            return this.byteArray64;
        }

        public void setByteArray64(byte[] values) {
            this.byteArray64 = values;
        }
    }

    class TestClass {
        private String foo;
        private String[] strArray;
        private Vector strList;
        private Element[] elements;
        private SOAPElement[] soapElements;

        TestClass() {
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String value) {
            this.foo = value;
        }

        public int getBar() {
            return 5;
        }

        public String[] getA() {
            return this.strArray;
        }

        public void setA(String[] value) {
            this.strArray = value;
        }

        public Vector getB() {
            return this.strList;
        }

        public void setB(Vector list) {
            this.strList = list;
        }

        public Element[] getC() {
            return this.elements;
        }

        public void setC(Element[] value) {
            this.elements = value;
        }

        public SOAPElement[] getD() {
            return this.soapElements;
        }

        public void setD(SOAPElement[] value) {
            this.soapElements = value;
        }
    }

    class RP1
    extends ReflectionResourceProperty {
        private String foo;

        public RP1(QName name) throws Exception {
            super((ResourcePropertyMetaData)new SimpleResourcePropertyMetaData(name));
            this.setObject((Object)this);
            this.setPropertyName("Foo");
            this.initialize();
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String value) {
            this.foo = value;
        }
    }
}

