/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.util.HashMap;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.handlers.DIITests;
import org.globus.wsrf.impl.notification.NotificationTestCase;
import org.globus.wsrf.impl.notification.NotificationTestService;
import org.globus.wsrf.impl.notification.NotifyThread;
import org.globus.wsrf.impl.notification.TestNotifyCallback;
import org.globus.wsrf.impl.security.TestConstants;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.test.GridTestSuite;
import org.globus.wsrf.tests.basic.CreateResource;
import org.globus.wsrf.tests.basic.TestPortType;
import org.globus.wsrf.tests.basic.service.TestServiceAddressingLocator;
import org.globus.wsrf.tests.security.CreateResourceResponse;
import org.globus.wsrf.tests.security.SecurityTestPortType;
import org.globus.wsrf.tests.security.SetAnonymousAuthz;
import org.globus.wsrf.tests.security.service.SecurityTestServiceAddressingLocator;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.lifetime.Destroy;

public class GSIServiceContainerTest
extends NotificationTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$container$GSIServiceContainerTest == null ? (class$org$globus$wsrf$container$GSIServiceContainerTest = GSIServiceContainerTest.class$("org.globus.wsrf.container.GSIServiceContainerTest")) : class$org$globus$wsrf$container$GSIServiceContainerTest).getName());
    protected TestServiceAddressingLocator locator = new TestServiceAddressingLocator();
    Authorization authz = TestConstants.getConfiguredClientAuthz();
    org.globus.gsi.gssapi.auth.Authorization gsiAuthz = TestConstants.getConfiguredClientGSIAuthz();
    static /* synthetic */ Class class$org$globus$wsrf$container$GSIServiceContainerTest;

    public GSIServiceContainerTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        String address = TEST_CONTAINER.getBaseURL() + "TestService";
        URI u = new URI(address);
        GSIServiceContainerTest.assertEquals((String)"https", (String)u.getScheme());
        EndpointReferenceType epr = new EndpointReferenceType(u);
        TestPortType port = this.locator.getTestPortTypePort(epr);
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        secDesc.setAuthz(this.authz);
        ((Stub)port)._setProperty("clientDescriptor", (Object)secDesc);
        org.globus.wsrf.tests.basic.CreateResourceResponse response = port.createResource(new CreateResource());
        GSIServiceContainerTest.assertEquals((String)"https", (String)response.getEndpointReference().getAddress().getScheme());
        port = this.locator.getTestPortTypePort(response.getEndpointReference());
        ((Stub)port)._setProperty("clientDescriptor", (Object)secDesc);
        port.destroy(new Destroy());
    }

    public void testAnonymous() throws Exception {
        String address = TEST_CONTAINER.getBaseURL() + "SecurityTestService";
        URI u = new URI(address);
        GSIServiceContainerTest.assertEquals((String)"https", (String)u.getScheme());
        EndpointReferenceType epr = new EndpointReferenceType(u);
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType port = locator.getSecurityTestPortTypePort(epr);
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        secDesc.setAuthz((Authorization)new NoAuthorization());
        secDesc.setAnonymous();
        ((Stub)port)._setProperty("clientDescriptor", (Object)secDesc);
        CreateResourceResponse response = port.createResource(true);
        GSIServiceContainerTest.assertEquals((String)"https", (String)response.getEndpointReference().getAddress().getScheme());
        port = locator.getSecurityTestPortTypePort(response.getEndpointReference());
        ((Stub)port)._setProperty("clientDescriptor", (Object)secDesc);
        port.setAnonymousAuthz(new SetAnonymousAuthz());
        port.setValue(20);
    }

    public void testDII() throws Exception {
        String address = TEST_CONTAINER.getBaseURL() + "TestService" + "?wsdl";
        DIITests test = new DIITests("diiTest");
        HashMap<String, ClientSecurityDescriptor> props = new HashMap<String, ClientSecurityDescriptor>();
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        secDesc.setAuthz(this.authz);
        props.put("clientDescriptor", secDesc);
        test.diiTest(address, props);
    }

    public void testSecurityPolicy() throws Exception {
        GSIServiceContainerTest.assertTrue((TEST_CONTAINER != null ? 1 : 0) != 0);
        String testServiceAddrs = TEST_CONTAINER.getBaseURL() + "SecurityTestService";
        EndpointReferenceType testServiceEPR = new EndpointReferenceType(new URI(testServiceAddrs));
        SecurityTestServiceAddressingLocator locator = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort = locator.getSecurityTestPortTypePort(testServiceEPR);
        ((Stub)testPort)._setProperty("org.globus.security.transport.type", (Object)GSIConstants.SIGNATURE);
        ((Stub)testPort)._setProperty("org.globus.gsi.authorization", (Object)this.gsiAuthz);
        this.verifySecureAccess(testPort, true, true, false);
        testPort = locator.getSecurityTestPortTypePort(testServiceEPR);
        ((Stub)testPort)._setProperty("org.globus.security.transport.type", (Object)GSIConstants.ENCRYPTION);
        ((Stub)testPort)._setProperty("org.globus.gsi.authorization", (Object)this.gsiAuthz);
        this.verifySecureAccess(testPort, true, false, true);
        SecurityTestServiceAddressingLocator locator1 = new SecurityTestServiceAddressingLocator();
        SecurityTestPortType testPort1 = locator1.getSecurityTestPortTypePort(testServiceEPR);
        ((Stub)testPort1)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
        ((Stub)testPort1)._setProperty("org.globus.security.authorization", (Object)this.authz);
        ((Stub)testPort1)._setProperty("org.globus.gsi.authorization", (Object)this.gsiAuthz);
        this.verifySecureAccess(testPort1, true, true, false);
    }

    private void verifySecureAccess(SecurityTestPortType testPort, boolean transportOnly, boolean transportIntegrity, boolean transportPrivacy) throws Exception {
        boolean exp = true;
        try {
            testPort.gsiTransportOnly(null);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("authentication require") != -1) {
                exp = false;
            }
            logger.error((Object)e);
        }
        GSIServiceContainerTest.assertTrue((exp == transportOnly ? 1 : 0) != 0);
        exp = true;
        try {
            testPort.gsiTransportIntegrity(null);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("authentication require") != -1) {
                exp = false;
            }
            logger.error((Object)e);
        }
        GSIServiceContainerTest.assertTrue((exp == transportIntegrity ? 1 : 0) != 0);
        exp = true;
        try {
            testPort.gsiTransportPrivacy(null);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("authentication require") != -1) {
                exp = false;
            }
            logger.error((Object)e);
        }
        GSIServiceContainerTest.assertTrue((exp == transportPrivacy ? 1 : 0) != 0);
    }

    public void testMultipleNotifications() throws Exception {
        TestNotifyCallback callback = new TestNotifyCallback();
        int expectedCount = 1;
        HashMap<String, String> properties = new HashMap<String, String>();
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        secDesc.setAuthz(this.authz);
        properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance(properties);
        consumer.startListening();
        EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)callback);
        GSIServiceContainerTest.assertEquals((String)"https", (String)consumerEPR.getAddress().getScheme());
        Subscribe request = new Subscribe();
        request.setConsumerReference(consumerEPR);
        TopicExpressionType topicPath = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)NotificationTestService.TEST_TOPIC);
        request.setTopicExpression(topicPath);
        ((Stub)this.port)._setProperty("clientDescriptor", (Object)secDesc);
        SubscribeResponse response = this.port.subscribe(request);
        for (int i = 0; i < 10; ++i) {
            this.port.generateNotification(NotificationTestService.TEST_TOPIC);
            GSIServiceContainerTest.assertTrue((String)("timed out waiting for notification #" + expectedCount), (boolean)callback.waitForCount(expectedCount, GridTestSuite.timeout));
            GSIServiceContainerTest.assertEquals((int)expectedCount, (int)callback.getNotifyCount());
            ++expectedCount;
        }
        SubscriptionManager manager = this.managerLocator.getSubscriptionManagerPort(response.getSubscriptionReference());
        ((Stub)manager)._setProperty("clientDescriptor", (Object)secDesc);
        manager.destroy(new Destroy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultithreadedNotifications() throws Throwable {
        int i;
        HashMap<String, String> properties = new HashMap<String, String>();
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        secDesc.setAuthz(this.authz);
        properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
        NotificationConsumerManager consumer = NotificationConsumerManager.getInstance(properties);
        consumer.startListening();
        ((Stub)this.port)._setProperty("clientDescriptor", (Object)secDesc);
        Object lock = new Object();
        int size = 10;
        NotifyThread[] threads = new NotifyThread[size];
        for (i = 0; i < size; ++i) {
            threads[i] = new NotifyThread(this.testServiceEPR, consumer, lock, secDesc);
            threads[i].start();
        }
        for (i = 0; i < size; ++i) {
            while (!threads[i].isSubscribed()) {
                Throwable e = threads[i].getException();
                if (e != null) {
                    throw e;
                }
                Thread.sleep(100L);
            }
        }
        Object i2 = lock;
        synchronized (i2) {
            lock.notifyAll();
        }
        this.port.generateNotification(NotificationTestService.TEST_TOPIC);
        Throwable e = null;
        for (int i3 = 0; i3 < size; ++i3) {
            threads[i3].join();
            if (threads[i3].getException() == null) continue;
            threads[i3].getException().printStackTrace();
            if (e != null) continue;
            e = threads[i3].getException();
        }
        if (e != null) {
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

