/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp.rpprovider.transforms;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.glue.ArchitectureType;
import org.globus.mds.glue.MainMemoryType;
import org.globus.mds.glue.OperatingSystemType;
import org.globus.mds.glue.ProcessorType;
import org.globus.mds.glue.StorageDeviceType;
import org.globus.mds.glue.config.ClusterConfiguration;
import org.globus.mds.glue.config.ClusterDefinitionType;
import org.globus.mds.glue.config.HostNameArrayDefinitionType;
import org.globus.mds.glue.config.HostNameDefinitionType;
import org.globus.mds.glue.config.SubClusterDefinitionType;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GLUEXMLOrganizer {
    private static final String NAMESPACE_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String NAMESPACE_GLUE = "http://mds.globus.org/glue/ce/1.1";
    private static final String NAMESPACE_CLUSTERCFG = "http://mds.globus.org/2005/09/cluster-config";
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEXMLOrganizer == null ? (class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEXMLOrganizer = GLUEXMLOrganizer.class$("org.globus.mds.usefulrp.rpprovider.transforms.GLUEXMLOrganizer")) : class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEXMLOrganizer).getName());
    private static final int NONE = 2;
    private static final int ADD_TO_HOST_FALSE = 3;
    private static final int CONTINUE = 4;
    private static final int UNKNOWN = 6;
    private static final int MAIN_MEMORY = 7;
    private static final int PROCESSOR = 8;
    private static final int OPERATING_SYSTEM = 9;
    private static final int ARCHITECTURE = 10;
    private static final int STORAGEDEVICE = 11;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEXMLOrganizer;
    static /* synthetic */ Class class$org$globus$mds$glue$config$ClusterConfiguration;

    public static ClusterConfiguration parseConfig(String configFile) {
        ClusterConfiguration config = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(new File(configFile));
            Element elem = doc.getDocumentElement();
            config = (ClusterConfiguration)ObjectDeserializer.toObject((Element)elem, (Class)(class$org$globus$mds$glue$config$ClusterConfiguration == null ? (class$org$globus$mds$glue$config$ClusterConfiguration = GLUEXMLOrganizer.class$("org.globus.mds.glue.config.ClusterConfiguration")) : class$org$globus$mds$glue$config$ClusterConfiguration));
            if (config != null) {
                if (config.getCluster() == null) {
                    logger.error((Object)"Cluster configuration information is invalid.");
                } else if (config.getCluster().getSubCluster() == null) {
                    logger.error((Object)"SubCluster configuration information is invalid.");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load configuration: " + e));
        }
        return config;
    }

    private static String replaceNS(String attr) {
        int colonPos;
        String newAttr = attr;
        if (attr != null && (colonPos = attr.indexOf(58)) != -1) {
            newAttr = "glue:" + attr.substring(colonPos + 1);
        }
        return newAttr;
    }

    public static String removeNS(String attr) {
        int colonPos;
        String newAttr = attr;
        if (attr != null && (colonPos = attr.indexOf(58)) != -1) {
            newAttr = attr.substring(colonPos + 1);
        }
        return newAttr;
    }

    private static void mapHostsToSubCluster(Map hostObjMap, Map hostElemMap, Map hostUIDMap, Element subClusterElem, SubClusterDefinitionType subClusterObj, HostNameArrayDefinitionType hostnames) {
        if (hostObjMap != null && hostElemMap != null && subClusterElem != null && subClusterObj != null && hostnames != null) {
            int numHostNames = Array.getLength(hostnames.getHostName());
            for (int i = 0; i < numHostNames; ++i) {
                HostNameDefinitionType curHost = hostnames.getHostName(i);
                if (curHost == null || curHost.getName() == null) continue;
                String currentHostStr = curHost.getName();
                hostObjMap.put(currentHostStr, subClusterObj);
                hostElemMap.put(currentHostStr, subClusterElem);
                hostUIDMap.put(currentHostStr, curHost);
            }
        }
    }

    private static int checkMainMemoryForSubClusterLevel(MainMemoryType mem, Map addedToSubClusterDupMap, SubClusterDefinitionType currentSubClusterObj) {
        int ret = 2;
        if (mem == null) {
            return ret;
        }
        HashMap<String, MainMemoryType> tmpMap = (HashMap<String, MainMemoryType>)addedToSubClusterDupMap.get(currentSubClusterObj);
        if (tmpMap == null) {
            tmpMap = new HashMap<String, MainMemoryType>();
        }
        if (tmpMap.get("MainMemory") != mem) {
            ret = 3;
            tmpMap.put("MainMemory", mem);
            addedToSubClusterDupMap.put(currentSubClusterObj, tmpMap);
        } else {
            ret = 4;
        }
        return ret;
    }

    private static int checkProcessorForSubClusterLevel(ProcessorType proc, Map addedToSubClusterDupMap, SubClusterDefinitionType currentSubClusterObj) {
        int ret = 2;
        if (proc == null) {
            return ret;
        }
        HashMap<String, ProcessorType> tmpMap = (HashMap<String, ProcessorType>)addedToSubClusterDupMap.get(currentSubClusterObj);
        if (tmpMap == null) {
            tmpMap = new HashMap<String, ProcessorType>();
        }
        if (tmpMap.get("Processor") != proc) {
            ret = 3;
            tmpMap.put("Processor", proc);
            addedToSubClusterDupMap.put(currentSubClusterObj, tmpMap);
        } else {
            ret = 4;
        }
        return ret;
    }

    private static int checkOperatingSystemForSubClusterLevel(OperatingSystemType os, Map addedToSubClusterDupMap, SubClusterDefinitionType currentSubClusterObj) {
        int ret = 2;
        if (os == null) {
            return ret;
        }
        HashMap<String, OperatingSystemType> tmpMap = (HashMap<String, OperatingSystemType>)addedToSubClusterDupMap.get(currentSubClusterObj);
        if (tmpMap == null) {
            tmpMap = new HashMap<String, OperatingSystemType>();
        }
        if (tmpMap.get("OperatingSystem") != os) {
            ret = 3;
            tmpMap.put("OperatingSystem", os);
            addedToSubClusterDupMap.put(currentSubClusterObj, tmpMap);
        } else {
            ret = 4;
        }
        return ret;
    }

    private static int checkArchitectureForSubClusterLevel(ArchitectureType arch, Map addedToSubClusterDupMap, SubClusterDefinitionType currentSubClusterObj) {
        int ret = 2;
        if (arch == null) {
            return ret;
        }
        HashMap<String, ArchitectureType> tmpMap = (HashMap<String, ArchitectureType>)addedToSubClusterDupMap.get(currentSubClusterObj);
        if (tmpMap == null) {
            tmpMap = new HashMap<String, ArchitectureType>();
        }
        if (tmpMap.get("Architecture") != arch) {
            ret = 3;
            tmpMap.put("Architecture", arch);
            addedToSubClusterDupMap.put(currentSubClusterObj, tmpMap);
        } else {
            ret = 4;
        }
        return ret;
    }

    private static int checkStorageDeviceForSubClusterLevel(StorageDeviceType[] storageArray, Map addedToSubClusterDupMap, SubClusterDefinitionType currentSubClusterObj) {
        StorageDeviceType storage;
        int ret = 2;
        StorageDeviceType storageDeviceType = storage = storageArray == null ? null : storageArray[0];
        if (storage == null) {
            return ret;
        }
        HashMap<String, StorageDeviceType> tmpMap = (HashMap<String, StorageDeviceType>)addedToSubClusterDupMap.get(currentSubClusterObj);
        if (tmpMap == null) {
            tmpMap = new HashMap<String, StorageDeviceType>();
        }
        if (tmpMap.get("StorageDevice") != storage) {
            ret = 3;
            tmpMap.put("StorageDevice", storage);
            addedToSubClusterDupMap.put(currentSubClusterObj, tmpMap);
        } else {
            ret = 4;
        }
        return ret;
    }

    private static String getOrSetConvertedMemAttributeValue(String attrName, MainMemoryType mem, String hostValue) {
        String ret = null;
        boolean memIsNull = mem == null;
        int len = hostValue.length();
        if (attrName.equals("RAMSize")) {
            if (memIsNull || !memIsNull && mem.getRAMSize() == 0L && len > 0) {
                mem.setRAMSize(new Long(hostValue).longValue());
            }
            ret = String.valueOf(mem.getRAMSize());
        } else if (attrName.equals("RAMAvailable")) {
            if (memIsNull || !memIsNull && mem.getRAMAvailable() == 0L && len > 0) {
                mem.setRAMAvailable(new Long(hostValue).longValue());
            }
            ret = String.valueOf(mem.getRAMAvailable());
        } else if (attrName.equals("VirtualSize")) {
            if (memIsNull || !memIsNull && mem.getVirtualSize() == 0L && len > 0) {
                mem.setVirtualSize(new Long(hostValue).longValue());
            }
            ret = String.valueOf(mem.getVirtualSize());
        } else if (attrName.equals("VirtualAvailable")) {
            if (memIsNull || !memIsNull && mem.getVirtualAvailable() == 0L && len > 0) {
                mem.setVirtualAvailable(new Long(hostValue).longValue());
            }
            ret = String.valueOf(mem.getVirtualAvailable());
        }
        return ret;
    }

    private static String getOrSetConvertedProcAttributeValue(String attrName, ProcessorType proc, String hostValue) {
        String ret = null;
        boolean procIsNull = proc == null;
        int len = hostValue.length();
        if (attrName.equals("CacheL1")) {
            if (procIsNull || !procIsNull && proc.getCacheL1() == 0 && len > 0) {
                proc.setCacheL1(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(proc.getCacheL1());
        } else if (attrName.equals("CacheL1I")) {
            if (procIsNull || !procIsNull && proc.getCacheL1I() == 0 && len > 0) {
                proc.setCacheL1I(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(proc.getCacheL1I());
        } else if (attrName.equals("CacheL1D")) {
            if (procIsNull || !procIsNull && proc.getCacheL1D() == 0 && len > 0) {
                proc.setCacheL1D(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(proc.getCacheL1D());
        } else if (attrName.equals("CacheL2")) {
            if (procIsNull || !procIsNull && proc.getCacheL2() == 0 && len > 0) {
                proc.setCacheL2(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(proc.getCacheL2());
        } else if (attrName.equals("ClockSpeed")) {
            if (procIsNull || !procIsNull && proc.getClockSpeed() == 0 && len > 0) {
                proc.setClockSpeed(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(proc.getClockSpeed());
        } else if (attrName.equals("InstructionSet")) {
            if (procIsNull || proc.getInstructionSet() == null || !procIsNull && proc.getInstructionSet().length() == 0 && len > 0) {
                proc.setInstructionSet(hostValue);
            }
            ret = proc.getInstructionSet();
        } else if (attrName.equals("Model")) {
            if (procIsNull || proc.getModel() == null || !procIsNull && proc.getModel().length() == 0 && len > 0) {
                proc.setModel(hostValue);
            }
            ret = proc.getModel();
        } else if (attrName.equals("Version")) {
            if (procIsNull || proc.getVersion() == null || !procIsNull && proc.getVersion().length() == 0 && len > 0) {
                proc.setVersion(hostValue);
            }
            ret = proc.getVersion();
        } else if (attrName.equals("Vendor")) {
            if (procIsNull || proc.getVendor() == null || !procIsNull && proc.getVendor().length() == 0 && len > 0) {
                proc.setVendor(hostValue);
            }
            ret = proc.getVendor();
        }
        return ret;
    }

    private static String getOrSetConvertedOsAttributeValue(String attrName, OperatingSystemType os, String hostValue) {
        String ret = null;
        boolean osIsNull = os == null;
        int len = hostValue.length();
        if (attrName.equals("Name")) {
            if (osIsNull || os.getName() == null || !osIsNull && os.getName().length() == 0 && len > 0) {
                os.setName(hostValue);
            }
            ret = os.getName();
        } else if (attrName.equals("Release")) {
            if (osIsNull || os.getRelease() == null || !osIsNull && os.getRelease().length() == 0 && len > 0) {
                os.setRelease(hostValue);
            }
            ret = os.getRelease();
        } else if (attrName.equals("Version")) {
            if (osIsNull || os.getVersion() == null || !osIsNull && os.getVersion().length() == 0 && len > 0) {
                os.setVersion(hostValue);
            }
            ret = os.getVersion();
        }
        return ret;
    }

    private static String getOrSetConvertedArchAttributeValue(String attrName, ArchitectureType arch, String hostValue) {
        String ret = null;
        boolean archIsNull = arch == null;
        int len = hostValue.length();
        if (attrName.equals("PlatformType")) {
            if (archIsNull || arch.getPlatformType() == null || !archIsNull && arch.getPlatformType().length() == 0 && len > 0) {
                arch.setPlatformType(hostValue);
            }
            ret = arch.getPlatformType();
        } else if (attrName.equals("SMPSize")) {
            if (archIsNull || !archIsNull && arch.getSMPSize() == 0 && len > 0) {
                arch.setSMPSize(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(arch.getSMPSize());
        }
        return ret;
    }

    private static String getOrSetConvertedStorageDeviceAttributeValue(String attrName, StorageDeviceType[] storageArray, String hostValue) {
        String ret = null;
        StorageDeviceType storage = storageArray == null ? null : storageArray[0];
        boolean storageIsNull = storage == null;
        int len = hostValue.length();
        if (attrName.equals("Name")) {
            if (storageIsNull || storage.getName() == null || !storageIsNull && storage.getName().length() == 0 && len > 0) {
                storage.setName(hostValue);
            }
            ret = storage.getName();
        } else if (attrName.equals("Type")) {
            if (storageIsNull || storage.getType() == null || !storageIsNull && storage.getType().length() == 0 && len > 0) {
                storage.setType(hostValue);
            }
            ret = storage.getType();
        } else if (attrName.equals("TransferRate")) {
            if (storageIsNull || !storageIsNull && storage.getTransferRate() == 0 && len > 0) {
                storage.setTransferRate(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(storage.getTransferRate());
        } else if (attrName.equals("Size")) {
            if (storageIsNull || !storageIsNull && storage.getSize() == 0 && len > 0) {
                storage.setSize(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(storage.getSize());
        } else if (attrName.equals("AvailableSpace")) {
            if (storageIsNull || !storageIsNull && storage.getAvailableSpace() == 0 && len > 0) {
                storage.setAvailableSpace(new Integer(hostValue).intValue());
            }
            ret = String.valueOf(storage.getAvailableSpace());
        }
        return ret;
    }

    public static Document reorganizeGLUEDocument(ClusterConfiguration config, Document sourceDoc, String uidToAppend) throws Exception, IOException, ParserConfigurationException, SAXException {
        ClusterDefinitionType cluster = config.getCluster();
        SubClusterDefinitionType[] subCluster = cluster.getSubCluster();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder db = factory.newDocumentBuilder();
        Document destDoc = db.newDocument();
        Element root = destDoc.createElementNS(NAMESPACE_GLUE, "glue:ClusterInformation");
        destDoc.appendChild(root);
        Element destCluster = destDoc.createElementNS(NAMESPACE_GLUE, "glue:Cluster");
        destCluster.setAttributeNS(NAMESPACE_GLUE, "glue:Name", cluster.getName());
        destCluster.setAttributeNS(NAMESPACE_GLUE, "glue:UniqueID", cluster.getUniqueID());
        root.appendChild(destCluster);
        int i = 0;
        int numSubClusters = Array.getLength(subCluster);
        HashMap hostToSubClusterObjMap = new HashMap();
        HashMap hostToSubClusterElemMap = new HashMap();
        HashMap hostToUniqueIDMap = new HashMap();
        HashMap<Element, Vector<Element>> subClusterToHostElemMap = new HashMap<Element, Vector<Element>>();
        HashMap addedToSubClusterDupMap = new HashMap();
        HostNameArrayDefinitionType hostNameArray = null;
        for (i = 0; i < numSubClusters; ++i) {
            SubClusterDefinitionType cur = cluster.getSubCluster(i);
            Element destSubCluster = destDoc.createElementNS(NAMESPACE_GLUE, "glue:SubCluster");
            destSubCluster.setAttributeNS(NAMESPACE_GLUE, "glue:Name", cur.getName());
            destSubCluster.setAttributeNS(NAMESPACE_GLUE, "glue:UniqueID", cur.getUniqueID());
            destCluster.appendChild(destSubCluster);
            hostNameArray = cur.getHostNames();
            if (hostNameArray == null) {
                throw new Exception("No hosts specified.  Nothing to transform.");
            }
            GLUEXMLOrganizer.mapHostsToSubCluster(hostToSubClusterObjMap, hostToSubClusterElemMap, hostToUniqueIDMap, destSubCluster, cur, hostNameArray);
        }
        Element currentSubClusterElem = null;
        SubClusterDefinitionType currentSubClusterObj = null;
        HashMap<String, String> duplicateHostMap = new HashMap<String, String>();
        Object firstHost = null;
        NodeList hosts = sourceDoc.getElementsByTagNameNS(NAMESPACE_GLUE, "Host");
        int numHosts = hosts.getLength();
        Element totalNodes = destDoc.createElementNS(NAMESPACE_CLUSTERCFG, "cfg:TeraGridExtensions");
        totalNodes.setAttributeNS(NAMESPACE_CLUSTERCFG, "cfg:TotalNodes", new Integer(numHosts).toString());
        destCluster.appendChild(totalNodes);
        block1: for (i = 0; i < numHosts; ++i) {
            Element host = (Element)hosts.item(i);
            String currentHostName = "";
            Element destHost = destDoc.createElementNS(NAMESPACE_GLUE, "glue:Host");
            NamedNodeMap srcAttrs = host.getAttributes();
            for (int l = 0; l < srcAttrs.getLength(); ++l) {
                Attr attr = (Attr)srcAttrs.item(l);
                String currentAttrName = GLUEXMLOrganizer.replaceNS(attr.getName());
                HostNameDefinitionType currentHost = null;
                if (GLUEXMLOrganizer.removeNS(attr.getName()).equals("Name")) {
                    currentHostName = attr.getValue();
                    if (uidToAppend != null) {
                        currentHostName = currentHostName + uidToAppend;
                    }
                }
                if (GLUEXMLOrganizer.removeNS(attr.getName()).equals("UniqueID") && currentHostName != null) {
                    currentHost = (HostNameDefinitionType)hostToUniqueIDMap.get(currentHostName);
                    if (currentHost != null && currentHost.getUniqueID() != null) {
                        destHost.setAttributeNS(NAMESPACE_GLUE, currentAttrName, currentHost.getUniqueID());
                        continue;
                    }
                    destHost.setAttributeNS(NAMESPACE_GLUE, currentAttrName, attr.getValue());
                    continue;
                }
                if (GLUEXMLOrganizer.removeNS(attr.getName()).equals("Name") && currentHostName != null) {
                    destHost.setAttributeNS(NAMESPACE_GLUE, currentAttrName, currentHostName);
                    continue;
                }
                destHost.setAttributeNS(NAMESPACE_GLUE, currentAttrName, attr.getValue());
            }
            if (duplicateHostMap.containsKey(currentHostName)) continue;
            duplicateHostMap.put(currentHostName, "1");
            currentSubClusterElem = (Element)hostToSubClusterElemMap.get(currentHostName);
            currentSubClusterObj = (SubClusterDefinitionType)hostToSubClusterObjMap.get(currentHostName);
            if (currentSubClusterElem == null || currentSubClusterObj == null) {
                logger.error((Object)("Fatal error!  Unmapped hostname \"" + currentHostName + "\" in GLUE input data."));
                logger.error((Object)"A host name was encountered that was not specified in the configuration.");
                logger.error((Object)"Make sure all hosts are part of a SubCluster definition.  Aborting");
                throw new Exception("Invalid configuration.  Check the error log for detail.");
            }
            Vector<Element> curList = (Vector<Element>)subClusterToHostElemMap.get(currentSubClusterElem);
            if (curList == null) {
                curList = new Vector<Element>();
                subClusterToHostElemMap.put(currentSubClusterElem, curList);
            }
            curList.add(destHost);
            Node child = host.getFirstChild();
            while (child != null) {
                while (child != null && child.getNodeType() != 1) {
                    child = child.getNextSibling();
                }
                if (child == null) continue block1;
                String childName = GLUEXMLOrganizer.replaceNS(child.getNodeName());
                String cleanChildName = GLUEXMLOrganizer.removeNS(childName);
                Element childElem = destDoc.createElementNS(NAMESPACE_GLUE, childName);
                boolean addToHost = true;
                int processingState = 2;
                int elementType = 6;
                MainMemoryType mem = currentSubClusterObj.getMainMemory();
                ProcessorType proc = currentSubClusterObj.getProcessor();
                OperatingSystemType os = currentSubClusterObj.getOperatingSystem();
                ArchitectureType arch = currentSubClusterObj.getArchitecture();
                StorageDeviceType[] storage = currentSubClusterObj.getStorageDevice();
                if (cleanChildName.equals("MainMemory")) {
                    processingState = GLUEXMLOrganizer.checkMainMemoryForSubClusterLevel(mem, addedToSubClusterDupMap, currentSubClusterObj);
                    elementType = 7;
                } else if (cleanChildName.equals("Processor")) {
                    processingState = GLUEXMLOrganizer.checkProcessorForSubClusterLevel(proc, addedToSubClusterDupMap, currentSubClusterObj);
                    elementType = 8;
                } else if (cleanChildName.equals("OperatingSystem")) {
                    processingState = GLUEXMLOrganizer.checkOperatingSystemForSubClusterLevel(os, addedToSubClusterDupMap, currentSubClusterObj);
                    elementType = 9;
                } else if (cleanChildName.equals("Architecture")) {
                    processingState = GLUEXMLOrganizer.checkArchitectureForSubClusterLevel(arch, addedToSubClusterDupMap, currentSubClusterObj);
                    elementType = 10;
                } else if (cleanChildName.equals("StorageDevice")) {
                    processingState = GLUEXMLOrganizer.checkStorageDeviceForSubClusterLevel(storage, addedToSubClusterDupMap, currentSubClusterObj);
                    elementType = 11;
                }
                if (processingState == 3) {
                    addToHost = false;
                } else if (processingState == 4) {
                    child = child.getNextSibling();
                    continue;
                }
                int numInvalidAttrs = 0;
                NamedNodeMap childAttrs = child.getAttributes();
                for (int m = 0; m < childAttrs.getLength(); ++m) {
                    Attr cAttr = (Attr)childAttrs.item(m);
                    String cAttrCleanName = GLUEXMLOrganizer.removeNS(cAttr.getName());
                    if (!addToHost) {
                        String val = "";
                        val = elementType == 7 ? GLUEXMLOrganizer.getOrSetConvertedMemAttributeValue(cAttrCleanName, mem, cAttr.getValue()) : (elementType == 8 ? GLUEXMLOrganizer.getOrSetConvertedProcAttributeValue(cAttrCleanName, proc, cAttr.getValue()) : (elementType == 9 ? GLUEXMLOrganizer.getOrSetConvertedOsAttributeValue(cAttrCleanName, os, cAttr.getValue()) : (elementType == 10 ? GLUEXMLOrganizer.getOrSetConvertedArchAttributeValue(cAttrCleanName, arch, cAttr.getValue()) : (elementType == 11 ? GLUEXMLOrganizer.getOrSetConvertedStorageDeviceAttributeValue(cAttrCleanName, storage, cAttr.getValue()) : cAttr.getValue()))));
                        if (val == null || val.equals("0")) continue;
                        childElem.setAttributeNS(NAMESPACE_GLUE, GLUEXMLOrganizer.replaceNS(cAttr.getName()), val);
                        continue;
                    }
                    if (cAttr.getValue() == null || cAttr.getValue().equals("")) {
                        ++numInvalidAttrs;
                        continue;
                    }
                    childElem.setAttributeNS(NAMESPACE_GLUE, GLUEXMLOrganizer.replaceNS(cAttr.getName()), cAttr.getValue());
                }
                if (childAttrs.getLength() != numInvalidAttrs) {
                    if (addToHost) {
                        destHost.appendChild(childElem);
                    } else {
                        currentSubClusterElem.appendChild(childElem);
                    }
                }
                child = child.getNextSibling();
            }
        }
        Iterator keyIter = subClusterToHostElemMap.keySet().iterator();
        Iterator valIter = subClusterToHostElemMap.values().iterator();
        while (keyIter.hasNext() && valIter.hasNext()) {
            Element subClusterElem = (Element)keyIter.next();
            Vector curHostElemList = (Vector)valIter.next();
            int listSize = curHostElemList.size();
            for (i = 0; i < listSize; ++i) {
                Element curHostElem = (Element)curHostElemList.get(i);
                subClusterElem.appendChild(curHostElem);
            }
            Element curTotalNodes = destDoc.createElementNS(NAMESPACE_CLUSTERCFG, "cfg:TeraGridExtensions");
            curTotalNodes.setAttributeNS(NAMESPACE_CLUSTERCFG, "cfg:TotalNodes", new Integer(listSize).toString());
            subClusterElem.appendChild(curTotalNodes);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"** Final Transformed document (before deserialization) ***");
            String output = ObjectSerializer.toString((Object)cluster, (QName)cluster.getTypeDesc().getXmlType());
            logger.debug((Object)output);
        }
        return destDoc;
    }

    public static void transformDocument(Document doc) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.error((Object)"transformation of document failed!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

