/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp.rpprovider.transforms;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.glue.batchprovider.ClusterCollectionType;
import org.globus.mds.glue.config.ClusterConfiguration;
import org.globus.mds.usefulrp.rpprovider.ResourcePropertyElementTransform;
import org.globus.mds.usefulrp.rpprovider.transforms.GLUEXMLOrganizer;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GLUEComputeElementTransform
implements ResourcePropertyElementTransform {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEComputeElementTransform == null ? (class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEComputeElementTransform = GLUEComputeElementTransform.class$("org.globus.mds.usefulrp.rpprovider.transforms.GLUEComputeElementTransform")) : class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEComputeElementTransform).getName());
    ClusterConfiguration config = null;
    long configLastModified = 0L;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$transforms$GLUEComputeElementTransform;
    static /* synthetic */ Class class$org$globus$mds$glue$batchprovider$ClusterCollectionType;

    private void rescanConfig(String configFile) throws Exception {
        File file = new File(configFile);
        if (this.configLastModified == 0L) {
            this.configLastModified = file.lastModified();
        } else if (this.configLastModified >= file.lastModified()) {
            return;
        }
        this.configLastModified = file.lastModified();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Processing subcluster definition configuration file");
        }
        this.config = GLUEXMLOrganizer.parseConfig(configFile);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Processed a valid GLUE subcluster definition configuration file");
        }
    }

    public Object transformElement(Element source, String[] args) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Input document XML: " + ObjectSerializer.toString((Object)source)));
        }
        Element resultElement = source;
        if (args != null && args.length > 0) {
            try {
                this.rescanConfig(args[0]);
                if (this.config != null) {
                    Document sourceDoc = source.getOwnerDocument();
                    Document destDoc = GLUEXMLOrganizer.reorganizeGLUEDocument(this.config, sourceDoc, args.length > 1 ? args[1] : null);
                    resultElement = destDoc.getDocumentElement();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Successfully reorganized GLUE document XML: " + ObjectSerializer.toString((Object)resultElement)));
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Exception while attempting to collate GLUE information: " + e));
            }
        }
        ClusterCollectionType clusters = null;
        try {
            clusters = (ClusterCollectionType)ObjectDeserializer.toObject((Element)resultElement, (Class)(class$org$globus$mds$glue$batchprovider$ClusterCollectionType == null ? (class$org$globus$mds$glue$batchprovider$ClusterCollectionType = GLUEComputeElementTransform.class$("org.globus.mds.glue.batchprovider.ClusterCollectionType")) : class$org$globus$mds$glue$batchprovider$ClusterCollectionType));
        }
        catch (Exception e) {
            logger.warn((Object)("Exception while trying to deserialize GLUE input: " + e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Successfully deserialized transform input into ClusterCollectionType object: " + ObjectSerializer.toString((Object)clusters)));
        }
        if (clusters != null) {
            return clusters.getCluster();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

