/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp.rpprovider.producers;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.usefulrp.rpprovider.ResourcePropertyElementProducer;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JVMInfoElementProducer
implements ResourcePropertyElementProducer {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$rpprovider$producers$JVMInfoElementProducer == null ? (class$org$globus$mds$usefulrp$rpprovider$producers$JVMInfoElementProducer = JVMInfoElementProducer.class$("org.globus.mds.usefulrp.rpprovider.producers.JVMInfoElementProducer")) : class$org$globus$mds$usefulrp$rpprovider$producers$JVMInfoElementProducer).getName());
    private static String NS = "http://mds.globus.org/glue/ce/1.1";
    private static String PREFIX = "mds";
    boolean isDebug;
    private Element docRoot;
    private Element osInfo;
    private Element cpuInfo;
    private Element memInfo;
    private List drives;
    private String errorString;
    private Document doc = XmlUtils.newDocument();
    private int period = 0;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$producers$JVMInfoElementProducer;

    public JVMInfoElementProducer() throws Exception {
        this.init();
    }

    public Element getElement(String[] args) throws Exception {
        this.updateSystemInfo();
        this.updateFileSystemInfo();
        return this.docRoot;
    }

    public void setNamespace(String namespacePrefix, String namespaceURI) throws Exception {
        PREFIX = namespacePrefix;
        NS = namespaceURI;
    }

    public String toString() {
        return XmlUtils.toString((Document)this.doc);
    }

    protected void updateSystemInfo() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        long totalMem = runtime.totalMemory();
        long freeMem = runtime.freeMemory();
        long maxMem = runtime.maxMemory();
        long usedMem = totalMem - freeMem;
        this.memInfo.setAttributeNS(NS, PREFIX + ":" + "RAMSize", Long.toString(totalMem));
        this.memInfo.setAttributeNS(NS, PREFIX + ":" + "RAMAvailable", Long.toString(freeMem));
        this.memInfo.setAttributeNS(NS, PREFIX + ":" + "VirtualSize", Long.toString(maxMem));
        this.memInfo.setAttributeNS(NS, PREFIX + ":" + "VirtualAvailable", Long.toString(maxMem - totalMem));
        this.osInfo.setAttributeNS(NS, PREFIX + ":" + "Name", System.getProperty("os.name"));
        this.osInfo.setAttributeNS(NS, PREFIX + ":" + "Version", System.getProperty("os.version"));
        this.osInfo.setAttributeNS(NS, PREFIX + ":" + "Architecture", System.getProperty("os.arch"));
    }

    protected void updateFileSystemInfo() throws Exception {
        int i;
        if (this.drives == null) {
            this.drives = new ArrayList();
        }
        File[] fileSystems = File.listRoots();
        for (i = 0; i < fileSystems.length; ++i) {
            Element fileSystem;
            if (i < this.drives.size()) {
                fileSystem = (Element)this.drives.get(i);
            } else {
                fileSystem = this.doc.createElementNS(NS, PREFIX + ":" + "FileSystem");
                this.docRoot.appendChild(fileSystem);
                this.drives.add(fileSystem);
            }
            fileSystem.setAttributeNS(NS, PREFIX + ":" + "Name", fileSystems[i].getAbsolutePath());
        }
        for (i = this.drives.size(); i > fileSystems.length; --i) {
            Element el = (Element)this.drives.remove(i - 1);
            el.getParentNode().removeChild(el);
        }
    }

    private void init() throws Exception {
        this.isDebug = logger.isDebugEnabled();
        this.docRoot = this.doc.createElementNS(NS, PREFIX + ":" + "Host");
        this.doc.appendChild(this.docRoot);
        this.osInfo = this.doc.createElementNS(NS, PREFIX + ":" + "OperatingSystem");
        this.docRoot.appendChild(this.osInfo);
        this.cpuInfo = this.doc.createElementNS(NS, PREFIX + ":" + "Processor");
        this.docRoot.appendChild(this.cpuInfo);
        this.memInfo = this.doc.createElementNS(NS, PREFIX + ":" + "MainMemory");
        this.docRoot.appendChild(this.memInfo);
        this.docRoot.setAttributeNS(NS, PREFIX + ":" + "Name", InetAddress.getLocalHost().getHostName());
        this.docRoot.setAttributeNS(NS, PREFIX + ":" + "UniqueID", InetAddress.getLocalHost().getHostAddress());
        this.docRoot.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", PREFIX + ":" + "HostType");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

