/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp.rpprovider;

import commonj.timers.TimerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.usefulrp.rpprovider.ResourcePropertyElementTransform;
import org.globus.mds.usefulrp.rpprovider.ResourcePropertyProviderListener;
import org.globus.mds.usefulrp.rpprovider.ResourcePropertyProviderTask;
import org.globus.mds.usefulrp.types.ResourcePropertyElementProducerConfig;
import org.globus.mds.usefulrp.types.ResourcePropertyProviderConfig;
import org.globus.wsrf.impl.timer.TimerManagerImpl;
import org.w3c.dom.Element;

public class TransformElementListener
implements ResourcePropertyProviderListener {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$rpprovider$TransformElementListener == null ? (class$org$globus$mds$usefulrp$rpprovider$TransformElementListener = TransformElementListener.class$("org.globus.mds.usefulrp.rpprovider.TransformElementListener")) : class$org$globus$mds$usefulrp$rpprovider$TransformElementListener).getName());
    private Object object = null;
    private ResourcePropertyElementTransform transform = null;
    private String[] transformArgs = null;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$TransformElementListener;

    public TransformElementListener(String transformClass, String[] transformArgs) {
        if (transformClass == null) {
            return;
        }
        try {
            Class<?> cls = Class.forName(transformClass.trim());
            this.transform = (ResourcePropertyElementTransform)cls.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to create instance of transform class " + transformClass + ": " + e));
        }
        String[] trimmedArgs = null;
        if (transformArgs != null && transformArgs.length > 0) {
            trimmedArgs = new String[transformArgs.length];
            for (int i = 0; i < transformArgs.length; ++i) {
                trimmedArgs[i] = transformArgs[i].trim();
            }
        }
        this.transformArgs = trimmedArgs;
    }

    public Object getObject() {
        return this.object;
    }

    public void executionPerformed(Element element) throws Exception {
        this.object = this.transform != null ? this.transform.transformElement(element, this.transformArgs) : element;
    }

    public static TransformElementListener[] scheduleListeners(ResourcePropertyProviderConfig config, TimerManagerImpl timerManager) {
        ResourcePropertyElementProducerConfig[] producers = config.getResourcePropertyElementProducers();
        if (producers == null || producers != null && producers.length == 0) {
            logger.warn((Object)"No ResourcePropertyElementProducers specified in configuration");
            return null;
        }
        TransformElementListener[] listeners = new TransformElementListener[producers.length];
        for (int i = 0; i < producers.length; ++i) {
            int period = 0;
            Integer integer = producers[i].getPeriod();
            if (integer != null) {
                period = integer * 1000;
            }
            try {
                listeners[i] = new TransformElementListener(producers[i].getTransformClass(), producers[i].getTransformArguments());
                ResourcePropertyProviderTask task = new ResourcePropertyProviderTask(producers[i], listeners[i]);
                if (period > 0) {
                    task.setTimer(timerManager.schedule((TimerListener)task, 0L, (long)period));
                    continue;
                }
                task.setTimer(timerManager.schedule((TimerListener)task, 0L));
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Exception while creating provider task for " + producers[i].getClassName() + "; the task will not be scheduled. Exception was: " + e));
            }
        }
        return listeners;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

