/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp.rpprovider;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.usefulrp.types.ResourcePropertyProviderConfig;
import org.globus.mds.usefulrp.types.ResourcePropertyProviderConfigArray;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.utils.ContextUtils;
import org.xml.sax.InputSource;

public class ResourcePropertyProviderCollection {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$rpprovider$ResourcePropertyProviderCollection == null ? (class$org$globus$mds$usefulrp$rpprovider$ResourcePropertyProviderCollection = ResourcePropertyProviderCollection.class$("org.globus.mds.usefulrp.rpprovider.ResourcePropertyProviderCollection")) : class$org$globus$mds$usefulrp$rpprovider$ResourcePropertyProviderCollection).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = ResourcePropertyProviderCollection.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    public static final String CONFIG_FILE = "rpProviderConfigFile";
    private String configFile;
    private ResourcePropertySet rpSet;
    private boolean initialized = false;
    private ArrayList collection = new ArrayList();
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$ResourcePropertyProviderCollection;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$BaseResourcePropertyProvider;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfig;
    static /* synthetic */ Class class$org$globus$wsrf$impl$BaseResourceProperty;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$org$globus$wsrf$ResourceProperty;
    static /* synthetic */ Class class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfigArray;

    public ResourcePropertyProviderCollection() {
        MessageContext ctx = MessageContext.getCurrentContext();
        this.configFile = ContainerConfig.getBaseDirectory() + "/" + (String)ContextUtils.getServiceProperty((MessageContext)ctx, (String)CONFIG_FILE);
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("resourceDisoveryFailed"), (Throwable)e);
            return;
        }
        if (!(resource instanceof ResourceProperties)) {
            logger.error((Object)i18n.getMessage("rpsNotSupported"));
            return;
        }
        this.rpSet = ((ResourceProperties)resource).getResourcePropertySet();
        try {
            this.initialize();
        }
        catch (Exception e) {
            logger.warn((Object)("Could not initialize ResourcePropertyProviderCollection:" + e));
        }
    }

    public ResourcePropertyProviderCollection(String configFile, ResourcePropertySet rpSet, boolean initialize) {
        this.configFile = configFile;
        this.rpSet = rpSet;
        if (!initialize) {
            return;
        }
        try {
            this.initialize();
        }
        catch (Exception e) {
            logger.warn((Object)("Could not initialize ResourcePropertyProviderCollection:" + e));
        }
    }

    public void initialize() throws Exception {
        if (!this.processConfig()) {
            return;
        }
        ResourceProperty rp = null;
        String rpImpl = null;
        Iterator iter = this.collection.iterator();
        while (iter.hasNext()) {
            ResourcePropertyProviderConfig config = (ResourcePropertyProviderConfig)iter.next();
            try {
                Constructor<?> con;
                Class<?> cls;
                rpImpl = config.getResourcePropertyImpl();
                if (rpImpl == null) {
                    throw new IllegalArgumentException("ResourceProperty implementation class name cannot be null!");
                }
                if ((class$org$globus$mds$usefulrp$rpprovider$BaseResourcePropertyProvider == null ? ResourcePropertyProviderCollection.class$("org.globus.mds.usefulrp.rpprovider.BaseResourcePropertyProvider") : class$org$globus$mds$usefulrp$rpprovider$BaseResourcePropertyProvider).isAssignableFrom(cls = Class.forName(rpImpl.trim()))) {
                    con = cls.getConstructor(class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfig == null ? ResourcePropertyProviderCollection.class$("org.globus.mds.usefulrp.types.ResourcePropertyProviderConfig") : class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfig);
                    rp = (ResourceProperty)con.newInstance(config);
                } else if ((class$org$globus$wsrf$impl$BaseResourceProperty == null ? ResourcePropertyProviderCollection.class$("org.globus.wsrf.impl.BaseResourceProperty") : class$org$globus$wsrf$impl$BaseResourceProperty).isAssignableFrom(cls)) {
                    con = cls.getConstructor(class$javax$xml$namespace$QName == null ? ResourcePropertyProviderCollection.class$("javax.xml.namespace.QName") : class$javax$xml$namespace$QName);
                    rp = (ResourceProperty)con.newInstance(config.getResourcePropertyName());
                } else if ((class$org$globus$wsrf$ResourceProperty == null ? ResourcePropertyProviderCollection.class$("org.globus.wsrf.ResourceProperty") : class$org$globus$wsrf$ResourceProperty).isAssignableFrom(cls)) {
                    rp = (ResourceProperty)cls.newInstance();
                } else {
                    throw new Exception("Unsupported RP implementation class " + rpImpl + " does not implement any of the required interfaces");
                }
                this.rpSet.add(rp);
            }
            catch (Exception e) {
                logger.error((Object)("Exception during ResourceProperty class instantiation: " + e));
                logger.warn((Object)("The resource property " + config.getResourcePropertyName().toString() + " will not be available"));
            }
        }
    }

    private boolean processConfig() {
        boolean validConfig = false;
        try {
            ResourcePropertyProviderConfigArray config = (ResourcePropertyProviderConfigArray)ObjectDeserializer.deserialize((InputSource)new InputSource(new FileInputStream(this.configFile)), (Class)(class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfigArray == null ? (class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfigArray = ResourcePropertyProviderCollection.class$("org.globus.mds.usefulrp.types.ResourcePropertyProviderConfigArray")) : class$org$globus$mds$usefulrp$types$ResourcePropertyProviderConfigArray));
            ResourcePropertyProviderConfig[] array = config.getConfigArray();
            if (array == null || array.length < 1) {
                throw new Exception("No valid configuration elements found");
            }
            for (int i = 0; i < array.length; ++i) {
                this.collection.add(array[i]);
            }
            validConfig = true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while processing configuration file, some Resource Properties may not be available: ", (Throwable)e);
        }
        return validConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

