/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp.rpprovider;

import java.io.FileWriter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.usefulrp.types.ResourcePropertyElementProducerConfig;
import org.globus.mds.usefulrp.types.ResourcePropertyProviderConfig;
import org.globus.mds.usefulrp.types.ResourcePropertyProviderConfigArray;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GLUEResourcePropertyConfig {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$rpprovider$GLUEResourcePropertyConfig == null ? (class$org$globus$mds$usefulrp$rpprovider$GLUEResourcePropertyConfig = GLUEResourcePropertyConfig.class$("org.globus.mds.usefulrp.rpprovider.GLUEResourcePropertyConfig")) : class$org$globus$mds$usefulrp$rpprovider$GLUEResourcePropertyConfig).getName());
    static /* synthetic */ Class class$org$globus$mds$usefulrp$rpprovider$GLUEResourcePropertyConfig;

    public static void main(String[] args) throws Exception {
        String fileName = "gluerp-config.xml";
        String schedulerInfoProviderName = null;
        String clusterInfoProviderName = null;
        if (args == null || args.length < 2) {
            System.out.println();
            System.out.println("ERROR: Not enough arguments - must include at least one valid scheduler and one valid cluster information provider name or \"none\"");
            GLUEResourcePropertyConfig.usage();
            return;
        }
        if (args.length > 0) {
            schedulerInfoProviderName = args[0];
        }
        if (args.length > 1) {
            clusterInfoProviderName = args[1];
        }
        if (args.length > 2) {
            fileName = args[2];
        }
        try {
            GLUEResourcePropertyConfig.generateDefaultConfig(fileName, schedulerInfoProviderName, clusterInfoProviderName);
        }
        catch (Exception e) {
            System.out.println();
            System.out.println(e);
            GLUEResourcePropertyConfig.usage();
            return;
        }
        System.out.println();
        System.out.println("Successfuly wrote configuration output file to: " + fileName);
        System.out.println();
    }

    protected static void usage() {
        System.out.println();
        System.out.println("Usage: [scheduler info provider name | keyword none] [cluster info provider name | keyword none] [outputFile - defaults to gluerp-config.xml in the current dir]");
        System.out.println();
        System.out.println("Example: pbs ganglia");
        System.out.println("Example: none clumon");
        System.out.println("Example: fork none $GLOBUS_LOCATION/etc/gram-service-Fork/gluerp-config.xml");
        System.out.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateDefaultConfig(String fileName, String schedulerInfoProviderName, String clusterInfoProviderName) throws Exception {
        ResourcePropertyElementProducerConfig clusterProducer;
        if (fileName == null) {
            throw new IllegalArgumentException("Output filename must not be null!");
        }
        if (schedulerInfoProviderName == null && clusterInfoProviderName == null) {
            throw new IllegalArgumentException("Must provide at least one schedulerInfoProviderName or clusterInfoProviderName (or both)");
        }
        ResourcePropertyProviderConfigArray config = new ResourcePropertyProviderConfigArray();
        ResourcePropertyProviderConfig[] configArray = new ResourcePropertyProviderConfig[]{new ResourcePropertyProviderConfig()};
        configArray[0].setResourcePropertyImpl("org.globus.mds.usefulrp.rpprovider.GLUEResourceProperty");
        configArray[0].setResourcePropertyName(new QName("http://mds.globus.org/glue/ce/1.1", "mds:GLUECE"));
        ArrayList<ResourcePropertyElementProducerConfig> producers = new ArrayList<ResourcePropertyElementProducerConfig>();
        if (schedulerInfoProviderName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No cluster information provider name specified");
            }
        } else if (schedulerInfoProviderName.equalsIgnoreCase("none")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Scheduler information provider set to none");
            }
        } else {
            ResourcePropertyElementProducerConfig schedulerProducer = new ResourcePropertyElementProducerConfig();
            schedulerProducer.setClassName("org.globus.mds.usefulrp.rpprovider.producers.SchedulerInfoElementProducer");
            String baseScriptArg = "libexec/globus-scheduler-provider-";
            schedulerProducer.setArguments(new String[]{baseScriptArg + schedulerInfoProviderName.toLowerCase()});
            schedulerProducer.setPeriod(new Integer(300));
            schedulerProducer.setTransformClass("org.globus.mds.usefulrp.rpprovider.transforms.GLUESchedulerElementTransform");
            schedulerProducer.setTransformArguments(new String[0]);
            producers.add(schedulerProducer);
        }
        if (clusterInfoProviderName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No cluster information provider name specified");
            }
        } else if (clusterInfoProviderName.equalsIgnoreCase("none")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cluster information provider set to none");
            }
        } else if (clusterInfoProviderName.equalsIgnoreCase("ganglia")) {
            clusterProducer = new ResourcePropertyElementProducerConfig();
            clusterProducer.setClassName("org.globus.mds.usefulrp.glue.GangliaElementProducer");
            clusterProducer.setArguments(new String[]{"localhost", "8649"});
            clusterProducer.setPeriod(new Integer(300));
            clusterProducer.setTransformClass("org.globus.mds.usefulrp.rpprovider.transforms.GLUEComputeElementTransform");
            clusterProducer.setTransformArguments(new String[0]);
            producers.add(clusterProducer);
        } else if (clusterInfoProviderName.equalsIgnoreCase("clumon")) {
            clusterProducer = new ResourcePropertyElementProducerConfig();
            clusterProducer.setClassName("org.globus.mds.usefulrp.rpprovider.producers.URLElementProducer");
            clusterProducer.setArguments(new String[]{"http://localhost/glue.php"});
            clusterProducer.setPeriod(new Integer(300));
            clusterProducer.setTransformClass("org.globus.mds.usefulrp.rpprovider.transforms.GLUEComputeElementTransform");
            clusterProducer.setTransformArguments(new String[]{"./etc/globus_wsrf_mds_usefulrp/cluster_config.xml"});
            producers.add(clusterProducer);
        } else {
            if (!clusterInfoProviderName.equalsIgnoreCase("nagios")) throw new IllegalArgumentException("Unknown cluster information provider type: " + clusterInfoProviderName);
            clusterProducer = new ResourcePropertyElementProducerConfig();
            clusterProducer.setClassName("org.globus.mds.usefulrp.rpprovider.producers.ExternalProcessElementProducer");
            String globusLoc = System.getProperty("GLOBUS_LOCATION");
            clusterProducer.setArguments(new String[]{(globusLoc == null ? "." : globusLoc) + "/libexec/globus-mds-cluster-nagios"});
            clusterProducer.setPeriod(new Integer(300));
            producers.add(clusterProducer);
        }
        configArray[0].setResourcePropertyElementProducers(producers.toArray(new ResourcePropertyElementProducerConfig[0]));
        config.setConfigArray(configArray);
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
        String comment = "<!-- Configuration file for the MDS GLUECE resource property provider -->\n\n";
        Element element = ObjectSerializer.toElement((Object)config, (QName)config.getTypeDesc().getXmlType());
        String output = header + comment + XMLUtils.PrettyDocumentToString((Document)element.getOwnerDocument());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)output);
        }
        FileWriter filewriter = null;
        try {
            filewriter = new FileWriter(fileName);
            filewriter.write(output);
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            try {
                if (filewriter == null) throw throwable;
                filewriter.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (filewriter == null) return;
        filewriter.close();
        return;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

