/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.usefulrp;

import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.usefulrp.types.Accumulator;
import org.globus.mds.usefulrp.types.ExponentialRate;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;

public class AccumulatorResourceProperty
extends ReflectionResourceProperty {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$usefulrp$AccumulatorResourceProperty == null ? (class$org$globus$mds$usefulrp$AccumulatorResourceProperty = AccumulatorResourceProperty.class$("org.globus.mds.usefulrp.AccumulatorResourceProperty")) : class$org$globus$mds$usefulrp$AccumulatorResourceProperty).getName());
    Accumulator publishedValue = new Accumulator();
    Date lastCalculation = new Date();
    static /* synthetic */ Class class$org$globus$mds$usefulrp$AccumulatorResourceProperty;

    public AccumulatorResourceProperty(QName name) throws Exception {
        super((ResourcePropertyMetaData)new SimpleResourcePropertyMetaData(name));
        this.setObject((Object)this);
        this.setPropertyName("DynamicValue");
        this.initialize();
        this.publishedValue.setStartTime(Calendar.getInstance());
        this.publishedValue.setLastChange(Calendar.getInstance());
        ExponentialRate[] rates = new ExponentialRate[]{AccumulatorResourceProperty.getExponentialRate(60L), AccumulatorResourceProperty.getExponentialRate(3600L), AccumulatorResourceProperty.getExponentialRate(86400L)};
        this.publishedValue.setExpRate(rates);
    }

    private static ExponentialRate getExponentialRate(long decay) {
        ExponentialRate rate = new ExponentialRate();
        rate.setDecay(decay);
        rate.setRate(0.0);
        return rate;
    }

    public Object getDynamicValue() {
        logger.debug((Object)"Performing decay calc. to zero.");
        this.performDecays(0.0);
        return this.publishedValue;
    }

    public void accumulate(long amount) {
        logger.debug((Object)("Accumulating " + amount));
        long total = this.publishedValue.getTotal();
        this.publishedValue.setTotal(total += amount);
        this.publishedValue.setLastChange(Calendar.getInstance());
        this.performDecays(amount);
    }

    void performDecays(double q) {
        ExponentialRate[] rates = this.publishedValue.getExpRate();
        Date now = new Date();
        for (int i = 0; i < rates.length; ++i) {
            ExponentialRate rate = rates[i];
            double decayPeriod = rate.getDecay();
            double decayConstant = 1.0 - Math.exp(-1.0 / decayPeriod);
            double decayPerUnitTime = 1.0 - decayConstant;
            double deltaTms = now.getTime() - this.lastCalculation.getTime();
            double deltaTs = deltaTms / 1000.0;
            double decayForThisReading = Math.pow(1.0 - decayConstant, deltaTs);
            if (decayForThisReading + decayConstant > 1.0) {
                logger.debug((Object)("Decay constants sum to " + (decayForThisReading + decayConstant) + " when they should sum to <= 1.0"));
            }
            rate.setRate(rate.getRate() * decayForThisReading + q * decayConstant);
        }
        this.lastCalculation = now;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

